/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.packet.Stanza;
import org.junit.Assert;
import org.junit.Test;

public class PacketCollectorTest {
    @Test
    public void verifyRollover() {
        TestPacket testPacket;
        int i;
        TestPacketCollector collector = new TestPacketCollector(null, new OKEverything(), 5);
        for (i = 0; i < 6; ++i) {
            testPacket = new TestPacket(i);
            collector.processPacket(testPacket);
        }
        Assert.assertEquals((Object)"1", (Object)collector.nextResultBlockForever().getStanzaId());
        Assert.assertEquals((Object)"2", (Object)collector.nextResultBlockForever().getStanzaId());
        Assert.assertEquals((Object)"3", (Object)collector.nextResultBlockForever().getStanzaId());
        Assert.assertEquals((Object)"4", (Object)collector.nextResultBlockForever().getStanzaId());
        Assert.assertEquals((Object)"5", (Object)collector.pollResult().getStanzaId());
        Assert.assertNull((Object)collector.pollResult());
        for (i = 10; i < 15; ++i) {
            testPacket = new TestPacket(i);
            collector.processPacket(testPacket);
        }
        Assert.assertEquals((Object)"10", (Object)collector.nextResultBlockForever().getStanzaId());
        Assert.assertEquals((Object)"11", (Object)collector.nextResultBlockForever().getStanzaId());
        Assert.assertEquals((Object)"12", (Object)collector.nextResultBlockForever().getStanzaId());
        Assert.assertEquals((Object)"13", (Object)collector.nextResultBlockForever().getStanzaId());
        Assert.assertEquals((Object)"14", (Object)collector.pollResult().getStanzaId());
        Assert.assertNull((Object)collector.pollResult());
        Assert.assertNull((Object)collector.nextResult(1000L));
    }

    @Test
    public void verifyThreadSafety() {
        int insertCount = 500;
        final TestPacketCollector collector = new TestPacketCollector(null, new OKEverything(), insertCount);
        Thread consumer1 = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (true) {
                        try {
                            Thread.sleep(3L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        Stanza stanza = collector.nextResultBlockForever();
                    }
                }
                catch (RuntimeException re) {
                    if (re.getCause() instanceof InterruptedException) {
                        // empty if block
                    }
                    return;
                }
            }
        });
        consumer1.setName("consumer 1");
        Thread consumer2 = new Thread(new Runnable(){

            @Override
            public void run() {
                Stanza p = null;
                do {
                    try {
                        Thread.sleep(3L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while ((p = collector.nextResult(1L)) != null);
            }
        });
        consumer2.setName("consumer 2");
        Thread consumer3 = new Thread(new Runnable(){

            @Override
            public void run() {
                Stanza p = null;
                do {
                    try {
                        Thread.sleep(3L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while ((p = collector.pollResult()) != null);
            }
        });
        consumer3.setName("consumer 3");
        consumer1.start();
        consumer2.start();
        consumer3.start();
        for (int i = 0; i < insertCount; ++i) {
            collector.processPacket(new TestPacket(i));
        }
        try {
            Thread.sleep(5000L);
            consumer3.join();
            consumer2.join();
            consumer1.interrupt();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertNull((Object)collector.pollResult());
    }

    class TestPacket
    extends Stanza {
        public TestPacket(int i) {
            this.setStanzaId(String.valueOf(i));
        }

        public String toXML() {
            return "<packetId>" + this.getStanzaId() + "</packetId>";
        }
    }

    class TestPacketCollector
    extends PacketCollector {
        protected TestPacketCollector(XMPPConnection conection, StanzaFilter packetFilter, int size) {
            super(conection, PacketCollector.newConfiguration().setStanzaFilter(packetFilter).setSize(size));
        }
    }

    class OKEverything
    implements StanzaFilter {
        OKEverything() {
        }

        public boolean accept(Stanza packet) {
            return true;
        }
    }
}

