/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.io.IOException;
import java.util.Date;
import java.util.Random;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.PlainStreamElement;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.TopLevelStreamElement;
import org.jxmpp.jid.FullJid;
import org.jxmpp.jid.JidTestUtil;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.stringprep.XmppStringprepException;

public class DummyConnection
extends AbstractXMPPConnection {
    private boolean reconnect = false;
    private final BlockingQueue<TopLevelStreamElement> queue = new LinkedBlockingQueue<TopLevelStreamElement>();

    public static ConnectionConfiguration.Builder<?, ?> getDummyConfigurationBuilder() {
        return ((DummyConnectionConfiguration.Builder)DummyConnectionConfiguration.builder().setServiceName(JidTestUtil.EXAMPLE_ORG)).setUsernameAndPassword("dummy", "dummypass");
    }

    public DummyConnection() {
        this(DummyConnection.getDummyConfigurationBuilder().build());
    }

    private FullJid getUserJid() {
        try {
            return JidCreate.fullFrom((String)(this.config.getUsername() + "@" + this.config.getServiceName() + "/" + (this.config.getResource() != null ? this.config.getResource() : "Test")));
        }
        catch (XmppStringprepException e) {
            throw new IllegalStateException(e);
        }
    }

    public DummyConnection(ConnectionConfiguration configuration) {
        super(configuration);
        for (ConnectionCreationListener listener : XMPPConnectionRegistry.getConnectionCreationListeners()) {
            listener.connectionCreated((XMPPConnection)this);
        }
        this.user = this.getUserJid();
    }

    protected void connectInternal() {
        this.connected = true;
        this.streamId = "dummy-" + new Random(new Date().getTime()).nextInt();
        if (this.reconnect) {
            this.notifyReconnection();
        }
    }

    protected void shutdown() {
        this.user = null;
        this.authenticated = false;
        this.callConnectionClosedListener();
        this.reconnect = true;
    }

    public boolean isSecureConnection() {
        return false;
    }

    public boolean isUsingCompression() {
        return false;
    }

    protected void loginNonAnonymously(String username, String password, String resource) throws XMPPException {
        this.user = this.getUserJid();
        this.authenticated = true;
    }

    public void loginAnonymously() throws XMPPException {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected to server.");
        }
        if (this.isAuthenticated()) {
            throw new IllegalStateException("Already logged in to server.");
        }
        this.authenticated = true;
    }

    public void send(PlainStreamElement element) {
        if (SmackConfiguration.DEBUG) {
            System.out.println("[SEND]: " + element.toXML());
        }
        this.queue.add((TopLevelStreamElement)element);
    }

    protected void sendStanzaInternal(Stanza packet) {
        if (SmackConfiguration.DEBUG) {
            System.out.println("[SEND]: " + packet.toXML());
        }
        this.queue.add((TopLevelStreamElement)packet);
    }

    public int getNumberOfSentPackets() {
        return this.queue.size();
    }

    public <P extends TopLevelStreamElement> P getSentPacket() {
        return this.getSentPacket(300);
    }

    public <P extends TopLevelStreamElement> P getSentPacket(int wait) {
        try {
            return (P)this.queue.poll(wait, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    public void processPacket(Stanza packet) {
        if (SmackConfiguration.DEBUG) {
            System.out.println("[RECV]: " + packet.toXML());
        }
        this.invokePacketCollectorsAndNotifyRecvListeners(packet);
    }

    public static DummyConnection newConnectedDummyConnection() {
        DummyConnection dummyConnection = new DummyConnection();
        try {
            dummyConnection.connect();
            dummyConnection.login();
        }
        catch (IOException | InterruptedException | SmackException | XMPPException e) {
            throw new IllegalStateException(e);
        }
        return dummyConnection;
    }

    public static class DummyConnectionConfiguration
    extends ConnectionConfiguration {
        protected DummyConnectionConfiguration(Builder builder) {
            super((ConnectionConfiguration.Builder)builder);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends ConnectionConfiguration.Builder<Builder, DummyConnectionConfiguration> {
            private Builder() {
            }

            public DummyConnectionConfiguration build() {
                return new DummyConnectionConfiguration(this);
            }

            protected Builder getThis() {
                return this;
            }
        }
    }
}

