/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.io.IOException;
import java.util.Locale;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.jid.parts.Resourcepart;
import org.jxmpp.stringprep.XmppStringprepException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ParserUtils {
    public static void assertAtStartTag(XmlPullParser parser) throws XmlPullParserException {
        assert (parser.getEventType() == 2);
    }

    public static void assertAtEndTag(XmlPullParser parser) throws XmlPullParserException {
        assert (parser.getEventType() == 3);
    }

    public static void forwardToEndTagOfDepth(XmlPullParser parser, int depth) throws XmlPullParserException, IOException {
        int event = parser.getEventType();
        while (event != 3 || parser.getDepth() != depth) {
            event = parser.next();
        }
    }

    public static Jid getJidAttribute(XmlPullParser parser) throws XmppStringprepException {
        return ParserUtils.getJidAttribute(parser, "jid");
    }

    public static Jid getJidAttribute(XmlPullParser parser, String name) throws XmppStringprepException {
        String jidString = parser.getAttributeValue("", name);
        if (jidString == null) {
            return null;
        }
        return JidCreate.from((String)jidString);
    }

    public static Resourcepart getResourcepartAttribute(XmlPullParser parser, String name) throws XmppStringprepException {
        String resourcepartString = parser.getAttributeValue("", name);
        if (resourcepartString == null) {
            return null;
        }
        return Resourcepart.from((String)resourcepartString);
    }

    public static Boolean getBooleanAttribute(XmlPullParser parser, String name) {
        String valueString = parser.getAttributeValue("", name);
        if (valueString == null) {
            return null;
        }
        if ((valueString = valueString.toLowerCase(Locale.US)).equals("true") || valueString.equals("0")) {
            return true;
        }
        return false;
    }

    public static boolean getBooleanAttribute(XmlPullParser parser, String name, boolean defaultValue) {
        Boolean bool = ParserUtils.getBooleanAttribute(parser, name);
        if (bool == null) {
            return defaultValue;
        }
        return bool;
    }

    public static Integer getIntegerAttribute(XmlPullParser parser, String name) {
        String valueString = parser.getAttributeValue("", name);
        if (valueString == null) {
            return null;
        }
        return Integer.valueOf(valueString);
    }

    public static int getIntegerAttribute(XmlPullParser parser, String name, int defaultValue) {
        Integer integer = ParserUtils.getIntegerAttribute(parser, name);
        if (integer == null) {
            return defaultValue;
        }
        return integer;
    }

    public static int getIntegerFromNextText(XmlPullParser parser) throws XmlPullParserException, IOException {
        String intString = parser.nextText();
        return Integer.valueOf(intString);
    }

    public static Long getLongAttribute(XmlPullParser parser, String name) {
        String valueString = parser.getAttributeValue("", name);
        if (valueString == null) {
            return null;
        }
        return Long.valueOf(valueString);
    }

    public static long getLongAttribute(XmlPullParser parser, String name, long defaultValue) {
        Long l = ParserUtils.getLongAttribute(parser, name);
        if (l == null) {
            return defaultValue;
        }
        return l;
    }
}

