/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import org.jivesoftware.smack.util.StringUtils;
import org.junit.Assert;
import org.junit.Test;

public class StringUtilsTest {
    @Test
    public void testEscapeForXML() {
        String input = null;
        Assert.assertNull((Object)StringUtils.escapeForXML(null));
        input = "<b>";
        StringUtilsTest.assertCharSequenceEquals("&lt;b&gt;", StringUtils.escapeForXML((CharSequence)input));
        input = "\"";
        StringUtilsTest.assertCharSequenceEquals("&quot;", StringUtils.escapeForXML((CharSequence)input));
        input = "&";
        StringUtilsTest.assertCharSequenceEquals("&amp;", StringUtils.escapeForXML((CharSequence)input));
        input = "<b>\n\t\r</b>";
        StringUtilsTest.assertCharSequenceEquals("&lt;b&gt;\n\t\r&lt;/b&gt;", StringUtils.escapeForXML((CharSequence)input));
        input = "   &   ";
        StringUtilsTest.assertCharSequenceEquals("   &amp;   ", StringUtils.escapeForXML((CharSequence)input));
        input = "   \"   ";
        StringUtilsTest.assertCharSequenceEquals("   &quot;   ", StringUtils.escapeForXML((CharSequence)input));
        input = "> of me <";
        StringUtilsTest.assertCharSequenceEquals("&gt; of me &lt;", StringUtils.escapeForXML((CharSequence)input));
        input = "> of me & you<";
        StringUtilsTest.assertCharSequenceEquals("&gt; of me &amp; you&lt;", StringUtils.escapeForXML((CharSequence)input));
        input = "& <";
        StringUtilsTest.assertCharSequenceEquals("&amp; &lt;", StringUtils.escapeForXML((CharSequence)input));
        input = "&";
        StringUtilsTest.assertCharSequenceEquals("&amp;", StringUtils.escapeForXML((CharSequence)input));
        input = "It's a good day today";
        StringUtilsTest.assertCharSequenceEquals("It&apos;s a good day today", StringUtils.escapeForXML((CharSequence)input));
    }

    public static void assertCharSequenceEquals(CharSequence expected, CharSequence actual) {
        Assert.assertEquals((Object)expected.toString(), (Object)actual.toString());
    }

    @Test
    public void testEncodeHex() {
        String input = "";
        String output = "";
        Assert.assertEquals((Object)new String(StringUtils.encodeHex((byte[])input.getBytes())), (Object)new String(output.getBytes()));
        input = "foo bar 123";
        output = "666f6f2062617220313233";
        Assert.assertEquals((Object)new String(StringUtils.encodeHex((byte[])input.getBytes())), (Object)new String(output.getBytes()));
    }

    @Test
    public void testRandomString() {
        String result = StringUtils.randomString((int)-1);
        Assert.assertNull((Object)result);
        result = StringUtils.randomString((int)0);
        Assert.assertNull((Object)result);
        result = StringUtils.randomString((int)4);
        Assert.assertTrue((result.length() == 4 ? 1 : 0) != 0);
        result = StringUtils.randomString((int)16);
        Assert.assertTrue((result.length() == 16 ? 1 : 0) != 0);
        result = StringUtils.randomString((int)128);
        Assert.assertTrue((result.length() == 128 ? 1 : 0) != 0);
    }
}

