/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.security.auth.callback.CallbackHandler;
import org.jivesoftware.smack.SASLAuthentication;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.proxy.ProxyInfo;
import org.jivesoftware.smack.util.CollectionUtil;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.StringUtils;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.parts.Resourcepart;
import org.jxmpp.stringprep.XmppStringprepException;

public abstract class ConnectionConfiguration {
    protected final DomainBareJid xmppServiceDomain;
    protected final String host;
    protected final int port;
    private final String keystorePath;
    private final String keystoreType;
    private final String pkcs11Library;
    private final SSLContext customSSLContext;
    private final CallbackHandler callbackHandler;
    private final boolean debuggerEnabled;
    private final SocketFactory socketFactory;
    private final CharSequence username;
    private final String password;
    private final Resourcepart resource;
    private final EntityBareJid authzid;
    private final boolean sendPresence;
    private final boolean legacySessionDisabled;
    private final SecurityMode securityMode;
    private final String[] enabledSSLProtocols;
    private final String[] enabledSSLCiphers;
    private final HostnameVerifier hostnameVerifier;
    protected final ProxyInfo proxy;
    protected final boolean allowNullOrEmptyUsername;
    private final Set<String> enabledSaslMechanisms;

    protected ConnectionConfiguration(Builder<?, ?> builder) {
        this.authzid = ((Builder)builder).authzid;
        this.username = ((Builder)builder).username;
        this.password = ((Builder)builder).password;
        this.callbackHandler = ((Builder)builder).callbackHandler;
        this.resource = ((Builder)builder).resource;
        this.xmppServiceDomain = ((Builder)builder).xmppServiceDomain;
        if (this.xmppServiceDomain == null) {
            throw new IllegalArgumentException("Must define the XMPP domain");
        }
        this.host = ((Builder)builder).host;
        this.port = ((Builder)builder).port;
        this.proxy = ((Builder)builder).proxy;
        this.socketFactory = ((Builder)builder).socketFactory;
        this.securityMode = ((Builder)builder).securityMode;
        this.keystoreType = ((Builder)builder).keystoreType;
        this.keystorePath = ((Builder)builder).keystorePath;
        this.pkcs11Library = ((Builder)builder).pkcs11Library;
        this.customSSLContext = ((Builder)builder).customSSLContext;
        this.enabledSSLProtocols = ((Builder)builder).enabledSSLProtocols;
        this.enabledSSLCiphers = ((Builder)builder).enabledSSLCiphers;
        this.hostnameVerifier = ((Builder)builder).hostnameVerifier;
        this.sendPresence = ((Builder)builder).sendPresence;
        this.legacySessionDisabled = ((Builder)builder).legacySessionDisabled;
        this.debuggerEnabled = ((Builder)builder).debuggerEnabled;
        this.allowNullOrEmptyUsername = ((Builder)builder).allowEmptyOrNullUsername;
        this.enabledSaslMechanisms = ((Builder)builder).enabledSaslMechanisms;
        assert (this.enabledSaslMechanisms == null || !this.enabledSaslMechanisms.isEmpty());
    }

    @Deprecated
    public DomainBareJid getServiceName() {
        return this.xmppServiceDomain;
    }

    public DomainBareJid getXMPPServiceDomain() {
        return this.xmppServiceDomain;
    }

    public SecurityMode getSecurityMode() {
        return this.securityMode;
    }

    public String getKeystorePath() {
        return this.keystorePath;
    }

    public String getKeystoreType() {
        return this.keystoreType;
    }

    public String getPKCS11Library() {
        return this.pkcs11Library;
    }

    public SSLContext getCustomSSLContext() {
        return this.customSSLContext;
    }

    public String[] getEnabledSSLProtocols() {
        return this.enabledSSLProtocols;
    }

    public String[] getEnabledSSLCiphers() {
        return this.enabledSSLCiphers;
    }

    public HostnameVerifier getHostnameVerifier() {
        if (this.hostnameVerifier != null) {
            return this.hostnameVerifier;
        }
        return SmackConfiguration.getDefaultHostnameVerifier();
    }

    public boolean isDebuggerEnabled() {
        return this.debuggerEnabled;
    }

    @Deprecated
    public boolean isLegacySessionDisabled() {
        return this.legacySessionDisabled;
    }

    public CallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public ProxyInfo getProxyInfo() {
        return this.proxy;
    }

    public CharSequence getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public Resourcepart getResource() {
        return this.resource;
    }

    public EntityBareJid getAuthzid() {
        return this.authzid;
    }

    public boolean isSendPresence() {
        return this.sendPresence;
    }

    public boolean isCompressionEnabled() {
        return false;
    }

    public boolean isEnabledSaslMechanism(String saslMechanism) {
        if (this.enabledSaslMechanisms == null) {
            return true;
        }
        return this.enabledSaslMechanisms.contains(saslMechanism);
    }

    public Set<String> getEnabledSaslMechanisms() {
        return Collections.unmodifiableSet(this.enabledSaslMechanisms);
    }

    static {
        SmackConfiguration.getVersion();
    }

    public static abstract class Builder<B extends Builder<B, C>, C extends ConnectionConfiguration> {
        private SecurityMode securityMode = SecurityMode.ifpossible;
        private String keystorePath = System.getProperty("javax.net.ssl.keyStore");
        private String keystoreType = "jks";
        private String pkcs11Library = "pkcs11.config";
        private SSLContext customSSLContext;
        private String[] enabledSSLProtocols;
        private String[] enabledSSLCiphers;
        private HostnameVerifier hostnameVerifier;
        private EntityBareJid authzid;
        private CharSequence username;
        private String password;
        private Resourcepart resource;
        private boolean sendPresence = true;
        private boolean legacySessionDisabled = false;
        private ProxyInfo proxy;
        private CallbackHandler callbackHandler;
        private boolean debuggerEnabled = SmackConfiguration.DEBUG;
        private SocketFactory socketFactory;
        private DomainBareJid xmppServiceDomain;
        private String host;
        private int port = 5222;
        private boolean allowEmptyOrNullUsername = false;
        private boolean saslMechanismsSealed;
        private Set<String> enabledSaslMechanisms;

        protected Builder() {
        }

        public B setUsernameAndPassword(CharSequence username, String password) {
            this.username = username;
            this.password = password;
            return this.getThis();
        }

        @Deprecated
        public B setServiceName(DomainBareJid serviceName) {
            return this.setXmppDomain(serviceName);
        }

        public B setXmppDomain(DomainBareJid xmppServiceDomain) {
            this.xmppServiceDomain = xmppServiceDomain;
            return this.getThis();
        }

        public B setResource(Resourcepart resource) {
            this.resource = resource;
            return this.getThis();
        }

        public B setResource(CharSequence resource) throws XmppStringprepException {
            Objects.requireNonNull(resource, "resource must not be null");
            return this.setResource(Resourcepart.from((String)resource.toString()));
        }

        public B setHost(String host) {
            this.host = host;
            return this.getThis();
        }

        public B setPort(int port) {
            this.port = port;
            return this.getThis();
        }

        public B setCallbackHandler(CallbackHandler callbackHandler) {
            this.callbackHandler = callbackHandler;
            return this.getThis();
        }

        public B setSecurityMode(SecurityMode securityMode) {
            this.securityMode = securityMode;
            return this.getThis();
        }

        public B setKeystorePath(String keystorePath) {
            this.keystorePath = keystorePath;
            return this.getThis();
        }

        public B setKeystoreType(String keystoreType) {
            this.keystoreType = keystoreType;
            return this.getThis();
        }

        public B setPKCS11Library(String pkcs11Library) {
            this.pkcs11Library = pkcs11Library;
            return this.getThis();
        }

        public B setCustomSSLContext(SSLContext context) {
            this.customSSLContext = Objects.requireNonNull(context, "The SSLContext must not be null");
            return this.getThis();
        }

        public B setEnabledSSLProtocols(String[] enabledSSLProtocols) {
            this.enabledSSLProtocols = enabledSSLProtocols;
            return this.getThis();
        }

        public B setEnabledSSLCiphers(String[] enabledSSLCiphers) {
            this.enabledSSLCiphers = enabledSSLCiphers;
            return this.getThis();
        }

        public B setHostnameVerifier(HostnameVerifier verifier) {
            this.hostnameVerifier = verifier;
            return this.getThis();
        }

        @Deprecated
        public B setLegacySessionDisabled(boolean legacySessionDisabled) {
            this.legacySessionDisabled = legacySessionDisabled;
            return this.getThis();
        }

        public B setSendPresence(boolean sendPresence) {
            this.sendPresence = sendPresence;
            return this.getThis();
        }

        public B setDebuggerEnabled(boolean debuggerEnabled) {
            this.debuggerEnabled = debuggerEnabled;
            return this.getThis();
        }

        public B setSocketFactory(SocketFactory socketFactory) {
            this.socketFactory = socketFactory;
            return this.getThis();
        }

        public B setProxyInfo(ProxyInfo proxyInfo) {
            this.proxy = proxyInfo;
            return this.getThis();
        }

        public B allowEmptyOrNullUsernames() {
            this.allowEmptyOrNullUsername = true;
            return this.getThis();
        }

        public B performSaslAnonymousAuthentication() {
            if (!SASLAuthentication.isSaslMechanismRegistered("ANONYMOUS")) {
                throw new IllegalArgumentException("SASL ANONYMOUS is not registered");
            }
            this.throwIfEnabledSaslMechanismsSet();
            this.allowEmptyOrNullUsernames();
            this.addEnabledSaslMechanism("ANONYMOUS");
            this.saslMechanismsSealed = true;
            return this.getThis();
        }

        public B performSaslExternalAuthentication(SSLContext sslContext) {
            if (!SASLAuthentication.isSaslMechanismRegistered("EXTERNAL")) {
                throw new IllegalArgumentException("SASL EXTERNAL is not registered");
            }
            this.setCustomSSLContext(sslContext);
            this.throwIfEnabledSaslMechanismsSet();
            this.allowEmptyOrNullUsernames();
            this.setSecurityMode(SecurityMode.required);
            this.addEnabledSaslMechanism("EXTERNAL");
            this.saslMechanismsSealed = true;
            return this.getThis();
        }

        private void throwIfEnabledSaslMechanismsSet() {
            if (this.enabledSaslMechanisms != null) {
                throw new IllegalStateException("Enabled SASL mechanisms found");
            }
        }

        public B addEnabledSaslMechanism(String saslMechanism) {
            return this.addEnabledSaslMechanism(Arrays.asList(StringUtils.requireNotNullOrEmpty(saslMechanism, "saslMechanism must not be null or empty")));
        }

        public B addEnabledSaslMechanism(Collection<String> saslMechanisms) {
            if (this.saslMechanismsSealed) {
                throw new IllegalStateException("The enabled SASL mechanisms are sealed, you can not add new ones");
            }
            CollectionUtil.requireNotEmpty(saslMechanisms, "saslMechanisms");
            Set<String> blacklistedMechanisms = SASLAuthentication.getBlacklistedSASLMechanisms();
            for (String mechanism : saslMechanisms) {
                if (!SASLAuthentication.isSaslMechanismRegistered(mechanism)) {
                    throw new IllegalArgumentException("SASL " + mechanism + " is not avaiable. Consider registering it with Smack");
                }
                if (!blacklistedMechanisms.contains(mechanism)) continue;
                throw new IllegalArgumentException("SALS " + mechanism + " is blacklisted.");
            }
            if (this.enabledSaslMechanisms == null) {
                this.enabledSaslMechanisms = new HashSet<String>(saslMechanisms.size());
            }
            this.enabledSaslMechanisms.addAll(saslMechanisms);
            return this.getThis();
        }

        public B setAuthzid(EntityBareJid authzid) {
            this.authzid = authzid;
            return this.getThis();
        }

        public abstract C build();

        protected abstract B getThis();
    }

    public static enum SecurityMode {
        required,
        ifpossible,
        disabled;

    }
}

