/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.TopLevelStreamElement;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.packet.id.StanzaIdUtil;
import org.jivesoftware.smack.util.MultiMap;
import org.jivesoftware.smack.util.PacketUtil;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.stringprep.XmppStringprepException;
import org.jxmpp.util.XmppStringUtils;

public abstract class Stanza
implements TopLevelStreamElement {
    public static final String TEXT = "text";
    public static final String ITEM = "item";
    protected static final String DEFAULT_LANGUAGE = Locale.getDefault().getLanguage().toLowerCase(Locale.US);
    private final MultiMap<String, ExtensionElement> packetExtensions = new MultiMap();
    private String id = null;
    private Jid to;
    private Jid from;
    private XMPPError error = null;
    protected String language;

    protected Stanza() {
        this(StanzaIdUtil.newStanzaId());
    }

    protected Stanza(String stanzaId) {
        this.setStanzaId(stanzaId);
    }

    protected Stanza(Stanza p) {
        this.id = p.getStanzaId();
        this.to = p.getTo();
        this.from = p.getFrom();
        this.error = p.error;
        for (ExtensionElement pe : p.getExtensions()) {
            this.addExtension(pe);
        }
    }

    public String getStanzaId() {
        return this.id;
    }

    @Deprecated
    public String getPacketID() {
        return this.getStanzaId();
    }

    public void setStanzaId(String id) {
        if (id != null) {
            StringUtils.requireNotNullOrEmpty(id, "id must either be null or not the empty String");
        }
        this.id = id;
    }

    @Deprecated
    public void setPacketID(String packetID) {
        this.setStanzaId(packetID);
    }

    public boolean hasStanzaIdSet() {
        return this.id != null;
    }

    public Jid getTo() {
        return this.to;
    }

    @Deprecated
    public void setTo(String to) {
        Jid jid;
        try {
            jid = JidCreate.from((String)to);
        }
        catch (XmppStringprepException e) {
            throw new IllegalArgumentException(e);
        }
        this.setTo(jid);
    }

    public void setTo(Jid to) {
        this.to = to;
    }

    public Jid getFrom() {
        return this.from;
    }

    @Deprecated
    public void setFrom(String from) {
        Jid jid;
        try {
            jid = JidCreate.from((String)from);
        }
        catch (XmppStringprepException e) {
            throw new IllegalArgumentException(e);
        }
        this.setFrom(jid);
    }

    public void setFrom(Jid from) {
        this.from = from;
    }

    public XMPPError getError() {
        return this.error;
    }

    public void setError(XMPPError error) {
        this.error = error;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ExtensionElement> getExtensions() {
        MultiMap<String, ExtensionElement> multiMap = this.packetExtensions;
        synchronized (multiMap) {
            return this.packetExtensions.values();
        }
    }

    public Set<ExtensionElement> getExtensions(String elementName, String namespace) {
        StringUtils.requireNotNullOrEmpty(elementName, "elementName must not be null or empty");
        StringUtils.requireNotNullOrEmpty(namespace, "namespace must not be null or empty");
        String key = XmppStringUtils.generateKey((String)elementName, (String)namespace);
        return this.packetExtensions.getAll(key);
    }

    public ExtensionElement getExtension(String namespace) {
        return PacketUtil.extensionElementFrom(this.getExtensions(), null, namespace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <PE extends ExtensionElement> PE getExtension(String elementName, String namespace) {
        ExtensionElement packetExtension;
        if (namespace == null) {
            return null;
        }
        String key = XmppStringUtils.generateKey((String)elementName, (String)namespace);
        MultiMap<String, ExtensionElement> multiMap = this.packetExtensions;
        synchronized (multiMap) {
            packetExtension = this.packetExtensions.getFirst(key);
        }
        if (packetExtension == null) {
            return null;
        }
        return (PE)packetExtension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExtension(ExtensionElement extension) {
        if (extension == null) {
            return;
        }
        String key = XmppStringUtils.generateKey((String)extension.getElementName(), (String)extension.getNamespace());
        MultiMap<String, ExtensionElement> multiMap = this.packetExtensions;
        synchronized (multiMap) {
            this.packetExtensions.put(key, extension);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExtensionElement overrideExtension(ExtensionElement extension) {
        if (extension == null) {
            return null;
        }
        MultiMap<String, ExtensionElement> multiMap = this.packetExtensions;
        synchronized (multiMap) {
            ExtensionElement removedExtension = this.removeExtension(extension);
            this.addExtension(extension);
            return removedExtension;
        }
    }

    public void addExtensions(Collection<ExtensionElement> extensions) {
        if (extensions == null) {
            return;
        }
        for (ExtensionElement packetExtension : extensions) {
            this.addExtension(packetExtension);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasExtension(String elementName, String namespace) {
        if (elementName == null) {
            return this.hasExtension(namespace);
        }
        String key = XmppStringUtils.generateKey((String)elementName, (String)namespace);
        MultiMap<String, ExtensionElement> multiMap = this.packetExtensions;
        synchronized (multiMap) {
            return this.packetExtensions.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasExtension(String namespace) {
        MultiMap<String, ExtensionElement> multiMap = this.packetExtensions;
        synchronized (multiMap) {
            for (ExtensionElement packetExtension : this.packetExtensions.values()) {
                if (!packetExtension.getNamespace().equals(namespace)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExtensionElement removeExtension(String elementName, String namespace) {
        String key = XmppStringUtils.generateKey((String)elementName, (String)namespace);
        MultiMap<String, ExtensionElement> multiMap = this.packetExtensions;
        synchronized (multiMap) {
            return this.packetExtensions.remove(key);
        }
    }

    public ExtensionElement removeExtension(ExtensionElement extension) {
        return this.removeExtension(extension.getElementName(), extension.getNamespace());
    }

    public String toString() {
        return this.toXML().toString();
    }

    protected final XmlStringBuilder getExtensionsXML() {
        XmlStringBuilder xml = new XmlStringBuilder();
        for (ExtensionElement extension : this.getExtensions()) {
            xml.append(extension.toXML());
        }
        return xml;
    }

    public static String getDefaultLanguage() {
        return DEFAULT_LANGUAGE;
    }

    protected void addCommonAttributes(XmlStringBuilder xml) {
        xml.optAttribute("to", (CharSequence)this.getTo());
        xml.optAttribute("from", (CharSequence)this.getFrom());
        xml.optAttribute("id", this.getStanzaId());
        xml.xmllangAttribute(this.getLanguage());
    }

    protected void appendErrorIfExists(XmlStringBuilder xml) {
        XMPPError error = this.getError();
        if (error != null) {
            xml.append(error.toXML());
        }
    }
}

