/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Random;
import org.jivesoftware.smack.util.SHA1;

public class StringUtils {
    public static final String MD5 = "MD5";
    public static final String SHA1 = "SHA-1";
    public static final String UTF8 = "UTF-8";
    public static final String USASCII = "US-ASCII";
    public static final String QUOTE_ENCODE = "&quot;";
    public static final String APOS_ENCODE = "&apos;";
    public static final String AMP_ENCODE = "&amp;";
    public static final String LT_ENCODE = "&lt;";
    public static final String GT_ENCODE = "&gt;";
    public static final char[] HEX_CHARS = "0123456789abcdef".toCharArray();
    private static Random randGen = new Random();
    private static char[] numbersAndLetters = "0123456789abcdefghijklmnopqrstuvwxyz0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();

    public static CharSequence escapeForXML(CharSequence input) {
        if (input == null) {
            return null;
        }
        int len = input.length();
        StringBuilder out = new StringBuilder((int)((double)len * 1.3));
        int last = 0;
        int i = 0;
        while (i < len) {
            String toAppend = null;
            char ch = input.charAt(i);
            switch (ch) {
                case '<': {
                    toAppend = LT_ENCODE;
                    break;
                }
                case '>': {
                    toAppend = GT_ENCODE;
                    break;
                }
                case '&': {
                    toAppend = AMP_ENCODE;
                    break;
                }
                case '\"': {
                    toAppend = QUOTE_ENCODE;
                    break;
                }
                case '\'': {
                    toAppend = APOS_ENCODE;
                    break;
                }
            }
            if (toAppend != null) {
                if (i > last) {
                    out.append(input, last, i);
                }
                out.append((CharSequence)toAppend);
                last = ++i;
                continue;
            }
            ++i;
        }
        if (last == 0) {
            return input;
        }
        if (i > last) {
            out.append(input, last, i);
        }
        return out;
    }

    @Deprecated
    public static synchronized String hash(String data) {
        return org.jivesoftware.smack.util.SHA1.hex(data);
    }

    public static String encodeHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_CHARS[v >>> 4];
            hexChars[j * 2 + 1] = HEX_CHARS[v & 0xF];
        }
        return new String(hexChars);
    }

    public static byte[] toBytes(String string) {
        try {
            return string.getBytes(UTF8);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("UTF-8 encoding not supported by platform", e);
        }
    }

    public static String randomString(int length) {
        if (length < 1) {
            return null;
        }
        char[] randBuffer = new char[length];
        for (int i = 0; i < randBuffer.length; ++i) {
            randBuffer[i] = numbersAndLetters[randGen.nextInt(numbersAndLetters.length)];
        }
        return new String(randBuffer);
    }

    public static boolean isNotEmpty(CharSequence cs) {
        return !StringUtils.isNullOrEmpty(cs);
    }

    public static boolean isNullOrEmpty(CharSequence cs) {
        return cs == null || StringUtils.isEmpty(cs);
    }

    public static boolean isEmpty(CharSequence cs) {
        return cs.length() == 0;
    }

    public static String collectionToString(Collection<? extends Object> collection) {
        return StringUtils.toStringBuilder(collection, " ").toString();
    }

    public static StringBuilder toStringBuilder(Collection<? extends Object> collection, String delimiter) {
        StringBuilder sb = new StringBuilder(collection.size() * 20);
        Iterator<? extends Object> it = collection.iterator();
        while (it.hasNext()) {
            Object cs = it.next();
            sb.append(cs);
            if (!it.hasNext()) continue;
            sb.append(delimiter);
        }
        return sb;
    }

    public static String returnIfNotEmptyTrimmed(String string) {
        if (string == null) {
            return null;
        }
        String trimmedString = string.trim();
        if (trimmedString.length() > 0) {
            return trimmedString;
        }
        return null;
    }

    public static boolean nullSafeCharSequenceEquals(CharSequence csOne, CharSequence csTwo) {
        return StringUtils.nullSafeCharSequenceComperator(csOne, csTwo) == 0;
    }

    public static int nullSafeCharSequenceComperator(CharSequence csOne, CharSequence csTwo) {
        if (csOne == null ^ csTwo == null) {
            return csOne == null ? -1 : 1;
        }
        if (csOne == null && csTwo == null) {
            return 0;
        }
        return csOne.toString().compareTo(csTwo.toString());
    }

    public static <CS extends CharSequence> CS requireNotNullOrEmpty(CS cs, String message) {
        if (StringUtils.isNullOrEmpty(cs)) {
            throw new IllegalArgumentException(message);
        }
        return cs;
    }

    public static String maybeToString(CharSequence cs) {
        if (cs == null) {
            return null;
        }
        return cs.toString();
    }
}

