/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.filter;

import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.packet.Stanza;
import org.jxmpp.jid.Jid;

public class FromMatchesFilter
implements StanzaFilter {
    private final Jid address;
    private final boolean ignoreResourcepart;

    public FromMatchesFilter(Jid address, boolean ignoreResourcepart) {
        this.address = address != null && ignoreResourcepart ? address.asBareJid() : address;
        this.ignoreResourcepart = ignoreResourcepart;
    }

    public static FromMatchesFilter create(Jid address) {
        return new FromMatchesFilter(address, address.hasNoResource());
    }

    public static FromMatchesFilter createBare(Jid address) {
        address = address == null ? null : address;
        return new FromMatchesFilter(address, true);
    }

    public static FromMatchesFilter createFull(Jid address) {
        return new FromMatchesFilter(address, false);
    }

    @Override
    public boolean accept(Stanza packet) {
        Jid from = packet.getFrom();
        if (from == null) {
            return this.address == null;
        }
        if (this.ignoreResourcepart) {
            from = from.asBareJid();
        }
        return from.equals((CharSequence)this.address);
    }

    public String toString() {
        String matchMode = this.ignoreResourcepart ? "ignoreResourcepart" : "full";
        return this.getClass().getSimpleName() + " (" + matchMode + "): " + this.address;
    }
}

