/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.parsing;

import java.io.IOException;
import java.util.LinkedHashMap;
import org.jivesoftware.smack.packet.StandardExtensionElement;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smack.util.StringUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class StandardExtensionElementProvider
extends ExtensionElementProvider<StandardExtensionElement> {
    public static StandardExtensionElementProvider INSTANCE = new StandardExtensionElementProvider();

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public StandardExtensionElement parse(XmlPullParser parser, int initialDepth) throws XmlPullParserException, IOException {
        int i;
        String name = parser.getName();
        String namespace = parser.getNamespace();
        StandardExtensionElement.Builder builder = StandardExtensionElement.builder(name, namespace);
        int namespaceCount = parser.getNamespaceCount(initialDepth);
        int attributeCount = parser.getAttributeCount();
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>(namespaceCount + attributeCount);
        for (i = 0; i < namespaceCount; ++i) {
            String nsprefix = parser.getNamespacePrefix(i);
            if (nsprefix == null) continue;
            assert (StringUtils.isNotEmpty(nsprefix));
            String nsuri = parser.getNamespaceUri(i);
            attributes.put("xmlns:" + nsprefix, nsuri);
        }
        for (i = 0; i < attributeCount; ++i) {
            String attributePrefix = parser.getAttributePrefix(i);
            String attributeName = parser.getAttributeName(i);
            String attributeValue = parser.getAttributeValue(i);
            String attributeKey = StringUtils.isNullOrEmpty(attributePrefix) ? attributeName : attributePrefix + ':' + attributeName;
            attributes.put(attributeKey, attributeValue);
        }
        builder.addAttributes(attributes);
        block7: while (true) {
            int event = parser.next();
            switch (event) {
                case 2: {
                    builder.addElement(this.parse(parser, parser.getDepth()));
                    break;
                }
                case 4: {
                    builder.setText(parser.getText());
                    break;
                }
                case 3: {
                    if (initialDepth == parser.getDepth()) break block7;
                }
            }
        }
        ParserUtils.assertAtEndTag(parser);
        return builder.build();
    }
}

