/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util.dns;

import java.net.InetAddress;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jivesoftware.smack.util.Objects;

public class HostAddress {
    private final String fqdn;
    private final int port;
    private final Map<InetAddress, Exception> exceptions = new LinkedHashMap<InetAddress, Exception>();

    public HostAddress(String fqdn) {
        this(fqdn, 5222);
    }

    public HostAddress(String fqdn, int port) {
        Objects.requireNonNull(fqdn, "FQDN is null");
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("Port must be a 16-bit unsiged integer (i.e. between 0-65535. Port was: " + port);
        }
        this.fqdn = fqdn.charAt(fqdn.length() - 1) == '.' ? fqdn.substring(0, fqdn.length() - 1) : fqdn;
        this.port = port;
    }

    public String getFQDN() {
        return this.fqdn;
    }

    public int getPort() {
        return this.port;
    }

    public void setException(Exception exception) {
        this.setException(null, exception);
    }

    public void setException(InetAddress inetAddress, Exception exception) {
        Exception old = this.exceptions.put(inetAddress, exception);
        assert (old == null);
    }

    public Map<InetAddress, Exception> getExceptions() {
        return Collections.unmodifiableMap(this.exceptions);
    }

    public String toString() {
        return this.fqdn + ":" + this.port;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HostAddress)) {
            return false;
        }
        HostAddress address = (HostAddress)o;
        if (!this.fqdn.equals(address.fqdn)) {
            return false;
        }
        return this.port == address.port;
    }

    public int hashCode() {
        int result = 1;
        result = 37 * result + this.fqdn.hashCode();
        return result * 37 + this.port;
    }

    public String getErrorMessage() {
        if (this.exceptions.isEmpty()) {
            return "No error logged";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('\'').append(this.toString()).append("' failed because: ");
        Iterator<Map.Entry<InetAddress, Exception>> iterator = this.exceptions.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<InetAddress, Exception> entry = iterator.next();
            InetAddress inetAddress = entry.getKey();
            if (inetAddress != null) {
                sb.append(entry.getKey()).append(" exception: ");
            }
            sb.append(entry.getValue());
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }
}

