/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.packet.Stanza;

public class PacketCollector {
    private final StanzaFilter packetFilter;
    private final ArrayBlockingQueue<Stanza> resultQueue;
    private final PacketCollector collectorToReset;
    private final XMPPConnection connection;
    private boolean cancelled = false;
    private volatile long waitStart;

    protected PacketCollector(XMPPConnection connection, Configuration configuration) {
        this.connection = connection;
        this.packetFilter = configuration.packetFilter;
        this.resultQueue = new ArrayBlockingQueue(configuration.size);
        this.collectorToReset = configuration.collectorToReset;
    }

    public void cancel() {
        if (!this.cancelled) {
            this.cancelled = true;
            this.connection.removePacketCollector(this);
        }
    }

    @Deprecated
    public StanzaFilter getPacketFilter() {
        return this.getStanzaFilter();
    }

    public StanzaFilter getStanzaFilter() {
        return this.packetFilter;
    }

    public <P extends Stanza> P pollResult() {
        return (P)this.resultQueue.poll();
    }

    public <P extends Stanza> P pollResultOrThrow() throws XMPPException.XMPPErrorException {
        P result = this.pollResult();
        if (result != null) {
            XMPPException.XMPPErrorException.ifHasErrorThenThrow(result);
        }
        return result;
    }

    public <P extends Stanza> P nextResultBlockForever() throws InterruptedException {
        this.throwIfCancelled();
        Stanza res = null;
        while (res == null) {
            res = this.resultQueue.take();
        }
        return (P)res;
    }

    public <P extends Stanza> P nextResult() throws InterruptedException {
        return this.nextResult(this.connection.getPacketReplyTimeout());
    }

    public <P extends Stanza> P nextResult(long timeout) throws InterruptedException {
        this.throwIfCancelled();
        Stanza res = null;
        long remainingWait = timeout;
        this.waitStart = System.currentTimeMillis();
        do {
            if ((res = this.resultQueue.poll(remainingWait, TimeUnit.MILLISECONDS)) == null) continue;
            return (P)res;
        } while ((remainingWait = timeout - (System.currentTimeMillis() - this.waitStart)) > 0L);
        return null;
    }

    public <P extends Stanza> P nextResultOrThrow() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, InterruptedException, SmackException.NotConnectedException {
        return this.nextResultOrThrow(this.connection.getPacketReplyTimeout());
    }

    public <P extends Stanza> P nextResultOrThrow(long timeout) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, InterruptedException, SmackException.NotConnectedException {
        P result = this.nextResult(timeout);
        this.cancel();
        if (result == null) {
            if (!this.connection.isConnected()) {
                throw new SmackException.NotConnectedException(this.connection, this.packetFilter);
            }
            throw SmackException.NoResponseException.newWith(this.connection, this);
        }
        XMPPException.XMPPErrorException.ifHasErrorThenThrow(result);
        return result;
    }

    public int getCollectedCount() {
        return this.resultQueue.size();
    }

    protected void processPacket(Stanza packet) {
        if (this.packetFilter == null || this.packetFilter.accept(packet)) {
            while (!this.resultQueue.offer(packet)) {
                this.resultQueue.poll();
            }
            if (this.collectorToReset != null) {
                this.collectorToReset.waitStart = System.currentTimeMillis();
            }
        }
    }

    private final void throwIfCancelled() {
        if (this.cancelled) {
            throw new IllegalStateException("Packet collector already cancelled");
        }
    }

    public static Configuration newConfiguration() {
        return new Configuration();
    }

    public static final class Configuration {
        private StanzaFilter packetFilter;
        private int size = SmackConfiguration.getPacketCollectorSize();
        private PacketCollector collectorToReset;

        private Configuration() {
        }

        @Deprecated
        public Configuration setPacketFilter(StanzaFilter packetFilter) {
            return this.setStanzaFilter(packetFilter);
        }

        public Configuration setStanzaFilter(StanzaFilter stanzaFilter) {
            this.packetFilter = stanzaFilter;
            return this;
        }

        public Configuration setSize(int size) {
            this.size = size;
            return this;
        }

        public Configuration setCollectorToReset(PacketCollector collector) {
            this.collectorToReset = collector;
            return this;
        }
    }
}

