/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StreamError;
import org.jivesoftware.smack.packet.XMPPError;

public abstract class XMPPException
extends Exception {
    private static final long serialVersionUID = 6881651633890968625L;

    protected XMPPException() {
    }

    protected XMPPException(String message) {
        super(message);
    }

    protected XMPPException(String message, Throwable wrappedThrowable) {
        super(message, wrappedThrowable);
    }

    public static class StreamErrorException
    extends XMPPException {
        private static final long serialVersionUID = 3400556867134848886L;
        private final StreamError streamError;

        public StreamErrorException(StreamError streamError) {
            super(streamError.getCondition().toString() + " You can read more about the meaning of this stream error at http://xmpp.org/rfcs/rfc6120.html#streams-error-conditions\n" + streamError.toString());
            this.streamError = streamError;
        }

        public StreamError getStreamError() {
            return this.streamError;
        }
    }

    public static class XMPPErrorException
    extends XMPPException {
        private static final long serialVersionUID = 212790389529249604L;
        private final XMPPError error;

        public XMPPErrorException(XMPPError.Builder xmppErrorBuilder) {
            this(xmppErrorBuilder.build());
        }

        public XMPPErrorException(XMPPError error) {
            this.error = error;
        }

        @Deprecated
        public XMPPErrorException(String message, XMPPError error, Throwable wrappedThrowable) {
            super(message, wrappedThrowable);
            this.error = error;
        }

        @Deprecated
        public XMPPErrorException(String message, XMPPError error) {
            super(message);
            this.error = error;
        }

        public XMPPError getXMPPError() {
            return this.error;
        }

        @Override
        public String getMessage() {
            String superMessage = super.getMessage();
            if (superMessage != null) {
                return superMessage;
            }
            return this.error.toString();
        }

        public static void ifHasErrorThenThrow(Stanza packet) throws XMPPErrorException {
            XMPPError xmppError = packet.getError();
            if (xmppError != null) {
                throw new XMPPErrorException(xmppError);
            }
        }
    }
}

