/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.sasl;

import javax.security.auth.callback.CallbackHandler;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.sasl.packet.SaslStreamElements;
import org.jivesoftware.smack.util.StringTransformer;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.stringencoder.Base64;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.EntityBareJid;

public abstract class SASLMechanism
implements Comparable<SASLMechanism> {
    public static final String CRAMMD5 = "CRAM-MD5";
    public static final String DIGESTMD5 = "DIGEST-MD5";
    public static final String EXTERNAL = "EXTERNAL";
    public static final String GSSAPI = "GSSAPI";
    public static final String PLAIN = "PLAIN";
    private static StringTransformer saslPrepTransformer;
    protected XMPPConnection connection;
    protected String authenticationId;
    protected EntityBareJid authorizationId;
    protected DomainBareJid serviceName;
    protected String password;
    protected String host;

    public static void setSaslPrepTransformer(StringTransformer stringTransformer) {
        saslPrepTransformer = stringTransformer;
    }

    public final void authenticate(String username, String host, DomainBareJid serviceName, String password, EntityBareJid authzid) throws SmackException, SmackException.NotConnectedException, InterruptedException {
        this.authenticationId = username;
        this.host = host;
        this.serviceName = serviceName;
        this.password = password;
        this.authorizationId = authzid;
        assert (this.authorizationId == null || this.authzidSupported());
        this.authenticateInternal();
        this.authenticate();
    }

    protected void authenticateInternal() throws SmackException {
    }

    public void authenticate(String host, DomainBareJid serviceName, CallbackHandler cbh, EntityBareJid authzid) throws SmackException, SmackException.NotConnectedException, InterruptedException {
        this.host = host;
        this.serviceName = serviceName;
        this.authorizationId = authzid;
        assert (this.authorizationId == null || this.authzidSupported());
        this.authenticateInternal(cbh);
        this.authenticate();
    }

    protected abstract void authenticateInternal(CallbackHandler var1) throws SmackException;

    private final void authenticate() throws SmackException, SmackException.NotConnectedException, InterruptedException {
        byte[] authenticationBytes = this.getAuthenticationText();
        String authenticationText = authenticationBytes != null && authenticationBytes.length > 0 ? Base64.encodeToString(authenticationBytes) : "=";
        this.connection.sendNonza(new SaslStreamElements.AuthMechanism(this.getName(), authenticationText));
    }

    protected abstract byte[] getAuthenticationText() throws SmackException;

    public final void challengeReceived(String challengeString, boolean finalChallenge) throws SmackException, SmackException.NotConnectedException, InterruptedException {
        byte[] challenge = Base64.decode(challengeString);
        byte[] response = this.evaluateChallenge(challenge);
        if (finalChallenge) {
            return;
        }
        SaslStreamElements.Response responseStanza = response == null ? new SaslStreamElements.Response() : new SaslStreamElements.Response(Base64.encodeToString(response));
        this.connection.sendNonza(responseStanza);
    }

    protected byte[] evaluateChallenge(byte[] challenge) throws SmackException {
        return null;
    }

    @Override
    public final int compareTo(SASLMechanism other) {
        return this.getPriority() - other.getPriority();
    }

    public abstract String getName();

    public abstract int getPriority();

    public abstract void checkIfSuccessfulOrThrow() throws SmackException;

    public SASLMechanism instanceForAuthentication(XMPPConnection connection) {
        SASLMechanism saslMechansim = this.newInstance();
        saslMechansim.connection = connection;
        return saslMechansim;
    }

    public boolean authzidSupported() {
        return false;
    }

    protected abstract SASLMechanism newInstance();

    protected static byte[] toBytes(String string) {
        return StringUtils.toBytes(string);
    }

    protected static String saslPrep(String string) {
        StringTransformer stringTransformer = saslPrepTransformer;
        if (stringTransformer != null) {
            return stringTransformer.transform(string);
        }
        return string;
    }
}

