/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.LinkedList;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.util.dns.HostAddress;
import org.junit.Assert;
import org.junit.Test;

public class SmackExceptionTest {
    @Test
    public void testConnectionException() {
        LinkedList<HostAddress> failedAddresses = new LinkedList<HostAddress>();
        HostAddress hostAddress = new HostAddress("foo.bar.example", 1234);
        hostAddress.setException(new Exception("Failed for some reason"));
        failedAddresses.add(hostAddress);
        hostAddress = new HostAddress("barz.example", 5678);
        hostAddress.setException(new Exception("Failed for some other reason"));
        failedAddresses.add(hostAddress);
        SmackException.ConnectionException connectionException = SmackException.ConnectionException.from(failedAddresses);
        String message = connectionException.getMessage();
        Assert.assertEquals((Object)"The following addresses failed: 'foo.bar.example:1234' failed because: java.lang.Exception: Failed for some reason, 'barz.example:5678' failed because: java.lang.Exception: Failed for some other reason", (Object)message);
    }
}

