/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.sasl;

import java.util.HashMap;
import java.util.Map;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.sasl.AbstractSaslTest;
import org.jivesoftware.smack.sasl.SASLMechanism;
import org.jivesoftware.smack.util.StringUtils;
import org.junit.Assert;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.stringprep.XmppStringprepException;

public class DigestMd5SaslTest
extends AbstractSaslTest {
    protected static final String challenge = "realm=\"xmpp.org\",nonce=\"aTUr3GXqUtyy2B7HVDW6C+gQs+j+0EhWWjoBKkkg\",qop=\"auth\",charset=utf-8,algorithm=md5-sess";
    protected static final byte[] challengeBytes = StringUtils.toBytes((String)"realm=\"xmpp.org\",nonce=\"aTUr3GXqUtyy2B7HVDW6C+gQs+j+0EhWWjoBKkkg\",qop=\"auth\",charset=utf-8,algorithm=md5-sess");

    public DigestMd5SaslTest(SASLMechanism saslMechanism) {
        super(saslMechanism);
    }

    protected void runTest(boolean useAuthzid) throws SmackException.NotConnectedException, SmackException, InterruptedException, XmppStringprepException {
        EntityBareJid authzid = null;
        if (useAuthzid) {
            authzid = JidCreate.entityBareFrom((String)"shazbat@xmpp.org");
        }
        this.saslMechanism.authenticate("florian", "irrelevant", JidCreate.domainBareFrom((String)"xmpp.org"), "secret", authzid, null);
        byte[] response = this.saslMechanism.evaluateChallenge(challengeBytes);
        String responseString = new String(response);
        String[] responseParts = responseString.split(",");
        HashMap<String, String> responsePairs = new HashMap<String, String>();
        for (String part : responseParts) {
            String[] keyValue = part.split("=");
            Assert.assertTrue((keyValue.length == 2 ? 1 : 0) != 0);
            String key = keyValue[0];
            String value = keyValue[1].replace("\"", "");
            responsePairs.put(key, value);
        }
        if (useAuthzid) {
            DigestMd5SaslTest.assertMapValue("authzid", "shazbat@xmpp.org", responsePairs);
        } else assert (!responsePairs.containsKey("authzid"));
        DigestMd5SaslTest.assertMapValue("username", "florian", responsePairs);
        DigestMd5SaslTest.assertMapValue("realm", "xmpp.org", responsePairs);
        DigestMd5SaslTest.assertMapValue("digest-uri", "xmpp/xmpp.org", responsePairs);
        DigestMd5SaslTest.assertMapValue("qop", "auth", responsePairs);
    }

    private static void assertMapValue(String key, String value, Map<String, String> map) {
        Assert.assertEquals((Object)value, (Object)map.get(key));
    }
}

