/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.test.util;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.packet.Stanza;

public class WaitForPacketListener
implements StanzaListener {
    private CountDownLatch latch = new CountDownLatch(1);

    public void processStanza(Stanza packet) throws SmackException.NotConnectedException {
        this.reportInvoked();
    }

    protected void reportInvoked() {
        this.latch.countDown();
    }

    public void waitAndReset() {
        this.waitUntilInvocationOrTimeout();
        this.reset();
    }

    public void waitUntilInvocationOrTimeout() {
        try {
            boolean res = this.latch.await(300L, TimeUnit.SECONDS);
            if (!res) {
                throw new IllegalStateException("Latch timed out before it reached zero");
            }
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    public void reset() {
        this.latch = new CountDownLatch(1);
    }
}

