/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.proxy;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.jivesoftware.smack.proxy.ProxyException;
import org.jivesoftware.smack.proxy.ProxyInfo;
import org.jivesoftware.smack.proxy.ProxySocketConnection;

public class Socks4ProxySocketConnection
implements ProxySocketConnection {
    private final ProxyInfo proxy;

    Socks4ProxySocketConnection(ProxyInfo proxy) {
        this.proxy = proxy;
    }

    @Override
    public void connect(Socket socket, String host, int port, int timeout) throws IOException {
        InputStream in = null;
        OutputStream out = null;
        String proxy_host = this.proxy.getProxyAddress();
        int proxy_port = this.proxy.getProxyPort();
        String user = this.proxy.getProxyUsername();
        try {
            int i3;
            socket.connect(new InetSocketAddress(proxy_host, proxy_port), timeout);
            in = socket.getInputStream();
            out = socket.getOutputStream();
            socket.setTcpNoDelay(true);
            byte[] buf = new byte[1024];
            int index = 0;
            index = 0;
            buf[index++] = 4;
            buf[index++] = 1;
            buf[index++] = (byte)(port >>> 8);
            buf[index++] = (byte)(port & 0xFF);
            InetAddress inetAddress = InetAddress.getByName(proxy_host);
            byte[] byteAddress = inetAddress.getAddress();
            for (int i2 = 0; i2 < byteAddress.length; ++i2) {
                buf[index++] = byteAddress[i2];
            }
            if (user != null) {
                System.arraycopy(user.getBytes(), 0, buf, index, user.length());
                index += user.length();
            }
            buf[index++] = 0;
            out.write(buf, 0, index);
            int len = 6;
            for (int s = 0; s < len; s += i3) {
                i3 = in.read(buf, s, len - s);
                if (i3 > 0) continue;
                throw new ProxyException(ProxyInfo.ProxyType.SOCKS4, "stream is closed");
            }
            if (buf[0] != 0) {
                throw new ProxyException(ProxyInfo.ProxyType.SOCKS4, "server returns VN " + buf[0]);
            }
            if (buf[1] != 90) {
                try {
                    socket.close();
                }
                catch (Exception i3) {
                    // empty catch block
                }
                String message = "ProxySOCKS4: server returns CD " + buf[1];
                throw new ProxyException(ProxyInfo.ProxyType.SOCKS4, message);
            }
            byte[] temp = new byte[2];
            in.read(temp, 0, 2);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            try {
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new ProxyException(ProxyInfo.ProxyType.SOCKS4, e.toString());
        }
    }
}

