/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util.dns;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.util.dns.HostAddress;
import org.jivesoftware.smack.util.dns.SRVRecord;

public abstract class DNSResolver {
    private final boolean supportsDnssec;

    protected DNSResolver(boolean supportsDnssec) {
        this.supportsDnssec = supportsDnssec;
    }

    public final List<SRVRecord> lookupSRVRecords(String name, List<HostAddress> failedAddresses, ConnectionConfiguration.DnssecMode dnssecMode) {
        this.checkIfDnssecRequestedAndSupported(dnssecMode);
        return this.lookupSRVRecords0(name, failedAddresses, dnssecMode);
    }

    protected abstract List<SRVRecord> lookupSRVRecords0(String var1, List<HostAddress> var2, ConnectionConfiguration.DnssecMode var3);

    public final HostAddress lookupHostAddress(String name, int port, List<HostAddress> failedAddresses, ConnectionConfiguration.DnssecMode dnssecMode) {
        this.checkIfDnssecRequestedAndSupported(dnssecMode);
        List<InetAddress> inetAddresses = this.lookupHostAddress0(name, failedAddresses, dnssecMode);
        if (inetAddresses == null || inetAddresses.isEmpty()) {
            return null;
        }
        return new HostAddress(name, port, inetAddresses);
    }

    protected List<InetAddress> lookupHostAddress0(String name, List<HostAddress> failedAddresses, ConnectionConfiguration.DnssecMode dnssecMode) {
        InetAddress[] inetAddressArray;
        if (dnssecMode != ConnectionConfiguration.DnssecMode.disabled) {
            throw new UnsupportedOperationException("This resolver does not support DNSSEC");
        }
        try {
            inetAddressArray = InetAddress.getAllByName(name);
        }
        catch (UnknownHostException e) {
            failedAddresses.add(new HostAddress(name, e));
            return null;
        }
        return Arrays.asList(inetAddressArray);
    }

    private final void checkIfDnssecRequestedAndSupported(ConnectionConfiguration.DnssecMode dnssecMode) {
        if (dnssecMode != ConnectionConfiguration.DnssecMode.disabled && !this.supportsDnssec) {
            throw new UnsupportedOperationException("This resolver does not support DNSSEC");
        }
    }
}

