/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.util.dns.HostAddress;
import org.junit.Assert;
import org.junit.Test;

public class SmackExceptionTest {
    @Test
    public void testConnectionException() throws UnknownHostException {
        LinkedList<HostAddress> failedAddresses = new LinkedList<HostAddress>();
        String host = "foo.bar.example";
        InetAddress inetAddress = InetAddress.getByAddress(host, new byte[]{0, 0, 0, 0});
        List<InetAddress> inetAddresses = Collections.singletonList(inetAddress);
        HostAddress hostAddress = new HostAddress(host, 1234, inetAddresses);
        hostAddress.setException(new Exception("Failed for some reason"));
        failedAddresses.add(hostAddress);
        host = "barz.example";
        inetAddress = InetAddress.getByAddress(host, new byte[]{0, 0, 0, 0});
        inetAddresses = Collections.singletonList(inetAddress);
        hostAddress = new HostAddress(host, 5678, inetAddresses);
        hostAddress.setException(new Exception("Failed for some other reason"));
        failedAddresses.add(hostAddress);
        SmackException.ConnectionException connectionException = SmackException.ConnectionException.from(failedAddresses);
        String message = connectionException.getMessage();
        Assert.assertEquals((Object)"The following addresses failed: 'foo.bar.example:1234' failed because: java.lang.Exception: Failed for some reason, 'barz.example:5678' failed because: java.lang.Exception: Failed for some other reason", (Object)message);
    }
}

