/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NetworkUtil {
    private static final Logger LOGGER = Logger.getLogger(NetworkUtil.class.getName());

    public static ServerSocket getSocketOnLoopback() {
        InetAddress loopbackAddress = InetAddress.getLoopbackAddress();
        int portMin = 1024;
        int portMax = 65535;
        boolean backlog = true;
        ServerSocket serverSocket = null;
        for (int port = 1024; port <= 65535; ++port) {
            try {
                serverSocket = new ServerSocket(port, 1, loopbackAddress);
                break;
            }
            catch (BindException e) {
                LOGGER.log(Level.FINEST, "Could not bind port " + port + ", trying next", e);
                continue;
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        if (serverSocket == null) {
            throw new IllegalStateException();
        }
        return serverSocket;
    }
}

