/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.debugger;

import java.io.Reader;
import java.io.Writer;
import java.util.logging.Logger;
import org.jivesoftware.smack.AbstractConnectionListener;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.ReconnectionListener;
import org.jivesoftware.smack.ReconnectionManager;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.debugger.SmackDebugger;
import org.jivesoftware.smack.packet.TopLevelStreamElement;
import org.jivesoftware.smack.util.ObservableReader;
import org.jivesoftware.smack.util.ObservableWriter;
import org.jivesoftware.smack.util.ReaderListener;
import org.jivesoftware.smack.util.WriterListener;
import org.jxmpp.jid.EntityFullJid;

public abstract class AbstractDebugger
extends SmackDebugger {
    private static final Logger LOGGER = Logger.getLogger(AbstractDebugger.class.getName());
    public static boolean printInterpreted = false;
    private final ConnectionListener connListener;
    private final ReconnectionListener reconnectionListener;
    private final ReaderListener readerListener;
    private final WriterListener writerListener;
    private ObservableWriter writer;
    private ObservableReader reader;

    public AbstractDebugger(final XMPPConnection connection) {
        super(connection);
        this.reader = new ObservableReader(this.reader);
        this.readerListener = new ReaderListener(){

            @Override
            public void read(String str) {
                AbstractDebugger.this.log("RECV (" + connection.getConnectionCounter() + "): " + str);
            }
        };
        this.reader.addReaderListener(this.readerListener);
        this.writer = new ObservableWriter(this.writer);
        this.writerListener = new WriterListener(){

            @Override
            public void write(String str) {
                AbstractDebugger.this.log("SENT (" + connection.getConnectionCounter() + "): " + str);
            }
        };
        this.writer.addWriterListener(this.writerListener);
        this.connListener = new AbstractConnectionListener(){

            @Override
            public void connected(XMPPConnection connection2) {
                AbstractDebugger.this.log("XMPPConnection connected (" + connection2 + ")");
            }

            @Override
            public void authenticated(XMPPConnection connection2, boolean resumed) {
                String logString = "XMPPConnection authenticated (" + connection2 + ")";
                if (resumed) {
                    logString = logString + " and resumed";
                }
                AbstractDebugger.this.log(logString);
            }

            @Override
            public void connectionClosed() {
                AbstractDebugger.this.log("XMPPConnection closed (" + connection + ")");
            }

            @Override
            public void connectionClosedOnError(Exception e) {
                AbstractDebugger.this.log("XMPPConnection closed due to an exception (" + connection + ")", e);
            }
        };
        this.reconnectionListener = new ReconnectionListener(){

            @Override
            public void reconnectionFailed(Exception e) {
                AbstractDebugger.this.log("Reconnection failed due to an exception (" + connection + ")", e);
            }

            @Override
            public void reconnectingIn(int seconds) {
                AbstractDebugger.this.log("XMPPConnection (" + connection + ") will reconnect in " + seconds);
            }
        };
        if (connection instanceof AbstractXMPPConnection) {
            AbstractXMPPConnection abstractXmppConnection = (AbstractXMPPConnection)connection;
            ReconnectionManager.getInstanceFor(abstractXmppConnection).addReconnectionListener(this.reconnectionListener);
        } else {
            LOGGER.info("The connection instance " + connection + " is not an instance of AbstractXMPPConnection, thus we can not install the ReconnectionListener");
        }
    }

    protected abstract void log(String var1);

    protected abstract void log(String var1, Throwable var2);

    @Override
    public Reader newConnectionReader(Reader newReader) {
        this.reader.removeReaderListener(this.readerListener);
        ObservableReader debugReader = new ObservableReader(newReader);
        debugReader.addReaderListener(this.readerListener);
        this.reader = debugReader;
        return this.reader;
    }

    @Override
    public Writer newConnectionWriter(Writer newWriter) {
        this.writer.removeWriterListener(this.writerListener);
        ObservableWriter debugWriter = new ObservableWriter(newWriter);
        debugWriter.addWriterListener(this.writerListener);
        this.writer = debugWriter;
        return this.writer;
    }

    @Override
    public void userHasLogged(EntityFullJid user) {
        String localpart = user.getLocalpart().toString();
        boolean isAnonymous = "".equals(localpart);
        String title = "User logged (" + this.connection.getConnectionCounter() + "): " + (isAnonymous ? "" : localpart) + "@" + this.connection.getXMPPServiceDomain() + ":" + this.connection.getPort();
        title = title + "/" + user.getResourcepart();
        this.log(title);
        this.connection.addConnectionListener(this.connListener);
    }

    @Override
    public void onIncomingStreamElement(TopLevelStreamElement streamElement) {
        if (printInterpreted) {
            this.log("RCV PKT (" + this.connection.getConnectionCounter() + "): " + streamElement.toXML());
        }
    }

    @Override
    public void onOutgoingStreamElement(TopLevelStreamElement streamElement) {
    }
}

