/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import com.jamesmurty.utils.XMLBuilder;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.custommonkey.xmlunit.XMLAssert;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.sasl.SASLError;
import org.jivesoftware.smack.sasl.packet.SaslStreamElements;
import org.jivesoftware.smack.test.util.TestUtils;
import org.jivesoftware.smack.test.util.XmlUnitUtils;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.xml.sax.SAXException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class PacketParserUtilsTest {
    private static Properties outputProperties = new Properties();

    public PacketParserUtilsTest() {
        outputProperties.put("omit-xml-declaration", "yes");
    }

    @Test
    public void singleMessageBodyTest() throws Exception {
        String defaultLanguage = Stanza.getDefaultLanguage();
        String otherLanguage = PacketParserUtilsTest.determineNonDefaultLanguage();
        String control = XMLBuilder.create((String)"message").namespace("jabber:client").a("from", "romeo@montague.lit/orchard").a("to", "juliet@capulet.lit/balcony").a("id", "zid615d9").a("type", "chat").a("xml:lang", defaultLanguage).e("body").t(defaultLanguage).asString(outputProperties);
        Message message = PacketParserUtils.parseMessage((XmlPullParser)PacketParserUtils.getParserFor((String)control));
        Assert.assertEquals((Object)defaultLanguage, (Object)message.getBody());
        Assert.assertTrue((boolean)message.getBodyLanguages().isEmpty());
        Assert.assertEquals((Object)defaultLanguage, (Object)message.getBody(defaultLanguage));
        Assert.assertNull((Object)message.getBody(otherLanguage));
        XMLAssert.assertXMLEqual((String)control, (String)message.toXML(null).toString());
        control = XMLBuilder.create((String)"message").namespace("jabber:client").a("from", "romeo@montague.lit/orchard").a("to", "juliet@capulet.lit/balcony").a("id", "zid615d9").a("type", "chat").a("xml:lang", otherLanguage).e("body").t(otherLanguage).asString(outputProperties);
        message = PacketParserUtils.parseMessage((XmlPullParser)PacketParserUtils.getParserFor((String)control));
        Assert.assertEquals((Object)otherLanguage, (Object)message.getBody());
        Assert.assertTrue((boolean)message.getBodyLanguages().isEmpty());
        Assert.assertEquals((Object)otherLanguage, (Object)message.getBody(otherLanguage));
        Assert.assertNull((Object)message.getBody(defaultLanguage));
        XMLAssert.assertXMLEqual((String)control, (String)message.toXML(null).toString());
        control = XMLBuilder.create((String)"message").namespace("jabber:client").a("from", "romeo@montague.lit/orchard").a("to", "juliet@capulet.lit/balcony").a("id", "zid615d9").a("type", "chat").e("body").t(defaultLanguage).asString(outputProperties);
        message = PacketParserUtils.parseMessage((XmlPullParser)PacketParserUtils.getParserFor((String)control));
        Assert.assertEquals((Object)defaultLanguage, (Object)message.getBody());
        Assert.assertTrue((boolean)message.getBodyLanguages().isEmpty());
        Assert.assertEquals((Object)defaultLanguage, (Object)message.getBody(null));
        Assert.assertNull((Object)message.getBody(otherLanguage));
        XMLAssert.assertXMLEqual((String)control, (String)message.toXML(null).toString());
        control = XMLBuilder.create((String)"message").namespace("jabber:client").a("from", "romeo@montague.lit/orchard").a("to", "juliet@capulet.lit/balcony").a("id", "zid615d9").a("type", "chat").e("body").a("xml:lang", defaultLanguage).t(defaultLanguage).asString(outputProperties);
        message = PacketParserUtils.parseMessage((XmlPullParser)PacketParserUtils.getParserFor((String)control));
        Assert.assertNull((Object)message.getBody());
        Assert.assertFalse((boolean)message.getBodyLanguages().isEmpty());
        Assert.assertEquals((Object)defaultLanguage, (Object)message.getBody(defaultLanguage));
        Assert.assertNull((Object)message.getBody(otherLanguage));
        XMLAssert.assertXMLEqual((String)control, (String)message.toXML(null).toString());
        control = XMLBuilder.create((String)"message").namespace("jabber:client").a("from", "romeo@montague.lit/orchard").a("to", "juliet@capulet.lit/balcony").a("id", "zid615d9").a("type", "chat").e("body").a("xml:lang", otherLanguage).t(otherLanguage).asString(outputProperties);
        message = PacketParserUtils.parseMessage((XmlPullParser)PacketParserUtils.getParserFor((String)control));
        Assert.assertNull((Object)message.getBody());
        Assert.assertFalse((boolean)message.getBodyLanguages().isEmpty());
        Assert.assertTrue((boolean)message.getBodyLanguages().contains(otherLanguage));
        Assert.assertEquals((Object)otherLanguage, (Object)message.getBody(otherLanguage));
        Assert.assertNull((Object)message.getBody(defaultLanguage));
        XMLAssert.assertXMLEqual((String)control, (String)message.toXML(null).toString());
        control = XMLBuilder.create((String)"message").namespace("jabber:client").a("from", "romeo@montague.lit/orchard").a("to", "juliet@capulet.lit/balcony").a("id", "zid615d9").a("type", "chat").a("xml:lang", defaultLanguage).e("body").a("xml:lang", otherLanguage).t(otherLanguage).asString(outputProperties);
        message = PacketParserUtils.parseMessage((XmlPullParser)PacketParserUtils.getParserFor((String)control));
        Assert.assertNull((Object)message.getBody());
        Assert.assertFalse((boolean)message.getBodyLanguages().isEmpty());
        Assert.assertTrue((boolean)message.getBodyLanguages().contains(otherLanguage));
        Assert.assertEquals((Object)otherLanguage, (Object)message.getBody(otherLanguage));
        Assert.assertNull((Object)message.getBody(defaultLanguage));
        XMLAssert.assertXMLEqual((String)control, (String)message.toXML(null).toString());
        control = XMLBuilder.create((String)"message").namespace("jabber:client").a("from", "romeo@montague.lit/orchard").a("to", "juliet@capulet.lit/balcony").a("id", "zid615d9").a("type", "chat").a("xml:lang", otherLanguage).e("body").a("xml:lang", defaultLanguage).t(defaultLanguage).asString(outputProperties);
        message = PacketParserUtils.parseMessage((XmlPullParser)PacketParserUtils.getParserFor((String)control));
        Assert.assertNull((Object)message.getBody());
        Assert.assertFalse((boolean)message.getBodyLanguages().isEmpty());
        Assert.assertTrue((boolean)message.getBodyLanguages().contains(defaultLanguage));
        Assert.assertEquals((Object)defaultLanguage, (Object)message.getBody(defaultLanguage));
        Assert.assertNull((Object)message.getBody(otherLanguage));
        XMLAssert.assertXMLEqual((String)control, (String)message.toXML(null).toString());
    }

    @Test
    public void singleMessageSubjectTest() throws Exception {
        String defaultLanguage = Stanza.getDefaultLanguage();
        String otherLanguage = PacketParserUtilsTest.determineNonDefaultLanguage();
        String control = XMLBuilder.create((String)"message").a("from", "romeo@montague.lit/orchard").a("to", "juliet@capulet.lit/balcony").a("id", "zid615d9").a("type", "chat").a("xml:lang", defaultLanguage).e("subject").t(defaultLanguage).asString(outputProperties);
        Message message = PacketParserUtils.parseMessage((XmlPullParser)PacketParserUtils.getParserFor((String)control));
        Assert.assertEquals((Object)defaultLanguage, (Object)message.getSubject());
        Assert.assertTrue((boolean)message.getSubjectLanguages().isEmpty());
        Assert.assertEquals((Object)defaultLanguage, (Object)message.getSubject(defaultLanguage));
        Assert.assertNull((Object)message.getSubject(otherLanguage));
        XMLAssert.assertXMLEqual((String)control, (String)message.toXML("jabber:client").toString());
        control = XMLBuilder.create((String)"message").a("from", "romeo@montague.lit/orchard").a("to", "juliet@capulet.lit/balcony").a("id", "zid615d9").a("type", "chat").a("xml:lang", otherLanguage).e("subject").t(otherLanguage).asString(outputProperties);
        message = PacketParserUtils.parseMessage((XmlPullParser)PacketParserUtils.getParserFor((String)control));
        Assert.assertEquals((Object)otherLanguage, (Object)message.getSubject());
        Assert.assertTrue((boolean)message.getSubjectLanguages().isEmpty());
        Assert.assertEquals((Object)otherLanguage, (Object)message.getSubject(otherLanguage));
        Assert.assertNull((Object)message.getSubject(defaultLanguage));
        XMLAssert.assertXMLEqual((String)control, (String)message.toXML("jabber:client").toString());
        control = XMLBuilder.create((String)"message").a("from", "romeo@montague.lit/orchard").a("to", "juliet@capulet.lit/balcony").a("id", "zid615d9").a("type", "chat").e("subject").t(defaultLanguage).asString(outputProperties);
        message = PacketParserUtils.parseMessage((XmlPullParser)PacketParserUtils.getParserFor((String)control));
        Assert.assertEquals((Object)defaultLanguage, (Object)message.getSubject());
        Assert.assertTrue((boolean)message.getSubjectLanguages().isEmpty());
        Assert.assertEquals((Object)defaultLanguage, (Object)message.getSubject(null));
        Assert.assertNull((Object)message.getSubject(otherLanguage));
        XMLAssert.assertXMLEqual((String)control, (String)message.toXML("jabber:client").toString());
        control = XMLBuilder.create((String)"message").a("from", "romeo@montague.lit/orchard").a("to", "juliet@capulet.lit/balcony").a("id", "zid615d9").a("type", "chat").e("subject").a("xml:lang", defaultLanguage).t(defaultLanguage).asString(outputProperties);
        message = PacketParserUtils.parseMessage((XmlPullParser)PacketParserUtils.getParserFor((String)control));
        Assert.assertFalse((boolean)message.getSubjectLanguages().isEmpty());
        Assert.assertEquals((Object)defaultLanguage, (Object)message.getSubject(defaultLanguage));
        Assert.assertNull((Object)message.getSubject(otherLanguage));
        XMLAssert.assertXMLEqual((String)control, (String)message.toXML("jabber:client").toString());
        control = XMLBuilder.create((String)"message").a("from", "romeo@montague.lit/orchard").a("to", "juliet@capulet.lit/balcony").a("id", "zid615d9").a("type", "chat").e("subject").a("xml:lang", otherLanguage).t(otherLanguage).asString(outputProperties);
        message = PacketParserUtils.parseMessage((XmlPullParser)PacketParserUtils.getParserFor((String)control));
        Assert.assertNull((Object)message.getSubject());
        Assert.assertFalse((boolean)message.getSubjectLanguages().isEmpty());
        Assert.assertTrue((boolean)message.getSubjectLanguages().contains(otherLanguage));
        Assert.assertEquals((Object)otherLanguage, (Object)message.getSubject(otherLanguage));
        Assert.assertNull((Object)message.getSubject(defaultLanguage));
        XMLAssert.assertXMLEqual((String)control, (String)message.toXML("jabber:client").toString());
        control = XMLBuilder.create((String)"message").a("from", "romeo@montague.lit/orchard").a("to", "juliet@capulet.lit/balcony").a("id", "zid615d9").a("type", "chat").a("xml:lang", defaultLanguage).e("subject").a("xml:lang", otherLanguage).t(otherLanguage).asString(outputProperties);
        message = PacketParserUtils.parseMessage((XmlPullParser)PacketParserUtils.getParserFor((String)control));
        Assert.assertNull((Object)message.getSubject());
        Assert.assertFalse((boolean)message.getSubjectLanguages().isEmpty());
        Assert.assertTrue((boolean)message.getSubjectLanguages().contains(otherLanguage));
        Assert.assertEquals((Object)otherLanguage, (Object)message.getSubject(otherLanguage));
        Assert.assertNull((Object)message.getSubject(defaultLanguage));
        XMLAssert.assertXMLEqual((String)control, (String)message.toXML("jabber:client").toString());
        control = XMLBuilder.create((String)"message").a("from", "romeo@montague.lit/orchard").a("to", "juliet@capulet.lit/balcony").a("id", "zid615d9").a("type", "chat").a("xml:lang", otherLanguage).e("subject").a("xml:lang", defaultLanguage).t(defaultLanguage).asString(outputProperties);
        message = PacketParserUtils.parseMessage((XmlPullParser)PacketParserUtils.getParserFor((String)control));
        Assert.assertNull((Object)message.getSubject());
        Assert.assertFalse((boolean)message.getSubjectLanguages().isEmpty());
        Assert.assertTrue((boolean)message.getSubjectLanguages().contains(defaultLanguage));
        Assert.assertEquals((Object)defaultLanguage, (Object)message.getSubject(defaultLanguage));
        Assert.assertNull((Object)message.getSubject(otherLanguage));
        XMLAssert.assertXMLEqual((String)control, (String)message.toXML("jabber:client").toString());
    }

    @Test
    public void multipleMessageBodiesTest() throws Exception {
        String defaultLanguage = Stanza.getDefaultLanguage();
        String otherLanguage = PacketParserUtilsTest.determineNonDefaultLanguage();
        String control = XMLBuilder.create((String)"message").namespace("jabber:client").a("from", "romeo@montague.lit/orchard").a("to", "juliet@capulet.lit/balcony").a("id", "zid615d9").a("type", "chat").a("xml:lang", defaultLanguage).e("body").t(defaultLanguage).up().e("body").a("xml:lang", otherLanguage).t(otherLanguage).asString(outputProperties);
        Message message = PacketParserUtils.parseMessage((XmlPullParser)PacketParserUtils.getParserFor((String)control));
        Assert.assertEquals((Object)defaultLanguage, (Object)message.getBody());
        Assert.assertEquals((Object)otherLanguage, (Object)message.getBody(otherLanguage));
        Assert.assertEquals((long)2L, (long)message.getBodies().size());
        Assert.assertEquals((long)1L, (long)message.getBodyLanguages().size());
        Assert.assertTrue((boolean)message.getBodyLanguages().contains(otherLanguage));
        XMLAssert.assertXMLEqual((String)control, (String)message.toXML(null).toString());
        control = XMLBuilder.create((String)"message").namespace("jabber:client").a("from", "romeo@montague.lit/orchard").a("to", "juliet@capulet.lit/balcony").a("id", "zid615d9").a("type", "chat").a("xml:lang", otherLanguage).e("body").t(otherLanguage).up().e("body").a("xml:lang", defaultLanguage).t(defaultLanguage).asString(outputProperties);
        message = PacketParserUtils.parseMessage((XmlPullParser)PacketParserUtils.getParserFor((String)control));
        Assert.assertEquals((Object)otherLanguage, (Object)message.getBody());
        Assert.assertEquals((Object)defaultLanguage, (Object)message.getBody(defaultLanguage));
        Assert.assertEquals((long)2L, (long)message.getBodies().size());
        Assert.assertEquals((long)1L, (long)message.getBodyLanguages().size());
        Assert.assertTrue((boolean)message.getBodyLanguages().contains(defaultLanguage));
        XMLAssert.assertXMLEqual((String)control, (String)message.toXML(null).toString());
    }

    @Ignore
    @Test
    public void duplicateMessageBodiesTest() throws FactoryConfigurationError, XmlPullParserException, IOException, Exception {
        String defaultLanguage = Stanza.getDefaultLanguage();
        String control = XMLBuilder.create((String)"message").namespace("jabber:client").a("from", "romeo@montague.lit/orchard").a("to", "juliet@capulet.lit/balcony").a("id", "zid615d9").a("type", "chat").a("xml:lang", defaultLanguage).e("body").t(defaultLanguage).up().e("body").a("xml:lang", defaultLanguage).t(defaultLanguage + "2").asString(outputProperties);
        Message message = PacketParserUtils.parseMessage((XmlPullParser)PacketParserUtils.getParserFor((String)control));
        Assert.assertEquals((Object)defaultLanguage, (Object)message.getBody());
        Assert.assertEquals((Object)defaultLanguage, (Object)message.getBody(defaultLanguage));
        Assert.assertEquals((long)1L, (long)message.getBodies().size());
        Assert.assertEquals((long)0L, (long)message.getBodyLanguages().size());
        XMLAssert.assertXMLNotEqual((String)control, (String)message.toXML(null).toString());
    }

    @Ignore
    @Test
    public void duplicateMessageBodiesTest2() throws FactoryConfigurationError, XmlPullParserException, IOException, Exception {
        String defaultLanguage = Stanza.getDefaultLanguage();
        String otherLanguage = PacketParserUtilsTest.determineNonDefaultLanguage();
        String control = XMLBuilder.create((String)"message").namespace("jabber:client").a("xml:lang", defaultLanguage).a("from", "romeo@montague.lit/orchard").a("to", "juliet@capulet.lit/balcony").a("id", "zid615d9").a("type", "chat").e("body").t(defaultLanguage).up().e("body").t(otherLanguage).asString(outputProperties);
        PacketParserUtils.parseMessage((XmlPullParser)PacketParserUtils.getParserFor((String)control));
    }

    @Test
    public void messageNoLanguageFirstBodyNoLanguageSecondBodyOtherTest() throws FactoryConfigurationError, XmlPullParserException, IOException, Exception {
        String defaultLanguage = Stanza.getDefaultLanguage();
        String otherLanguage = PacketParserUtilsTest.determineNonDefaultLanguage();
        String control = XMLBuilder.create((String)"message").namespace("jabber:client").a("from", "romeo@montague.lit/orchard").a("to", "juliet@capulet.lit/balcony").a("id", "zid615d9").a("type", "chat").e("body").t(defaultLanguage).up().e("body").a("xml:lang", otherLanguage).t(otherLanguage).asString(outputProperties);
        Message message = PacketParserUtils.parseMessage((XmlPullParser)PacketParserUtils.getParserFor((String)control));
        Assert.assertEquals((Object)defaultLanguage, (Object)message.getBody());
        Assert.assertEquals((Object)defaultLanguage, (Object)message.getBody(null));
        Assert.assertEquals((Object)otherLanguage, (Object)message.getBody(otherLanguage));
        Assert.assertEquals((long)2L, (long)message.getBodies().size());
        Assert.assertEquals((long)1L, (long)message.getBodyLanguages().size());
        XMLAssert.assertXMLEqual((String)control, (String)message.toXML(null).toString());
    }

    @Test
    public void multipleMessageSubjectsTest() throws Exception {
        String defaultLanguage = Stanza.getDefaultLanguage();
        String otherLanguage = PacketParserUtilsTest.determineNonDefaultLanguage();
        String control = XMLBuilder.create((String)"message").a("from", "romeo@montague.lit/orchard").a("to", "juliet@capulet.lit/balcony").a("id", "zid615d9").a("type", "chat").a("xml:lang", defaultLanguage).e("subject").t(defaultLanguage).up().e("subject").a("xml:lang", otherLanguage).t(otherLanguage).asString(outputProperties);
        Message message = PacketParserUtils.parseMessage((XmlPullParser)PacketParserUtils.getParserFor((String)control));
        Assert.assertEquals((Object)defaultLanguage, (Object)message.getSubject());
        Assert.assertEquals((Object)otherLanguage, (Object)message.getSubject(otherLanguage));
        Assert.assertEquals((long)2L, (long)message.getSubjects().size());
        Assert.assertEquals((long)1L, (long)message.getSubjectLanguages().size());
        Assert.assertTrue((boolean)message.getSubjectLanguages().contains(otherLanguage));
        XMLAssert.assertXMLEqual((String)control, (String)message.toXML("jabber:client").toString());
        control = XMLBuilder.create((String)"message").a("from", "romeo@montague.lit/orchard").a("to", "juliet@capulet.lit/balcony").a("id", "zid615d9").a("type", "chat").a("xml:lang", defaultLanguage).e("subject").t(defaultLanguage).up().e("subject").a("xml:lang", defaultLanguage).t(defaultLanguage + "2").asString(outputProperties);
        message = PacketParserUtils.parseMessage((XmlPullParser)PacketParserUtils.getParserFor((String)control));
        Assert.assertEquals((Object)defaultLanguage, (Object)message.getSubject());
        Assert.assertEquals((Object)defaultLanguage, (Object)message.getSubject(defaultLanguage));
        Assert.assertEquals((long)1L, (long)message.getSubjects().size());
        Assert.assertEquals((long)0L, (long)message.getSubjectLanguages().size());
        XMLAssert.assertXMLNotEqual((String)control, (String)message.toXML("jabber:client").toString());
        control = XMLBuilder.create((String)"message").a("from", "romeo@montague.lit/orchard").a("to", "juliet@capulet.lit/balcony").a("id", "zid615d9").a("type", "chat").a("xml:lang", otherLanguage).e("subject").t(otherLanguage).up().e("subject").a("xml:lang", defaultLanguage).t(defaultLanguage).asString(outputProperties);
        message = PacketParserUtils.parseMessage((XmlPullParser)PacketParserUtils.getParserFor((String)control));
        Assert.assertEquals((Object)otherLanguage, (Object)message.getSubject());
        Assert.assertEquals((Object)defaultLanguage, (Object)message.getSubject(defaultLanguage));
        Assert.assertEquals((long)2L, (long)message.getSubjects().size());
        Assert.assertEquals((long)1L, (long)message.getSubjectLanguages().size());
        Assert.assertTrue((boolean)message.getSubjectLanguages().contains(defaultLanguage));
        XMLAssert.assertXMLEqual((String)control, (String)message.toXML("jabber:client").toString());
    }

    @Test(expected=XmlPullParserException.class)
    public void invalidMessageBodyContainingTagTest() throws Exception {
        String control = XMLBuilder.create((String)"message").namespace("jabber:client").a("from", "romeo@montague.lit/orchard").a("to", "juliet@capulet.lit/balcony").a("id", "zid615d9").a("type", "chat").a("xml:lang", "en").e("body").a("xmlns", "http://www.w3.org/1999/xhtml").e("span").a("style", "font-weight: bold;").t("Bad Message Body").asString(outputProperties);
        Message message = PacketParserUtils.parseMessage((XmlPullParser)TestUtils.getMessageParser(control));
        Assert.fail((String)("Should throw exception. Instead got message: " + message.toXML(null).toString()));
    }

    @Test
    public void invalidXMLInMessageBody() throws Exception {
        String validControl = XMLBuilder.create((String)"message").namespace("jabber:client").a("from", "romeo@montague.lit/orchard").a("to", "juliet@capulet.lit/balcony").a("id", "zid615d9").a("type", "chat").a("xml:lang", "en").e("body").t("Good Message Body").asString(outputProperties);
        String invalidControl = validControl.replace("Good Message Body", "Bad </span> Body");
        try {
            PacketParserUtils.parseMessage((XmlPullParser)PacketParserUtils.getParserFor((String)invalidControl));
            Assert.fail((String)"Exception should be thrown");
        }
        catch (XmlPullParserException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("end tag name </span>"));
        }
        invalidControl = validControl.replace("Good Message Body", "Bad </body> Body");
        try {
            PacketParserUtils.parseMessage((XmlPullParser)PacketParserUtils.getParserFor((String)invalidControl));
            Assert.fail((String)"Exception should be thrown");
        }
        catch (XmlPullParserException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("end tag name </body>"));
        }
        invalidControl = validControl.replace("Good Message Body", "Bad </message> Body");
        try {
            PacketParserUtils.parseMessage((XmlPullParser)PacketParserUtils.getParserFor((String)invalidControl));
            Assert.fail((String)"Exception should be thrown");
        }
        catch (XmlPullParserException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("end tag name </message>"));
        }
    }

    @Test
    public void multipleMessageBodiesParsingTest() throws Exception {
        String control = XMLBuilder.create((String)"message").namespace("jabber:client").a("from", "romeo@montague.lit/orchard").a("to", "juliet@capulet.lit/balcony").a("id", "zid615d9").a("type", "chat").a("xml:lang", "en").e("body").a("xml:lang", "en").t("This is a test of the emergency broadcast system, 1.").up().e("body").a("xml:lang", "ru").t("This is a test of the emergency broadcast system, 2.").up().e("body").a("xml:lang", "sp").t("This is a test of the emergency broadcast system, 3.").asString(outputProperties);
        Stanza message = PacketParserUtils.parseStanza((String)control);
        XmlUnitUtils.assertSimilar(control, message.toXML(null));
    }

    @Test
    public void validateSimplePresence() throws Exception {
        String stanza = "<presence from='juliet@example.com/balcony' to='romeo@example.net'/>";
        Presence presence = PacketParserUtils.parsePresence((XmlPullParser)PacketParserUtils.getParserFor((String)stanza));
        XMLAssert.assertXMLEqual((String)stanza, (String)presence.toXML("jabber:client").toString());
    }

    @Test
    public void validatePresenceProbe() throws Exception {
        String stanza = "<presence from='mercutio@example.com' id='xv291f38' to='juliet@example.com' type='unsubscribed'/>";
        Presence presence = PacketParserUtils.parsePresence((XmlPullParser)PacketParserUtils.getParserFor((String)stanza));
        XMLAssert.assertXMLEqual((String)stanza, (String)presence.toXML("jabber:client").toString());
        Assert.assertEquals((Object)Presence.Type.unsubscribed, (Object)presence.getType());
    }

    @Test
    public void validatePresenceOptionalElements() throws Exception {
        String stanza = "<presence xml:lang='en' type='unsubscribed'><show>dnd</show><status>Wooing Juliet</status><priority>1</priority></presence>";
        Presence presence = PacketParserUtils.parsePresence((XmlPullParser)PacketParserUtils.getParserFor((String)stanza));
        XMLAssert.assertXMLEqual((String)stanza, (String)presence.toXML("jabber:client").toString());
        Assert.assertEquals((Object)Presence.Type.unsubscribed, (Object)presence.getType());
        Assert.assertEquals((Object)"dnd", (Object)presence.getMode().name());
        Assert.assertEquals((Object)"en", (Object)presence.getLanguage());
        Assert.assertEquals((Object)"Wooing Juliet", (Object)presence.getStatus());
        Assert.assertEquals((long)1L, (long)presence.getPriority());
    }

    @Test
    public void parseContentDepthTest() throws Exception {
        String stanza = "<iq type='result' to='foo@bar.com' from='baz.com' id='42'/>";
        XmlPullParser parser = TestUtils.getParser("<iq type='result' to='foo@bar.com' from='baz.com' id='42'/>", "iq");
        CharSequence content = PacketParserUtils.parseContent((XmlPullParser)parser);
        Assert.assertEquals((Object)"", (Object)content);
    }

    @Test
    public void parseElementMultipleNamespace() throws ParserConfigurationException, FactoryConfigurationError, XmlPullParserException, IOException, TransformerException, SAXException {
        String stanza = XMLBuilder.create((String)"outer", (String)"outerNamespace").a("outerAttribute", "outerValue").element("inner", "innerNamespace").a("innerAttribute", "innerValue").element("innermost").t("some text").asString();
        XmlPullParser parser = TestUtils.getParser(stanza, "outer");
        CharSequence result = PacketParserUtils.parseElement((XmlPullParser)parser, (boolean)true);
        XMLAssert.assertXMLEqual((String)stanza, (String)result.toString());
    }

    @Test
    public void parseSASLFailureSimple() throws FactoryConfigurationError, SAXException, IOException, TransformerException, ParserConfigurationException, XmlPullParserException {
        String saslFailureString = XMLBuilder.create((String)"failure", (String)"urn:ietf:params:xml:ns:xmpp-sasl").e(SASLError.account_disabled.toString()).asString();
        XmlPullParser parser = TestUtils.getParser(saslFailureString, "failure");
        SaslStreamElements.SASLFailure saslFailure = PacketParserUtils.parseSASLFailure((XmlPullParser)parser);
        XMLAssert.assertXMLEqual((String)saslFailureString, (String)saslFailure.toString());
    }

    @Test
    public void parseSASLFailureExtended() throws FactoryConfigurationError, TransformerException, ParserConfigurationException, XmlPullParserException, IOException, SAXException {
        String saslFailureString = XMLBuilder.create((String)"failure", (String)"urn:ietf:params:xml:ns:xmpp-sasl").e(SASLError.account_disabled.toString()).up().e("text").a("xml:lang", "en").t("Call 212-555-1212 for assistance.").up().e("text").a("xml:lang", "de").t("Bitte wenden sie sich an (04321) 123-4444").up().e("text").t("Wusel dusel").asString();
        XmlPullParser parser = TestUtils.getParser(saslFailureString, "failure");
        SaslStreamElements.SASLFailure saslFailure = PacketParserUtils.parseSASLFailure((XmlPullParser)parser);
        XmlUnitUtils.assertSimilar(saslFailureString, (CharSequence)saslFailure.toXML("jabber:client"));
    }

    private static String determineNonDefaultLanguage() {
        String otherLanguage = "jp";
        Locale[] availableLocales = Locale.getAvailableLocales();
        for (int i = 0; i < availableLocales.length && (availableLocales[i] == Locale.getDefault() || (otherLanguage = availableLocales[i].getLanguage().toLowerCase(Locale.US)).length() <= 0); ++i) {
        }
        return otherLanguage;
    }

    @Test(expected=IllegalArgumentException.class)
    public void descriptiveTextNullLangPassedMap() throws Exception {
        String text = "Dummy descriptive text";
        HashMap<Object, String> texts = new HashMap<Object, String>();
        texts.put(null, "Dummy descriptive text");
        ((StanzaError.Builder)StanzaError.getBuilder((StanzaError.Condition)StanzaError.Condition.internal_server_error).setDescriptiveTexts(texts)).build();
    }

    @Test
    public void ensureNoEmptyLangInDescriptiveText() throws Exception {
        String text = "Dummy descriptive text";
        HashMap<String, String> texts = new HashMap<String, String>();
        texts.put("", "Dummy descriptive text");
        StanzaError error = ((StanzaError.Builder)StanzaError.getBuilder((StanzaError.Condition)StanzaError.Condition.internal_server_error).setDescriptiveTexts(texts)).build();
        String errorXml = XMLBuilder.create((String)"error").a("type", "cancel").up().element("internal-server-error", "urn:ietf:params:xml:ns:xmpp-stanzas").up().element("text", "urn:ietf:params:xml:ns:xmpp-stanzas").t("Dummy descriptive text").up().asString();
        XmlUnitUtils.assertSimilar(errorXml, (CharSequence)error.toXML("jabber:client"));
    }

    @Test
    public void ensureNoNullLangInParsedDescriptiveTexts() throws Exception {
        String text = "Dummy descriptive text";
        String errorXml = XMLBuilder.create((String)"error").a("type", "cancel").up().element("internal-server-error", "urn:ietf:params:xml:ns:xmpp-stanzas").up().element("text", "urn:ietf:params:xml:ns:xmpp-stanzas").t("Dummy descriptive text").up().asString();
        XmlPullParser parser = TestUtils.getParser(errorXml);
        StanzaError error = PacketParserUtils.parseError((XmlPullParser)parser).build();
        Assert.assertEquals((Object)"Dummy descriptive text", (Object)error.getDescriptiveText());
    }
}

