/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.packet.Stanza;

public class StanzaCollector {
    private final StanzaFilter packetFilter;
    private final ArrayBlockingQueue<Stanza> resultQueue;
    private final StanzaCollector collectorToReset;
    private final XMPPConnection connection;
    private final Stanza request;
    private volatile boolean cancelled = false;
    private volatile long waitStart;
    private List<Stanza> collectedCache;

    protected StanzaCollector(XMPPConnection connection, Configuration configuration) {
        this.connection = connection;
        this.packetFilter = configuration.packetFilter;
        this.resultQueue = new ArrayBlockingQueue(configuration.size);
        this.collectorToReset = configuration.collectorToReset;
        this.request = configuration.request;
    }

    public void cancel() {
        if (!this.cancelled) {
            this.cancelled = true;
            this.connection.removeStanzaCollector(this);
        }
    }

    @Deprecated
    public StanzaFilter getPacketFilter() {
        return this.getStanzaFilter();
    }

    public StanzaFilter getStanzaFilter() {
        return this.packetFilter;
    }

    public <P extends Stanza> P pollResult() {
        return (P)this.resultQueue.poll();
    }

    public <P extends Stanza> P pollResultOrThrow() throws XMPPException.XMPPErrorException {
        P result = this.pollResult();
        if (result != null) {
            XMPPException.XMPPErrorException.ifHasErrorThenThrow(result);
        }
        return result;
    }

    public <P extends Stanza> P nextResultBlockForever() throws InterruptedException {
        this.throwIfCancelled();
        Stanza res = null;
        while (res == null) {
            res = this.resultQueue.take();
        }
        return (P)res;
    }

    public <P extends Stanza> P nextResult() throws InterruptedException {
        return this.nextResult(this.connection.getReplyTimeout());
    }

    public <P extends Stanza> P nextResult(long timeout) throws InterruptedException {
        this.throwIfCancelled();
        Stanza res = null;
        long remainingWait = timeout;
        this.waitStart = System.currentTimeMillis();
        do {
            if ((res = this.resultQueue.poll(remainingWait, TimeUnit.MILLISECONDS)) == null) continue;
            return (P)res;
        } while ((remainingWait = timeout - (System.currentTimeMillis() - this.waitStart)) > 0L);
        return null;
    }

    public <P extends Stanza> P nextResultOrThrow() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, InterruptedException, SmackException.NotConnectedException {
        return this.nextResultOrThrow(this.connection.getReplyTimeout());
    }

    public <P extends Stanza> P nextResultOrThrow(long timeout) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, InterruptedException, SmackException.NotConnectedException {
        P result = this.nextResult(timeout);
        this.cancel();
        if (result == null) {
            if (!this.connection.isConnected()) {
                throw new SmackException.NotConnectedException(this.connection, this.packetFilter);
            }
            throw SmackException.NoResponseException.newWith(this.connection, this);
        }
        XMPPException.XMPPErrorException.ifHasErrorThenThrow(result);
        return result;
    }

    public List<Stanza> getCollectedStanzasAfterCancelled() {
        if (!this.cancelled) {
            throw new IllegalStateException("Stanza collector was not yet cancelled");
        }
        if (this.collectedCache == null) {
            this.collectedCache = new ArrayList<Stanza>(this.getCollectedCount());
            this.resultQueue.drainTo(this.collectedCache);
        }
        return this.collectedCache;
    }

    public int getCollectedCount() {
        return this.resultQueue.size();
    }

    protected void processStanza(Stanza packet) {
        if (this.packetFilter == null || this.packetFilter.accept(packet)) {
            while (!this.resultQueue.offer(packet)) {
                this.resultQueue.poll();
            }
            if (this.collectorToReset != null) {
                this.collectorToReset.waitStart = System.currentTimeMillis();
            }
        }
    }

    private void throwIfCancelled() {
        if (this.cancelled) {
            throw new IllegalStateException("Stanza collector already cancelled");
        }
    }

    public static Configuration newConfiguration() {
        return new Configuration();
    }

    public static final class Configuration {
        private StanzaFilter packetFilter;
        private int size = SmackConfiguration.getStanzaCollectorSize();
        private StanzaCollector collectorToReset;
        private Stanza request;

        private Configuration() {
        }

        @Deprecated
        public Configuration setPacketFilter(StanzaFilter packetFilter) {
            return this.setStanzaFilter(packetFilter);
        }

        public Configuration setStanzaFilter(StanzaFilter stanzaFilter) {
            this.packetFilter = stanzaFilter;
            return this;
        }

        public Configuration setSize(int size) {
            this.size = size;
            return this;
        }

        public Configuration setCollectorToReset(StanzaCollector collector) {
            this.collectorToReset = collector;
            return this;
        }

        public Configuration setRequest(Stanza request) {
            this.request = request;
            return this;
        }
    }
}

