/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import org.jivesoftware.smack.SmackInitialization;
import org.jivesoftware.smack.compression.XMPPInputOutputStream;
import org.jivesoftware.smack.debugger.ReflectionDebuggerFactory;
import org.jivesoftware.smack.debugger.SmackDebuggerFactory;
import org.jivesoftware.smack.parsing.ExceptionThrowingCallbackWithHint;
import org.jivesoftware.smack.parsing.ParsingExceptionCallback;
import org.jivesoftware.smack.util.Objects;

public final class SmackConfiguration {
    private static int defaultPacketReplyTimeout = 5000;
    private static int packetCollectorSize = 5000;
    private static List<String> defaultMechs = new ArrayList<String>();
    static Set<String> disabledSmackClasses = new HashSet<String>();
    static final List<XMPPInputOutputStream> compressionHandlers = new ArrayList<XMPPInputOutputStream>(2);
    static boolean smackInitialized = false;
    public static boolean DEBUG = false;
    private static SmackDebuggerFactory DEFAULT_DEBUGGER_FACTORY = ReflectionDebuggerFactory.INSTANCE;
    private static ParsingExceptionCallback defaultCallback = new ExceptionThrowingCallbackWithHint();
    private static HostnameVerifier defaultHostnameVerififer;
    private static UnknownIqRequestReplyMode unknownIqRequestReplyMode;

    public static String getVersion() {
        return SmackInitialization.SMACK_VERSION;
    }

    @Deprecated
    public static int getDefaultPacketReplyTimeout() {
        return SmackConfiguration.getDefaultReplyTimeout();
    }

    @Deprecated
    public static void setDefaultPacketReplyTimeout(int timeout) {
        SmackConfiguration.setDefaultReplyTimeout(timeout);
    }

    public static int getDefaultReplyTimeout() {
        if (defaultPacketReplyTimeout <= 0) {
            defaultPacketReplyTimeout = 5000;
        }
        return defaultPacketReplyTimeout;
    }

    public static void setDefaultReplyTimeout(int timeout) {
        if (timeout <= 0) {
            throw new IllegalArgumentException();
        }
        defaultPacketReplyTimeout = timeout;
    }

    public static void setDefaultSmackDebuggerFactory(SmackDebuggerFactory debuggerFactory) {
        DEFAULT_DEBUGGER_FACTORY = Objects.requireNonNull(debuggerFactory, "Debugger factory must not be null");
    }

    public static SmackDebuggerFactory getDefaultSmackDebuggerFactory() {
        return DEFAULT_DEBUGGER_FACTORY;
    }

    public static int getStanzaCollectorSize() {
        return packetCollectorSize;
    }

    public static void setStanzaCollectorSize(int collectorSize) {
        packetCollectorSize = collectorSize;
    }

    public static void addSaslMech(String mech) {
        if (!defaultMechs.contains(mech)) {
            defaultMechs.add(mech);
        }
    }

    public static void addSaslMechs(Collection<String> mechs) {
        for (String mech : mechs) {
            SmackConfiguration.addSaslMech(mech);
        }
    }

    public static void removeSaslMech(String mech) {
        defaultMechs.remove(mech);
    }

    public static void removeSaslMechs(Collection<String> mechs) {
        defaultMechs.removeAll(mechs);
    }

    public static List<String> getSaslMechs() {
        return Collections.unmodifiableList(defaultMechs);
    }

    public static void setDefaultParsingExceptionCallback(ParsingExceptionCallback callback) {
        defaultCallback = callback;
    }

    public static ParsingExceptionCallback getDefaultParsingExceptionCallback() {
        return defaultCallback;
    }

    public static void addCompressionHandler(XMPPInputOutputStream xmppInputOutputStream) {
        compressionHandlers.add(xmppInputOutputStream);
    }

    @Deprecated
    public static List<XMPPInputOutputStream> getCompresionHandlers() {
        return SmackConfiguration.getCompressionHandlers();
    }

    public static List<XMPPInputOutputStream> getCompressionHandlers() {
        ArrayList<XMPPInputOutputStream> res = new ArrayList<XMPPInputOutputStream>(compressionHandlers.size());
        for (XMPPInputOutputStream ios : compressionHandlers) {
            if (!ios.isSupported()) continue;
            res.add(ios);
        }
        return res;
    }

    public static void setDefaultHostnameVerifier(HostnameVerifier verifier) {
        defaultHostnameVerififer = verifier;
    }

    public static void addDisabledSmackClass(Class<?> clz) {
        SmackConfiguration.addDisabledSmackClass(clz.getName());
    }

    public static void addDisabledSmackClass(String className) {
        disabledSmackClasses.add(className);
    }

    public static void addDisabledSmackClasses(String ... classNames) {
        for (String className : classNames) {
            SmackConfiguration.addDisabledSmackClass(className);
        }
    }

    public static boolean isDisabledSmackClass(String className) {
        for (String disabledClassOrPackage : disabledSmackClasses) {
            if (disabledClassOrPackage.equals(className)) {
                return true;
            }
            int lastDotIndex = disabledClassOrPackage.lastIndexOf(46);
            if (disabledClassOrPackage.length() <= lastDotIndex || Character.isUpperCase(disabledClassOrPackage.charAt(lastDotIndex + 1)) || !className.startsWith(disabledClassOrPackage)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSmackInitialized() {
        return smackInitialized;
    }

    static HostnameVerifier getDefaultHostnameVerifier() {
        return defaultHostnameVerififer;
    }

    public static UnknownIqRequestReplyMode getUnknownIqRequestReplyMode() {
        return unknownIqRequestReplyMode;
    }

    public static void setUnknownIqRequestReplyMode(UnknownIqRequestReplyMode unknownIqRequestReplyMode) {
        SmackConfiguration.unknownIqRequestReplyMode = Objects.requireNonNull(unknownIqRequestReplyMode, "Must set mode");
    }

    static {
        unknownIqRequestReplyMode = UnknownIqRequestReplyMode.replyFeatureNotImplemented;
    }

    public static enum UnknownIqRequestReplyMode {
        doNotReply,
        replyFeatureNotImplemented,
        replyServiceUnavailable;

    }
}

