/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.filter;

import org.jivesoftware.smack.filter.FromMatchesFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Stanza;
import org.junit.Assert;
import org.junit.Test;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.JidTestUtil;

public class FromMatchesFilterTest {
    private static final Jid BASE_JID1 = JidTestUtil.BARE_JID_1;
    private static final EntityFullJid FULL_JID1_R1 = JidTestUtil.FULL_JID_1_RESOURCE_1;
    private static final EntityFullJid FULL_JID1_R2 = JidTestUtil.FULL_JID_1_RESOURCE_2;
    private static final Jid BASE_JID2 = JidTestUtil.BARE_JID_2;
    private static final Jid FULL_JID2 = JidTestUtil.FULL_JID_2_RESOURCE_1;
    private static final Jid BASE_JID3 = JidTestUtil.DUMMY_AT_EXAMPLE_ORG;
    private static final Jid SERVICE_JID1 = JidTestUtil.MUC_EXAMPLE_ORG;
    private static final Jid SERVICE_JID2 = JidTestUtil.PUBSUB_EXAMPLE_ORG;

    @Test
    public void autoCompareMatchingEntityFullJid() {
        FromMatchesFilter filter = FromMatchesFilter.create((Jid)FULL_JID1_R1);
        Message packet = new Message();
        packet.setFrom((Jid)FULL_JID1_R1);
        Assert.assertTrue((boolean)filter.accept((Stanza)packet));
        packet.setFrom(BASE_JID1);
        Assert.assertFalse((boolean)filter.accept((Stanza)packet));
        packet.setFrom((Jid)FULL_JID1_R2);
        Assert.assertFalse((boolean)filter.accept((Stanza)packet));
        packet.setFrom(BASE_JID2);
        Assert.assertFalse((boolean)filter.accept((Stanza)packet));
        packet.setFrom(FULL_JID2);
        Assert.assertFalse((boolean)filter.accept((Stanza)packet));
        packet.setFrom(BASE_JID3);
        Assert.assertFalse((boolean)filter.accept((Stanza)packet));
    }

    @Test
    public void autoCompareMatchingBaseJid() {
        FromMatchesFilter filter = FromMatchesFilter.create((Jid)BASE_JID1);
        Message packet = new Message();
        packet.setFrom(BASE_JID1);
        Assert.assertTrue((boolean)filter.accept((Stanza)packet));
        packet.setFrom((Jid)FULL_JID1_R1);
        Assert.assertTrue((boolean)filter.accept((Stanza)packet));
        packet.setFrom((Jid)FULL_JID1_R2);
        Assert.assertTrue((boolean)filter.accept((Stanza)packet));
        packet.setFrom(BASE_JID2);
        Assert.assertFalse((boolean)filter.accept((Stanza)packet));
        packet.setFrom(FULL_JID2);
        Assert.assertFalse((boolean)filter.accept((Stanza)packet));
        packet.setFrom(BASE_JID3);
        Assert.assertFalse((boolean)filter.accept((Stanza)packet));
    }

    @Test
    public void autoCompareMatchingServiceJid() {
        FromMatchesFilter filter = FromMatchesFilter.create((Jid)SERVICE_JID1);
        Message packet = new Message();
        packet.setFrom(SERVICE_JID1);
        Assert.assertTrue((boolean)filter.accept((Stanza)packet));
        packet.setFrom(SERVICE_JID2);
        Assert.assertFalse((boolean)filter.accept((Stanza)packet));
        packet.setFrom(BASE_JID1);
        Assert.assertFalse((boolean)filter.accept((Stanza)packet));
        packet.setFrom((Jid)FULL_JID1_R1);
        Assert.assertFalse((boolean)filter.accept((Stanza)packet));
        packet.setFrom(BASE_JID3);
        Assert.assertFalse((boolean)filter.accept((Stanza)packet));
    }

    @Test
    public void bareCompareMatchingEntityFullJid() {
        FromMatchesFilter filter = FromMatchesFilter.createBare((Jid)FULL_JID1_R1);
        Message packet = new Message();
        packet.setFrom(BASE_JID1);
        Assert.assertTrue((boolean)filter.accept((Stanza)packet));
        packet.setFrom((Jid)FULL_JID1_R1);
        Assert.assertTrue((boolean)filter.accept((Stanza)packet));
        packet.setFrom((Jid)FULL_JID1_R2);
        Assert.assertTrue((boolean)filter.accept((Stanza)packet));
        packet.setFrom(BASE_JID2);
        Assert.assertFalse((boolean)filter.accept((Stanza)packet));
        packet.setFrom(FULL_JID2);
        Assert.assertFalse((boolean)filter.accept((Stanza)packet));
        packet.setFrom(BASE_JID3);
        Assert.assertFalse((boolean)filter.accept((Stanza)packet));
    }

    @Test
    public void bareCompareMatchingBaseJid() {
        FromMatchesFilter filter = FromMatchesFilter.createBare((Jid)BASE_JID1);
        Message packet = new Message();
        packet.setFrom(BASE_JID1);
        Assert.assertTrue((boolean)filter.accept((Stanza)packet));
        packet.setFrom((Jid)FULL_JID1_R1);
        Assert.assertTrue((boolean)filter.accept((Stanza)packet));
        packet.setFrom((Jid)FULL_JID1_R2);
        Assert.assertTrue((boolean)filter.accept((Stanza)packet));
        packet.setFrom(BASE_JID2);
        Assert.assertFalse((boolean)filter.accept((Stanza)packet));
        packet.setFrom(FULL_JID2);
        Assert.assertFalse((boolean)filter.accept((Stanza)packet));
        packet.setFrom(BASE_JID3);
        Assert.assertFalse((boolean)filter.accept((Stanza)packet));
    }

    @Test
    public void bareCompareMatchingServiceJid() {
        FromMatchesFilter filter = FromMatchesFilter.createBare((Jid)SERVICE_JID1);
        Message packet = new Message();
        packet.setFrom(SERVICE_JID1);
        Assert.assertTrue((boolean)filter.accept((Stanza)packet));
        packet.setFrom(SERVICE_JID2);
        Assert.assertFalse((boolean)filter.accept((Stanza)packet));
        packet.setFrom(BASE_JID1);
        Assert.assertFalse((boolean)filter.accept((Stanza)packet));
        packet.setFrom((Jid)FULL_JID1_R1);
        Assert.assertFalse((boolean)filter.accept((Stanza)packet));
        packet.setFrom(BASE_JID3);
        Assert.assertFalse((boolean)filter.accept((Stanza)packet));
    }

    @Test
    public void fullCompareMatchingEntityFullJid() {
        FromMatchesFilter filter = FromMatchesFilter.createFull((Jid)FULL_JID1_R1);
        Message packet = new Message();
        packet.setFrom((Jid)FULL_JID1_R1);
        Assert.assertTrue((boolean)filter.accept((Stanza)packet));
        packet.setFrom(BASE_JID1);
        Assert.assertFalse((boolean)filter.accept((Stanza)packet));
        packet.setFrom((Jid)FULL_JID1_R2);
        Assert.assertFalse((boolean)filter.accept((Stanza)packet));
        packet.setFrom(BASE_JID2);
        Assert.assertFalse((boolean)filter.accept((Stanza)packet));
        packet.setFrom(FULL_JID2);
        Assert.assertFalse((boolean)filter.accept((Stanza)packet));
        packet.setFrom(BASE_JID3);
        Assert.assertFalse((boolean)filter.accept((Stanza)packet));
    }

    @Test
    public void fullCompareMatchingBaseJid() {
        FromMatchesFilter filter = FromMatchesFilter.createFull((Jid)BASE_JID1);
        Message packet = new Message();
        packet.setFrom(BASE_JID1);
        Assert.assertTrue((boolean)filter.accept((Stanza)packet));
        packet.setFrom((Jid)FULL_JID1_R1);
        Assert.assertFalse((boolean)filter.accept((Stanza)packet));
        packet.setFrom((Jid)FULL_JID1_R2);
        Assert.assertFalse((boolean)filter.accept((Stanza)packet));
        packet.setFrom(BASE_JID2);
        Assert.assertFalse((boolean)filter.accept((Stanza)packet));
        packet.setFrom(FULL_JID2);
        Assert.assertFalse((boolean)filter.accept((Stanza)packet));
        packet.setFrom(BASE_JID3);
        Assert.assertFalse((boolean)filter.accept((Stanza)packet));
    }

    @Test
    public void fullCompareMatchingServiceJid() {
        FromMatchesFilter filter = FromMatchesFilter.createFull((Jid)SERVICE_JID1);
        Message packet = new Message();
        packet.setFrom(SERVICE_JID1);
        Assert.assertTrue((boolean)filter.accept((Stanza)packet));
        packet.setFrom(SERVICE_JID2);
        Assert.assertFalse((boolean)filter.accept((Stanza)packet));
        packet.setFrom(BASE_JID1);
        Assert.assertFalse((boolean)filter.accept((Stanza)packet));
        packet.setFrom((Jid)FULL_JID1_R1);
        Assert.assertFalse((boolean)filter.accept((Stanza)packet));
        packet.setFrom(BASE_JID3);
        Assert.assertFalse((boolean)filter.accept((Stanza)packet));
    }
}

