/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.StreamError;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.junit.Assert;
import org.junit.Test;
import org.xmlpull.v1.XmlPullParser;

public class StreamErrorTest {
    @Test
    public void testParsingOfSimpleStreamError() {
        StreamError error = null;
        String xml = "<stream:stream from='im.example.com' id='++TR84Sm6A3hnt3Q065SnAbbk3Y=' xmlns:stream='http://etherx.jabber.org/streams'><stream:error><conflict xmlns='urn:ietf:params:xml:ns:xmpp-streams' /> +</stream:error></stream:stream>";
        try {
            XmlPullParser parser = PacketParserUtils.getParserFor((String)"<stream:stream from='im.example.com' id='++TR84Sm6A3hnt3Q065SnAbbk3Y=' xmlns:stream='http://etherx.jabber.org/streams'><stream:error><conflict xmlns='urn:ietf:params:xml:ns:xmpp-streams' /> +</stream:error></stream:stream>", (String)"error");
            error = PacketParserUtils.parseStreamError((XmlPullParser)parser);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)error);
        Assert.assertEquals((Object)StreamError.Condition.conflict, (Object)error.getCondition());
    }

    @Test
    public void testParsingOfStreamErrorWithText() {
        StreamError error = null;
        String xml = "<stream:stream from='im.example.com' id='++TR84Sm6A3hnt3Q065SnAbbk3Y=' xmlns:stream='http://etherx.jabber.org/streams'><stream:error><conflict xmlns='urn:ietf:params:xml:ns:xmpp-streams' /><text xml:lang='' xmlns='urn:ietf:params:xml:ns:xmpp-streams'>Replaced by new connection</text></stream:error></stream:stream>";
        try {
            XmlPullParser parser = PacketParserUtils.getParserFor((String)"<stream:stream from='im.example.com' id='++TR84Sm6A3hnt3Q065SnAbbk3Y=' xmlns:stream='http://etherx.jabber.org/streams'><stream:error><conflict xmlns='urn:ietf:params:xml:ns:xmpp-streams' /><text xml:lang='' xmlns='urn:ietf:params:xml:ns:xmpp-streams'>Replaced by new connection</text></stream:error></stream:stream>", (String)"error");
            error = PacketParserUtils.parseStreamError((XmlPullParser)parser);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)error);
        Assert.assertEquals((Object)StreamError.Condition.conflict, (Object)error.getCondition());
        Assert.assertEquals((Object)"Replaced by new connection", (Object)error.getDescriptiveText());
    }

    @Test
    public void testParsingOfStreamErrorWithTextAndOptionalElement() {
        StreamError error = null;
        String xml = "<stream:stream from='im.example.com' id='++TR84Sm6A3hnt3Q065SnAbbk3Y=' xmlns:stream='http://etherx.jabber.org/streams'><stream:error><conflict xmlns='urn:ietf:params:xml:ns:xmpp-streams' /><text xml:lang='' xmlns='urn:ietf:params:xml:ns:xmpp-streams'>Replaced by new connection</text><appSpecificElement xmlns='myns'>Text contents of application-specific condition element: Foo Bar</appSpecificElement></stream:error></stream:stream>";
        try {
            XmlPullParser parser = PacketParserUtils.getParserFor((String)"<stream:stream from='im.example.com' id='++TR84Sm6A3hnt3Q065SnAbbk3Y=' xmlns:stream='http://etherx.jabber.org/streams'><stream:error><conflict xmlns='urn:ietf:params:xml:ns:xmpp-streams' /><text xml:lang='' xmlns='urn:ietf:params:xml:ns:xmpp-streams'>Replaced by new connection</text><appSpecificElement xmlns='myns'>Text contents of application-specific condition element: Foo Bar</appSpecificElement></stream:error></stream:stream>", (String)"error");
            error = PacketParserUtils.parseStreamError((XmlPullParser)parser);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)error);
        Assert.assertEquals((Object)StreamError.Condition.conflict, (Object)error.getCondition());
        Assert.assertEquals((Object)"Replaced by new connection", (Object)error.getDescriptiveText());
        ExtensionElement appSpecificElement = error.getExtension("appSpecificElement", "myns");
        Assert.assertNotNull((Object)appSpecificElement);
    }

    @Test
    public void testStreamErrorXmlNotWellFormed() {
        StreamError error = null;
        String xml = "<stream:stream from='im.example.com' id='++TR84Sm6A3hnt3Q065SnAbbk3Y=' xmlns:stream='http://etherx.jabber.org/streams'><stream:error><xml-not-well-formed xmlns='urn:ietf:params:xml:ns:xmpp-streams'/></stream:error></stream:stream>";
        try {
            XmlPullParser parser = PacketParserUtils.getParserFor((String)"<stream:stream from='im.example.com' id='++TR84Sm6A3hnt3Q065SnAbbk3Y=' xmlns:stream='http://etherx.jabber.org/streams'><stream:error><xml-not-well-formed xmlns='urn:ietf:params:xml:ns:xmpp-streams'/></stream:error></stream:stream>", (String)"error");
            error = PacketParserUtils.parseStreamError((XmlPullParser)parser);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)error);
        Assert.assertEquals((Object)StreamError.Condition.not_well_formed, (Object)error.getCondition());
    }
}

