/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import org.jivesoftware.smack.packet.ErrorIQ;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.packet.TestIQ;
import org.junit.Assert;
import org.junit.Test;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.stringprep.XmppStringprepException;

public class IQResponseTest {
    private static final String ELEMENT = "child";
    private static final String NAMESPACE = "http://igniterealtime.org/protocol/test";

    @Test
    public void testGeneratingSimpleResponse() throws XmppStringprepException {
        TestIQ request = new TestIQ(ELEMENT, NAMESPACE);
        request.setFrom(JidCreate.from((String)"sender@test/Smack"));
        request.setTo(JidCreate.from((String)"receiver@test/Smack"));
        IQ result = IQ.createResultIQ((IQ)request);
        Assert.assertEquals((Object)IQ.Type.result, (Object)result.getType());
        Assert.assertNotNull((Object)result.getStanzaId());
        Assert.assertEquals((Object)request.getStanzaId(), (Object)result.getStanzaId());
        Assert.assertEquals((Object)request.getFrom(), (Object)result.getTo());
        Assert.assertEquals((Object)request.getTo(), (Object)result.getFrom());
        Assert.assertEquals((Object)"", (Object)result.getChildElementXML().toString());
    }

    @Test
    public void testGeneratingValidErrorResponse() throws XmppStringprepException {
        StanzaError.Builder error = StanzaError.getBuilder((StanzaError.Condition)StanzaError.Condition.bad_request);
        TestIQ request = new TestIQ(ELEMENT, NAMESPACE);
        request.setType(IQ.Type.set);
        request.setFrom(JidCreate.from((String)"sender@test/Smack"));
        request.setTo(JidCreate.from((String)"receiver@test/Smack"));
        ErrorIQ result = IQ.createErrorResponse((IQ)request, (StanzaError.Builder)error);
        Assert.assertEquals((Object)IQ.Type.error, (Object)result.getType());
        Assert.assertNotNull((Object)result.getStanzaId());
        Assert.assertEquals((Object)request.getStanzaId(), (Object)result.getStanzaId());
        Assert.assertEquals((Object)request.getFrom(), (Object)result.getTo());
        Assert.assertEquals((Object)error.build().toXML(), (Object)result.getError().toXML());
    }

    @Test
    public void testGeneratingResponseBasedOnResult() throws XmppStringprepException {
        TestIQ request = new TestIQ(ELEMENT, NAMESPACE);
        request.setType(IQ.Type.result);
        request.setFrom(JidCreate.from((String)"sender@test/Smack"));
        request.setTo(JidCreate.from((String)"receiver@test/Smack"));
        try {
            IQ.createResultIQ((IQ)request);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        Assert.fail((String)"It shouldn't be possible to generate a response for a result IQ!");
    }

    @Test
    public void testGeneratingErrorBasedOnError() throws XmppStringprepException {
        StanzaError.Builder error = StanzaError.getBuilder((StanzaError.Condition)StanzaError.Condition.bad_request);
        TestIQ request = new TestIQ(ELEMENT, NAMESPACE);
        request.setType(IQ.Type.error);
        request.setFrom(JidCreate.from((String)"sender@test/Smack"));
        request.setTo(JidCreate.from((String)"receiver@test/Smack"));
        request.setError(error);
        try {
            IQ.createErrorResponse((IQ)request, (StanzaError.Builder)error);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        Assert.fail((String)"It shouldn't be possible to generate a response for a error IQ!");
    }
}

