/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.custommonkey.xmlunit.XMLAssert;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.test.util.XmlUnitUtils;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.SAXException;

public class MessageTest {
    @Test
    public void setMessageTypeTest() throws IOException, SAXException {
        Message.Type type = Message.Type.chat;
        Message.Type type2 = Message.Type.headline;
        StringBuilder controlBuilder = new StringBuilder();
        controlBuilder.append("<message").append(" type=\"").append(type).append("\">").append("</message>");
        String control = controlBuilder.toString();
        Message messageTypeInConstructor = new Message(null, Message.Type.chat);
        messageTypeInConstructor.setStanzaId(null);
        Assert.assertEquals((Object)type, (Object)messageTypeInConstructor.getType());
        XMLAssert.assertXMLEqual((String)control, (String)messageTypeInConstructor.toXML("jabber:client").toString());
        controlBuilder = new StringBuilder();
        controlBuilder.append("<message").append(" type=\"").append(type2).append("\">").append("</message>");
        control = controlBuilder.toString();
        Message messageTypeSet = MessageTest.getNewMessage();
        messageTypeSet.setType(type2);
        Assert.assertEquals((Object)type2, (Object)messageTypeSet.getType());
        XMLAssert.assertXMLEqual((String)control, (String)messageTypeSet.toXML("jabber:client").toString());
    }

    @Test(expected=NullPointerException.class)
    public void setNullMessageBodyTest() {
        Message message = MessageTest.getNewMessage();
        message.addBody(null, null);
    }

    @Test
    public void setMessageSubjectTest() throws IOException, SAXException {
        String messageSubject = "This is a test of the emergency broadcast system.";
        StringBuilder controlBuilder = new StringBuilder();
        controlBuilder.append("<message>").append("<subject>").append("This is a test of the emergency broadcast system.").append("</subject>").append("</message>");
        String control = controlBuilder.toString();
        Message message = MessageTest.getNewMessage();
        message.setSubject("This is a test of the emergency broadcast system.");
        Assert.assertEquals((Object)"This is a test of the emergency broadcast system.", (Object)message.getSubject());
        XMLAssert.assertXMLEqual((String)control, (String)message.toXML("jabber:client").toString());
    }

    @Test
    public void oneMessageBodyTest() throws IOException, SAXException {
        String messageBody = "This is a test of the emergency broadcast system.";
        StringBuilder controlBuilder = new StringBuilder();
        controlBuilder.append("<message>").append("<body>").append("This is a test of the emergency broadcast system.").append("</body>").append("</message>");
        String control = controlBuilder.toString();
        Message message = MessageTest.getNewMessage();
        message.setBody("This is a test of the emergency broadcast system.");
        Assert.assertEquals((Object)"This is a test of the emergency broadcast system.", (Object)message.getBody());
        XMLAssert.assertXMLEqual((String)control, (String)message.toXML("jabber:client").toString());
    }

    @Test
    public void multipleMessageBodiesTest() throws IOException, SAXException {
        String messageBody1 = "This is a test of the emergency broadcast system, 1.";
        String lang2 = "ru";
        String messageBody2 = "This is a test of the emergency broadcast system, 2.";
        String lang3 = "sp";
        String messageBody3 = "This is a test of the emergency broadcast system, 3.";
        StringBuilder controlBuilder = new StringBuilder();
        controlBuilder.append("<message>").append("<body>").append("This is a test of the emergency broadcast system, 1.").append("</body>").append("<body xml:lang=\"").append("ru").append("\">").append("This is a test of the emergency broadcast system, 2.").append("</body>").append("<body xml:lang=\"").append("sp").append("\">").append("This is a test of the emergency broadcast system, 3.").append("</body>").append("</message>");
        String control = controlBuilder.toString();
        Message message = MessageTest.getNewMessage();
        message.addBody(null, "This is a test of the emergency broadcast system, 1.");
        message.addBody("ru", "This is a test of the emergency broadcast system, 2.");
        message.addBody("sp", "This is a test of the emergency broadcast system, 3.");
        XmlUnitUtils.assertSimilar(control, (CharSequence)message.toXML("jabber:client"));
        List languages = message.getBodyLanguages();
        ArrayList<String> controlLanguages = new ArrayList<String>();
        controlLanguages.add("ru");
        controlLanguages.add("sp");
        controlLanguages.removeAll(languages);
        Assert.assertTrue((controlLanguages.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void removeMessageBodyTest() {
        Message message = MessageTest.getNewMessage();
        message.setBody("test");
        Assert.assertTrue((message.getBodies().size() == 1 ? 1 : 0) != 0);
        message.setBody(null);
        Assert.assertTrue((message.getBodies().size() == 0 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)message.removeBody("sp"));
        Message.Body body = message.addBody("es", "test");
        Assert.assertTrue((message.getBodies().size() == 1 ? 1 : 0) != 0);
        message.removeBody(body);
        Assert.assertTrue((message.getBodies().size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void setMessageThreadTest() throws IOException, SAXException {
        String messageThread = "1234";
        StringBuilder controlBuilder = new StringBuilder();
        controlBuilder.append("<message>").append("<thread>").append("1234").append("</thread>").append("</message>");
        String control = controlBuilder.toString();
        Message message = MessageTest.getNewMessage();
        message.setThread("1234");
        Assert.assertEquals((Object)"1234", (Object)message.getThread());
        XMLAssert.assertXMLEqual((String)control, (String)message.toXML("jabber:client").toString());
    }

    @Test
    public void messageXmlLangTest() throws IOException, SAXException {
        String lang = "sp";
        StringBuilder controlBuilder = new StringBuilder();
        controlBuilder.append("<message").append(" xml:lang=\"").append("sp").append("\">").append("</message>");
        String control = controlBuilder.toString();
        Message message = MessageTest.getNewMessage();
        message.setLanguage("sp");
        XMLAssert.assertXMLEqual((String)control, (String)message.toXML("jabber:client").toString());
    }

    private static Message getNewMessage() {
        Message message = new Message();
        message.setStanzaId(null);
        return message;
    }
}

