/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import org.jivesoftware.smack.StanzaCollector;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.packet.Stanza;
import org.junit.Assert;
import org.junit.Test;

public class StanzaCollectorTest {
    @Test
    public void verifyRollover() throws InterruptedException {
        TestPacket testPacket;
        int i;
        TestStanzaCollector collector = new TestStanzaCollector(null, new OKEverything(), 5);
        for (i = 0; i < 6; ++i) {
            testPacket = new TestPacket(i);
            collector.processStanza(testPacket);
        }
        Assert.assertEquals((Object)"1", (Object)collector.nextResultBlockForever().getStanzaId());
        Assert.assertEquals((Object)"2", (Object)collector.nextResultBlockForever().getStanzaId());
        Assert.assertEquals((Object)"3", (Object)collector.nextResultBlockForever().getStanzaId());
        Assert.assertEquals((Object)"4", (Object)collector.nextResultBlockForever().getStanzaId());
        Assert.assertEquals((Object)"5", (Object)collector.pollResult().getStanzaId());
        Assert.assertNull((Object)collector.pollResult());
        for (i = 10; i < 15; ++i) {
            testPacket = new TestPacket(i);
            collector.processStanza(testPacket);
        }
        Assert.assertEquals((Object)"10", (Object)collector.nextResultBlockForever().getStanzaId());
        Assert.assertEquals((Object)"11", (Object)collector.nextResultBlockForever().getStanzaId());
        Assert.assertEquals((Object)"12", (Object)collector.nextResultBlockForever().getStanzaId());
        Assert.assertEquals((Object)"13", (Object)collector.nextResultBlockForever().getStanzaId());
        Assert.assertEquals((Object)"14", (Object)collector.pollResult().getStanzaId());
        Assert.assertNull((Object)collector.pollResult());
        Assert.assertNull((Object)collector.nextResult(1000L));
    }

    @Test
    public void verifyThreadSafety() {
        int insertCount = 500;
        final TestStanzaCollector collector = new TestStanzaCollector(null, new OKEverything(), insertCount);
        Thread consumer1 = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (true) {
                        try {
                            Thread.sleep(3L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        Stanza stanza = collector.nextResultBlockForever();
                    }
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        consumer1.setName("consumer 1");
        Thread consumer2 = new Thread(new Runnable(){

            @Override
            public void run() {
                Stanza p;
                do {
                    try {
                        Thread.sleep(3L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    try {
                        p = collector.nextResult(1L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                } while (p != null);
            }
        });
        consumer2.setName("consumer 2");
        Thread consumer3 = new Thread(new Runnable(){

            @Override
            public void run() {
                Stanza p;
                do {
                    try {
                        Thread.sleep(3L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while ((p = collector.pollResult()) != null);
            }
        });
        consumer3.setName("consumer 3");
        consumer1.start();
        consumer2.start();
        consumer3.start();
        for (int i = 0; i < insertCount; ++i) {
            collector.processStanza(new TestPacket(i));
        }
        try {
            Thread.sleep(5000L);
            consumer3.join();
            consumer2.join();
            consumer1.interrupt();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertNull((Object)collector.pollResult());
    }

    static class TestPacket
    extends Stanza {
        TestPacket(int i) {
            this.setStanzaId(String.valueOf(i));
        }

        public String toXML(String enclosingNamespace) {
            return "<packetId>" + this.getStanzaId() + "</packetId>";
        }

        public String toString() {
            return this.toXML(null);
        }
    }

    static class TestStanzaCollector
    extends StanzaCollector {
        protected TestStanzaCollector(XMPPConnection conection, StanzaFilter packetFilter, int size) {
            super(conection, StanzaCollector.newConfiguration().setStanzaFilter(packetFilter).setSize(size));
        }
    }

    static class OKEverything
    implements StanzaFilter {
        OKEverything() {
        }

        public boolean accept(Stanza packet) {
            return true;
        }
    }
}

