/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.Map;
import java.util.Queue;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import org.jivesoftware.smack.AbstractXMPPConnection;

public class AsyncButOrdered<K> {
    private final Map<K, Queue<Runnable>> pendingRunnables = new WeakHashMap<K, Queue<Runnable>>();
    private final Map<K, Boolean> threadActiveMap = new WeakHashMap<K, Boolean>();
    private final Executor executor;

    public AsyncButOrdered() {
        this(null);
    }

    public AsyncButOrdered(Executor executor) {
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean performAsyncButOrdered(K key, Runnable runnable) {
        boolean newHandler;
        Queue<Runnable> keyQueue;
        Map<K, Queue<Runnable>> map = this.pendingRunnables;
        synchronized (map) {
            keyQueue = this.pendingRunnables.get(key);
            if (keyQueue == null) {
                keyQueue = new ConcurrentLinkedQueue<Runnable>();
                this.pendingRunnables.put(key, keyQueue);
            }
        }
        keyQueue.add(runnable);
        Map<K, Boolean> map2 = this.threadActiveMap;
        synchronized (map2) {
            Boolean threadActive = this.threadActiveMap.get(key);
            if (threadActive == null) {
                threadActive = false;
                this.threadActiveMap.put(key, threadActive);
            }
            boolean bl = newHandler = threadActive == false;
            if (newHandler) {
                Handler handler = new Handler(keyQueue, key);
                this.threadActiveMap.put(key, true);
                if (this.executor == null) {
                    AbstractXMPPConnection.asyncGo(handler);
                } else {
                    this.executor.execute(handler);
                }
            }
        }
        return newHandler;
    }

    public Executor asExecutorFor(final K key) {
        return new Executor(){

            @Override
            public void execute(Runnable runnable) {
                AsyncButOrdered.this.performAsyncButOrdered(key, runnable);
            }
        };
    }

    private class Handler
    implements Runnable {
        private final Queue<Runnable> keyQueue;
        private final K key;

        Handler(Queue<Runnable> keyQueue, K key) {
            this.keyQueue = keyQueue;
            this.key = key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Runnable runnable = null;
                while ((runnable = this.keyQueue.poll()) != null) {
                    try {
                        runnable.run();
                    }
                    catch (Throwable t) {
                        Map map = AsyncButOrdered.this.threadActiveMap;
                        synchronized (map) {
                            AsyncButOrdered.this.threadActiveMap.put(this.key, false);
                        }
                        throw t;
                    }
                }
                Map map = AsyncButOrdered.this.threadActiveMap;
                synchronized (map) {
                    if (this.keyQueue.isEmpty()) {
                        AsyncButOrdered.this.threadActiveMap.put(this.key, false);
                        break;
                    }
                }
            }
        }
    }
}

