/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.Nonza;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.TopLevelStreamElement;

public class SynchronizationPoint<E extends Exception> {
    private final AbstractXMPPConnection connection;
    private final Lock connectionLock;
    private final Condition condition;
    private final String waitFor;
    private State state;
    private E failureException;
    private SmackException.SmackWrappedException smackWrappedExcpetion;
    private volatile long waitStart;

    public SynchronizationPoint(AbstractXMPPConnection connection, String waitFor) {
        this.connection = connection;
        this.connectionLock = connection.getConnectionLock();
        this.condition = connection.getConnectionLock().newCondition();
        this.waitFor = waitFor;
        this.init();
    }

    public void init() {
        this.connectionLock.lock();
        this.state = State.Initial;
        this.failureException = null;
        this.smackWrappedExcpetion = null;
        this.connectionLock.unlock();
    }

    public Exception sendAndWaitForResponse(TopLevelStreamElement request) throws SmackException.NoResponseException, SmackException.NotConnectedException, InterruptedException {
        assert (this.state == State.Initial);
        this.connectionLock.lock();
        try {
            if (request != null) {
                if (request instanceof Stanza) {
                    this.connection.sendStanza((Stanza)request);
                } else if (request instanceof Nonza) {
                    this.connection.sendNonza((Nonza)request);
                } else {
                    throw new IllegalStateException("Unsupported element type");
                }
                this.state = State.RequestSent;
            }
            this.waitForConditionOrTimeout();
        }
        finally {
            this.connectionLock.unlock();
        }
        return this.checkForResponse();
    }

    public void sendAndWaitForResponseOrThrow(Nonza request) throws E, SmackException.NoResponseException, SmackException.NotConnectedException, InterruptedException, SmackException.SmackWrappedException {
        this.sendAndWaitForResponse(request);
        switch (this.state) {
            case Failure: {
                this.throwException();
                break;
            }
        }
    }

    public void checkIfSuccessOrWaitOrThrow() throws SmackException.NoResponseException, E, InterruptedException, SmackException.SmackWrappedException {
        this.checkIfSuccessOrWait();
        if (this.state == State.Failure) {
            this.throwException();
        }
    }

    public Exception checkIfSuccessOrWait() throws SmackException.NoResponseException, InterruptedException {
        this.connectionLock.lock();
        try {
            switch (this.state) {
                case Success: {
                    Exception exception = null;
                    return exception;
                }
                case Failure: {
                    Exception exception = this.getException();
                    return exception;
                }
            }
            this.waitForConditionOrTimeout();
        }
        finally {
            this.connectionLock.unlock();
        }
        return this.checkForResponse();
    }

    public void reportSuccess() {
        this.connectionLock.lock();
        try {
            this.state = State.Success;
            this.condition.signalAll();
        }
        finally {
            this.connectionLock.unlock();
        }
    }

    @Deprecated
    public void reportFailure() {
        this.reportFailure(null);
    }

    public void reportFailure(E failureException) {
        assert (failureException != null);
        this.connectionLock.lock();
        try {
            this.state = State.Failure;
            this.failureException = failureException;
            this.condition.signalAll();
        }
        finally {
            this.connectionLock.unlock();
        }
    }

    public void reportGenericFailure(SmackException.SmackWrappedException exception) {
        assert (exception != null);
        this.connectionLock.lock();
        try {
            this.state = State.Failure;
            this.smackWrappedExcpetion = exception;
            this.condition.signalAll();
        }
        finally {
            this.connectionLock.unlock();
        }
    }

    public boolean wasSuccessful() {
        this.connectionLock.lock();
        try {
            boolean bl = this.state == State.Success;
            return bl;
        }
        finally {
            this.connectionLock.unlock();
        }
    }

    public boolean isNotInInitialState() {
        this.connectionLock.lock();
        try {
            boolean bl = this.state != State.Initial;
            return bl;
        }
        finally {
            this.connectionLock.unlock();
        }
    }

    public boolean requestSent() {
        this.connectionLock.lock();
        try {
            boolean bl = this.state == State.RequestSent;
            return bl;
        }
        finally {
            this.connectionLock.unlock();
        }
    }

    public E getFailureException() {
        this.connectionLock.lock();
        try {
            E e = this.failureException;
            return e;
        }
        finally {
            this.connectionLock.unlock();
        }
    }

    public void resetTimeout() {
        this.waitStart = System.currentTimeMillis();
    }

    private void waitForConditionOrTimeout() throws InterruptedException {
        this.waitStart = System.currentTimeMillis();
        while (this.state == State.RequestSent || this.state == State.Initial) {
            long timeout = this.connection.getReplyTimeout();
            long remainingWaitMillis = timeout - (System.currentTimeMillis() - this.waitStart);
            long remainingWait = TimeUnit.MILLISECONDS.toNanos(remainingWaitMillis);
            if (remainingWait <= 0L) {
                this.state = State.NoResponse;
                break;
            }
            try {
                this.condition.awaitNanos(remainingWait);
            }
            catch (InterruptedException e) {
                this.state = State.Interrupted;
                throw e;
            }
        }
    }

    private Exception getException() {
        if (this.failureException != null) {
            return this.failureException;
        }
        return this.smackWrappedExcpetion;
    }

    private void throwException() throws E, SmackException.SmackWrappedException {
        if (this.failureException != null) {
            throw this.failureException;
        }
        throw this.smackWrappedExcpetion;
    }

    private Exception checkForResponse() throws SmackException.NoResponseException {
        switch (this.state) {
            case Initial: 
            case NoResponse: 
            case RequestSent: {
                throw SmackException.NoResponseException.newWith((XMPPConnection)this.connection, this.waitFor);
            }
            case Success: {
                return null;
            }
            case Failure: {
                return this.getException();
            }
        }
        throw new AssertionError((Object)("Unknown state " + (Object)((Object)this.state)));
    }

    private static enum State {
        Initial,
        RequestSent,
        NoResponse,
        Success,
        Failure,
        Interrupted;

    }
}

