/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.fsm;

import org.jivesoftware.smack.fsm.AbstractXmppStateMachineConnection;
import org.jivesoftware.smack.fsm.StateDescriptor;

public class ConnectionStateEvent {
    private final StateDescriptor stateDescriptor;
    private final long timestamp;

    protected ConnectionStateEvent(StateDescriptor stateDescriptor) {
        this.stateDescriptor = stateDescriptor;
        this.timestamp = System.currentTimeMillis();
    }

    public StateDescriptor getStateDescriptor() {
        return this.stateDescriptor;
    }

    public String toString() {
        return this.stateDescriptor.getStateName() + ' ' + this.getClass().getSimpleName();
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public static abstract class DetailedTransitionIntoInformation
    extends ConnectionStateEvent {
        protected DetailedTransitionIntoInformation(AbstractXmppStateMachineConnection.State state) {
            super(state.getStateDescriptor());
        }
    }

    public static class SuccessfullyTransitionedInto
    extends ConnectionStateEvent {
        private final AbstractXmppStateMachineConnection.TransitionSuccessResult transitionSuccessResult;

        SuccessfullyTransitionedInto(AbstractXmppStateMachineConnection.State state, AbstractXmppStateMachineConnection.TransitionSuccessResult transitionSuccessResult) {
            super(state.getStateDescriptor());
            this.transitionSuccessResult = transitionSuccessResult;
        }

        @Override
        public String toString() {
            return super.toString() + ": " + this.transitionSuccessResult;
        }
    }

    public static class TransitionFailed
    extends ConnectionStateEvent {
        private final AbstractXmppStateMachineConnection.TransitionFailureResult transitionFailedReason;

        TransitionFailed(AbstractXmppStateMachineConnection.State state, AbstractXmppStateMachineConnection.TransitionFailureResult transitionFailedReason) {
            super(state.getStateDescriptor());
            this.transitionFailedReason = transitionFailedReason;
        }

        @Override
        public String toString() {
            return super.toString() + ": " + this.transitionFailedReason;
        }
    }

    public static class AboutToTransitionInto
    extends ConnectionStateEvent {
        AboutToTransitionInto(AbstractXmppStateMachineConnection.State state) {
            super(state.getStateDescriptor());
        }
    }

    public static class TransitionNotPossible
    extends ConnectionStateEvent {
        private final AbstractXmppStateMachineConnection.TransitionImpossibleReason transitionImpossibleReason;

        TransitionNotPossible(AbstractXmppStateMachineConnection.State state, AbstractXmppStateMachineConnection.TransitionImpossibleReason reason) {
            super(state.getStateDescriptor());
            this.transitionImpossibleReason = reason;
        }

        @Override
        public String toString() {
            return super.toString() + ": " + this.transitionImpossibleReason;
        }
    }

    public static class FinalStateReached
    extends ConnectionStateEvent {
        FinalStateReached(AbstractXmppStateMachineConnection.State state) {
            super(state.getStateDescriptor());
        }
    }

    public static class StateRevertBackwardsWalk
    extends ConnectionStateEvent {
        StateRevertBackwardsWalk(AbstractXmppStateMachineConnection.State state) {
            super(state.getStateDescriptor());
        }
    }
}

