/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import java.util.List;
import java.util.Locale;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.packet.EmptyResultIQ;
import org.jivesoftware.smack.packet.ErrorIQ;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.XmlStringBuilder;

public abstract class IQ
extends Stanza {
    public static final String IQ_ELEMENT = "iq";
    public static final String QUERY_ELEMENT = "query";
    private final QName childElementQName;
    private final String childElementName;
    private final String childElementNamespace;
    private Type type = Type.get;

    public IQ(IQ iq) {
        super(iq);
        this.type = iq.getType();
        this.childElementName = iq.childElementName;
        this.childElementNamespace = iq.childElementNamespace;
        this.childElementQName = iq.childElementQName;
    }

    protected IQ(String childElementName) {
        this(childElementName, null);
    }

    protected IQ(String childElementName, String childElementNamespace) {
        this.childElementName = childElementName;
        this.childElementNamespace = childElementNamespace;
        this.childElementQName = childElementName == null ? null : new QName(childElementNamespace, childElementName);
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = Objects.requireNonNull(type, "type must not be null");
    }

    public boolean isRequestIQ() {
        switch (this.type) {
            case get: 
            case set: {
                return true;
            }
        }
        return false;
    }

    public boolean isResponseIQ() {
        return !this.isRequestIQ();
    }

    public final QName getChildElementQName() {
        return this.childElementQName;
    }

    public final String getChildElementName() {
        return this.childElementName;
    }

    public final String getChildElementNamespace() {
        return this.childElementNamespace;
    }

    @Override
    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("IQ Stanza (");
        sb.append(this.getChildElementName()).append(' ').append(this.getChildElementNamespace());
        sb.append(") [");
        this.logCommonAttributes(sb);
        sb.append("type=").append((Object)this.type).append(',');
        sb.append(']');
        return sb.toString();
    }

    @Override
    public final XmlStringBuilder toXML(XmlEnvironment enclosingXmlEnvironment) {
        XmlStringBuilder buf = new XmlStringBuilder(enclosingXmlEnvironment);
        buf.halfOpenElement(IQ_ELEMENT);
        this.addCommonAttributes(buf, enclosingXmlEnvironment);
        if (this.type == null) {
            buf.attribute("type", "get");
        } else {
            buf.attribute("type", this.type.toString());
        }
        buf.rightAngleBracket();
        buf.append(this.getChildElementXML(enclosingXmlEnvironment));
        buf.closeElement(IQ_ELEMENT);
        return buf;
    }

    public final XmlStringBuilder getChildElementXML() {
        return this.getChildElementXML(null);
    }

    public final XmlStringBuilder getChildElementXML(XmlEnvironment enclosingXmlEnvironment) {
        IQChildElementXmlStringBuilder iqChildElement;
        XmlStringBuilder xml = new XmlStringBuilder();
        if (this.type == Type.error) {
            this.appendErrorIfExists(xml, enclosingXmlEnvironment);
        } else if (this.childElementName != null && (iqChildElement = this.getIQChildElementBuilder(new IQChildElementXmlStringBuilder(this))) != null) {
            xml.append(iqChildElement);
            List<ExtensionElement> extensionsXml = this.getExtensions();
            if (iqChildElement.isEmptyElement) {
                if (extensionsXml.isEmpty()) {
                    xml.closeEmptyElement();
                    return xml;
                }
                xml.rightAngleBracket();
            }
            xml.append(extensionsXml);
            xml.closeElement(iqChildElement.element);
        }
        return xml;
    }

    protected abstract IQChildElementXmlStringBuilder getIQChildElementBuilder(IQChildElementXmlStringBuilder var1);

    @Deprecated
    protected final void initialzeAsResultFor(IQ request) {
        this.initializeAsResultFor(request);
    }

    protected final void initializeAsResultFor(IQ request) {
        assert (this != request);
        if (request.getType() != Type.get && request.getType() != Type.set) {
            throw new IllegalArgumentException("IQ must be of type 'set' or 'get'. Original IQ: " + request.toXML());
        }
        this.setStanzaId(request.getStanzaId());
        this.setFrom(request.getTo());
        this.setTo(request.getFrom());
        this.setType(Type.result);
    }

    public static IQ createResultIQ(IQ request) {
        return new EmptyResultIQ(request);
    }

    public static ErrorIQ createErrorResponse(IQ request, StanzaError.Builder error) {
        if (!request.isRequestIQ()) {
            throw new IllegalArgumentException("IQ must be of type 'set' or 'get'. Original IQ: " + request.toXML());
        }
        ErrorIQ result = new ErrorIQ(error);
        result.setStanzaId(request.getStanzaId());
        result.setFrom(request.getTo());
        result.setTo(request.getFrom());
        error.setStanza(result);
        return result;
    }

    public static ErrorIQ createErrorResponse(IQ request, StanzaError.Condition condition) {
        return IQ.createErrorResponse(request, StanzaError.getBuilder(condition));
    }

    public static ErrorIQ createErrorResponse(IQ request, StanzaError error) {
        return IQ.createErrorResponse(request, StanzaError.getBuilder(error));
    }

    public static class IQChildElementXmlStringBuilder
    extends XmlStringBuilder {
        private final String element;
        private boolean isEmptyElement;

        private IQChildElementXmlStringBuilder(IQ iq) {
            this(iq.getChildElementName(), iq.getChildElementNamespace());
        }

        public IQChildElementXmlStringBuilder(ExtensionElement pe) {
            this(pe.getElementName(), pe.getNamespace());
        }

        private IQChildElementXmlStringBuilder(String element, String namespace) {
            this.prelude(element, namespace);
            this.element = element;
        }

        public void setEmptyElement() {
            this.isEmptyElement = true;
        }
    }

    public static enum Type {
        get,
        set,
        result,
        error;


        public static Type fromString(String string) {
            return Type.valueOf(string.toLowerCase(Locale.US));
        }
    }
}

