/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.sasl;

import java.text.Normalizer;
import javax.net.ssl.SSLSession;
import javax.security.auth.callback.CallbackHandler;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.sasl.packet.SaslStreamElements;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.stringencoder.Base64;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.EntityBareJid;

public abstract class SASLMechanism
implements Comparable<SASLMechanism> {
    public static final String CRAMMD5 = "CRAM-MD5";
    public static final String DIGESTMD5 = "DIGEST-MD5";
    public static final String EXTERNAL = "EXTERNAL";
    public static final String GSSAPI = "GSSAPI";
    public static final String PLAIN = "PLAIN";
    protected XMPPConnection connection;
    protected ConnectionConfiguration connectionConfiguration;
    protected String authenticationId;
    protected EntityBareJid authorizationId;
    protected DomainBareJid serviceName;
    protected String password;
    protected String host;
    protected SSLSession sslSession;

    public final void authenticate(String username, String host, DomainBareJid serviceName, String password, EntityBareJid authzid, SSLSession sslSession) throws SmackException.SmackSaslException, SmackException.NotConnectedException, InterruptedException {
        this.authenticationId = username;
        this.host = host;
        this.serviceName = serviceName;
        this.password = password;
        this.authorizationId = authzid;
        this.sslSession = sslSession;
        assert (this.authorizationId == null || this.authzidSupported());
        this.authenticateInternal();
        this.authenticate();
    }

    protected void authenticateInternal() throws SmackException.SmackSaslException {
    }

    public void authenticate(String host, DomainBareJid serviceName, CallbackHandler cbh, EntityBareJid authzid, SSLSession sslSession) throws SmackException.SmackSaslException, SmackException.NotConnectedException, InterruptedException {
        this.host = host;
        this.serviceName = serviceName;
        this.authorizationId = authzid;
        this.sslSession = sslSession;
        assert (this.authorizationId == null || this.authzidSupported());
        this.authenticateInternal(cbh);
        this.authenticate();
    }

    protected abstract void authenticateInternal(CallbackHandler var1) throws SmackException.SmackSaslException;

    private void authenticate() throws SmackException.SmackSaslException, SmackException.NotConnectedException, InterruptedException {
        byte[] authenticationBytes = this.getAuthenticationText();
        String authenticationText = authenticationBytes != null && authenticationBytes.length > 0 ? Base64.encodeToString(authenticationBytes) : "=";
        this.connection.sendNonza(new SaslStreamElements.AuthMechanism(this.getName(), authenticationText));
    }

    protected abstract byte[] getAuthenticationText() throws SmackException.SmackSaslException;

    public final void challengeReceived(String challengeString, boolean finalChallenge) throws SmackException.SmackSaslException, InterruptedException, SmackException.NotConnectedException {
        byte[] challenge = Base64.decode(challengeString != null && challengeString.equals("=") ? "" : challengeString);
        byte[] response = this.evaluateChallenge(challenge);
        if (finalChallenge) {
            return;
        }
        SaslStreamElements.Response responseStanza = response == null ? new SaslStreamElements.Response() : new SaslStreamElements.Response(Base64.encodeToString(response));
        this.connection.sendNonza(responseStanza);
    }

    protected byte[] evaluateChallenge(byte[] challenge) throws SmackException.SmackSaslException {
        return null;
    }

    @Override
    public final int compareTo(SASLMechanism other) {
        Integer ourPriority = this.getPriority();
        return ourPriority.compareTo(other.getPriority());
    }

    public abstract String getName();

    public abstract int getPriority();

    public abstract void checkIfSuccessfulOrThrow() throws SmackException.SmackSaslException;

    public SASLMechanism instanceForAuthentication(XMPPConnection connection, ConnectionConfiguration connectionConfiguration) {
        SASLMechanism saslMechansim = this.newInstance();
        saslMechansim.connection = connection;
        saslMechansim.connectionConfiguration = connectionConfiguration;
        return saslMechansim;
    }

    public boolean authzidSupported() {
        return false;
    }

    protected abstract SASLMechanism newInstance();

    protected static byte[] toBytes(String string) {
        return StringUtils.toUtf8Bytes(string);
    }

    protected static String saslPrep(String string) {
        return Normalizer.normalize(string, Normalizer.Form.NFKC);
    }

    public final String toString() {
        return "SASL Mech: " + this.getName() + ", Prio: " + this.getPriority();
    }
}

