/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class CollectionUtil {
    public static <T> Collection<T> requireNotEmpty(Collection<T> collection, String collectionName) {
        if (collection == null) {
            throw new NullPointerException(collectionName + " must not be null.");
        }
        if (collection.isEmpty()) {
            throw new IllegalArgumentException(collectionName + " must not be empty.");
        }
        return collection;
    }

    public static <T, C extends Collection<T>> List<T> removeUntil(C collection, Predicate<T> predicate) {
        T t;
        ArrayList<T> removedElements = new ArrayList<T>(collection.size());
        Iterator<T> it = collection.iterator();
        while (it.hasNext() && !predicate.test(t = it.next())) {
            removedElements.add(t);
            it.remove();
        }
        return removedElements;
    }

    public static <T> ArrayList<T> newListWith(Collection<? extends T> collection) {
        ArrayList<T> arrayList = new ArrayList<T>(collection.size());
        arrayList.addAll(collection);
        return arrayList;
    }

    public static interface Predicate<T> {
        public boolean test(T var1);
    }
}

