/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

public final class EqualsUtil {
    private EqualsUtil() {
    }

    public static <T> boolean equals(T thisObject, Object other, EqualsComperator<T> equalsComperator) {
        if (other == null) {
            return false;
        }
        if (thisObject == other) {
            return true;
        }
        Class<?> thisObjectClass = thisObject.getClass();
        if (thisObjectClass != other.getClass()) {
            return false;
        }
        Builder equalsBuilder = new Builder();
        equalsComperator.compare(equalsBuilder, thisObjectClass.cast(other));
        return equalsBuilder.isEquals;
    }

    public static final class Builder {
        private boolean isEquals = true;

        private Builder() {
        }

        private void nullSafeCompare(Object left, Object right, Runnable runnable) {
            if (!this.isEquals) {
                return;
            }
            if (left == right) {
                return;
            }
            if (left == null || right == null) {
                this.isEquals = false;
                return;
            }
            runnable.run();
        }

        public <O> Builder append(O left, O right) {
            if (!this.isEquals) {
                return this;
            }
            if (left == right) {
                return this;
            }
            if (left == null || right == null) {
                this.isEquals = false;
                return this;
            }
            this.isEquals = left.equals(right);
            return this;
        }

        public Builder append(boolean left, boolean right) {
            if (!this.isEquals) {
                return this;
            }
            this.isEquals = left == right;
            return this;
        }

        public Builder append(boolean[] left, boolean[] right) {
            this.nullSafeCompare(left, right, () -> {
                if (left.length != right.length) {
                    this.isEquals = false;
                    return;
                }
                for (int i = 0; i < left.length && this.isEquals; ++i) {
                    this.append(left[i], right[i]);
                }
            });
            return this;
        }

        public Builder append(byte left, byte right) {
            if (!this.isEquals) {
                return this;
            }
            this.isEquals = left == right;
            return this;
        }

        public Builder append(byte[] left, byte[] right) {
            this.nullSafeCompare(left, right, () -> {
                if (left.length != right.length) {
                    this.isEquals = false;
                    return;
                }
                for (int i = 0; i < left.length && this.isEquals; ++i) {
                    this.append(left[i], right[i]);
                }
            });
            return this;
        }

        public Builder append(char left, char right) {
            if (!this.isEquals) {
                return this;
            }
            this.isEquals = left == right;
            return this;
        }

        public Builder append(char[] left, char[] right) {
            this.nullSafeCompare(left, right, () -> {
                if (left.length != right.length) {
                    this.isEquals = false;
                    return;
                }
                for (int i = 0; i < left.length && this.isEquals; ++i) {
                    this.append(left[i], right[i]);
                }
            });
            return this;
        }

        public Builder append(double left, double right) {
            if (!this.isEquals) {
                return this;
            }
            return this.append(Double.doubleToLongBits(left), Double.doubleToLongBits(right));
        }

        public Builder append(double[] left, double[] right) {
            this.nullSafeCompare(left, right, () -> {
                if (left.length != right.length) {
                    this.isEquals = false;
                    return;
                }
                for (int i = 0; i < left.length && this.isEquals; ++i) {
                    this.append(left[i], right[i]);
                }
            });
            return this;
        }

        public Builder append(float left, float right) {
            if (!this.isEquals) {
                return this;
            }
            return this.append(Float.floatToIntBits(left), Float.floatToIntBits(right));
        }

        public Builder append(float[] left, float[] right) {
            this.nullSafeCompare(left, right, () -> {
                if (left.length != right.length) {
                    this.isEquals = false;
                    return;
                }
                for (int i = 0; i < left.length && this.isEquals; ++i) {
                    this.append(left[i], right[i]);
                }
            });
            return this;
        }

        public Builder append(int left, int right) {
            if (!this.isEquals) {
                return this;
            }
            this.isEquals = left == right;
            return this;
        }

        public Builder append(int[] left, int[] right) {
            this.nullSafeCompare(left, right, () -> {
                if (left.length != right.length) {
                    this.isEquals = false;
                    return;
                }
                for (int i = 0; i < left.length && this.isEquals; ++i) {
                    this.append(left[i], right[i]);
                }
            });
            return this;
        }

        public Builder append(long left, long right) {
            if (!this.isEquals) {
                return this;
            }
            this.isEquals = left == right;
            return this;
        }

        public Builder append(long[] left, long[] right) {
            this.nullSafeCompare(left, right, () -> {
                if (left.length != right.length) {
                    this.isEquals = false;
                    return;
                }
                for (int i = 0; i < left.length && this.isEquals; ++i) {
                    this.append(left[i], right[i]);
                }
            });
            return this;
        }
    }

    @FunctionalInterface
    public static interface EqualsComperator<T> {
        public void compare(Builder var1, T var2);
    }
}

