/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.packet.FullyQualifiedElement;

public class XmppElementUtil {
    public static final Logger LOGGER = Logger.getLogger(XmppElementUtil.class.getName());

    public static QName getQNameFor(Class<? extends FullyQualifiedElement> fullyQualifiedElement) {
        String namespace;
        String element;
        try {
            Object qnameObject = fullyQualifiedElement.getField("QNAME").get(null);
            if (QName.class.isAssignableFrom(qnameObject.getClass())) {
                return (QName)qnameObject;
            }
            LOGGER.warning("The QNAME field of " + fullyQualifiedElement + " is not of type QNAME.");
        }
        catch (NoSuchFieldException e) {
            LOGGER.finer("The class " + fullyQualifiedElement + " has no static QNAME field. Consider adding one.");
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
            throw new IllegalArgumentException(e);
        }
        try {
            element = (String)fullyQualifiedElement.getField("ELEMENT").get(null);
            namespace = (String)fullyQualifiedElement.getField("NAMESPACE").get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new IllegalArgumentException(e);
        }
        return new QName(namespace, element);
    }
}

