/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import org.jivesoftware.smack.util.SHA1;
import org.junit.Assert;
import org.junit.Test;

public class SHA1Test {
    private final String HASH_CHARS = "0123456789abcdef";

    @Test
    public void testHash() {
        try {
            SHA1.hex((String)null);
            Assert.fail();
        }
        catch (NullPointerException npe) {
            Assert.assertTrue((boolean)true);
        }
        String result = SHA1.hex((String)"");
        Assert.assertEquals((Object)"da39a3ee5e6b4b0d3255bfef95601890afd80709", (Object)result);
        String adminInHash = "d033e22ae348aeb5660fc2140aec35850c4da997";
        result = SHA1.hex((String)"admin");
        Assert.assertEquals((Object)adminInHash, (Object)result);
        String random = "jive software blah and stuff this is pretty cool";
        result = SHA1.hex((String)random);
        Assert.assertTrue((boolean)this.isValidHash(result));
        String junk = "\n\n\t\b\r!@(!)^(#)@+_-\u2031\u09291\u00a9\u00bd\u0394\u00f8";
        result = SHA1.hex((String)junk);
        Assert.assertTrue((boolean)this.isValidHash(result));
    }

    private boolean isValidHash(String result) {
        boolean valid = true;
        for (int i = 0; i < result.length(); ++i) {
            char c = result.charAt(i);
            if ("0123456789abcdef".indexOf(c) >= 0) continue;
            valid = false;
        }
        return valid;
    }
}

