/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.MessageBuilder;
import org.jivesoftware.smack.packet.StanzaBuilder;
import org.jivesoftware.smack.test.util.XmlAssertUtil;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.SAXException;

public class MessageTest {
    @Test
    public void setMessageTypeTest() throws IOException, SAXException {
        Message.Type type = Message.Type.chat;
        Message.Type type2 = Message.Type.headline;
        StringBuilder controlBuilder = new StringBuilder();
        controlBuilder.append("<message").append(" type=\"").append(type).append("\">").append("</message>");
        String control = controlBuilder.toString();
        Message messageBuildWithBuilder = StanzaBuilder.buildMessage().ofType(Message.Type.chat).build();
        Assert.assertEquals((Object)type, (Object)messageBuildWithBuilder.getType());
        XmlAssertUtil.assertXmlSimilar((CharSequence)control, (CharSequence)messageBuildWithBuilder.toXML("jabber:client").toString());
        controlBuilder = new StringBuilder();
        controlBuilder.append("<message").append(" type=\"").append(type2).append("\">").append("</message>");
        control = controlBuilder.toString();
        Message messageTypeSet = StanzaBuilder.buildMessage().ofType(type2).build();
        Assert.assertEquals((Object)type2, (Object)messageTypeSet.getType());
        XmlAssertUtil.assertXmlSimilar((CharSequence)control, (CharSequence)messageTypeSet.toXML("jabber:client").toString());
    }

    @Test(expected=NullPointerException.class)
    public void setNullMessageBodyTest() {
        StanzaBuilder.buildMessage().addBody(null, null).build();
    }

    @Test
    public void setMessageSubjectTest() throws IOException, SAXException {
        String messageSubject = "This is a test of the emergency broadcast system.";
        StringBuilder controlBuilder = new StringBuilder();
        controlBuilder.append("<message>").append("<subject>").append("This is a test of the emergency broadcast system.").append("</subject>").append("</message>");
        String control = controlBuilder.toString();
        Message message = StanzaBuilder.buildMessage().setSubject("This is a test of the emergency broadcast system.").build();
        Assert.assertEquals((Object)"This is a test of the emergency broadcast system.", (Object)message.getSubject());
        XmlAssertUtil.assertXmlSimilar((CharSequence)control, (CharSequence)message.toXML("jabber:client").toString());
    }

    @Test
    public void oneMessageBodyTest() throws IOException, SAXException {
        String messageBody = "This is a test of the emergency broadcast system.";
        StringBuilder controlBuilder = new StringBuilder();
        controlBuilder.append("<message>").append("<body>").append("This is a test of the emergency broadcast system.").append("</body>").append("</message>");
        String control = controlBuilder.toString();
        Message message = StanzaBuilder.buildMessage().setBody("This is a test of the emergency broadcast system.").build();
        Assert.assertEquals((Object)"This is a test of the emergency broadcast system.", (Object)message.getBody());
        XmlAssertUtil.assertXmlSimilar((CharSequence)control, (CharSequence)message.toXML("jabber:client").toString());
    }

    @Test
    public void multipleMessageBodiesTest() throws IOException, SAXException {
        String messageBody1 = "This is a test of the emergency broadcast system, 1.";
        String lang2 = "ru";
        String messageBody2 = "This is a test of the emergency broadcast system, 2.";
        String lang3 = "sp";
        String messageBody3 = "This is a test of the emergency broadcast system, 3.";
        StringBuilder controlBuilder = new StringBuilder();
        controlBuilder.append("<message>").append("<body>").append("This is a test of the emergency broadcast system, 1.").append("</body>").append("<body xml:lang=\"").append("ru").append("\">").append("This is a test of the emergency broadcast system, 2.").append("</body>").append("<body xml:lang=\"").append("sp").append("\">").append("This is a test of the emergency broadcast system, 3.").append("</body>").append("</message>");
        String control = controlBuilder.toString();
        Message message = StanzaBuilder.buildMessage().addBody(null, "This is a test of the emergency broadcast system, 1.").addBody("ru", "This is a test of the emergency broadcast system, 2.").addBody("sp", "This is a test of the emergency broadcast system, 3.").build();
        XmlAssertUtil.assertXmlSimilar((CharSequence)control, (CharSequence)message.toXML("jabber:client"));
        List languages = message.getBodyLanguages();
        ArrayList<String> controlLanguages = new ArrayList<String>();
        controlLanguages.add("ru");
        controlLanguages.add("sp");
        controlLanguages.removeAll(languages);
        Assert.assertTrue((controlLanguages.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void simpleMessageBodyTest() {
        Message message = StanzaBuilder.buildMessage().setBody("test").build();
        Assert.assertTrue((message.getBodies().size() == 1 ? 1 : 0) != 0);
        message = StanzaBuilder.buildMessage().build();
        Assert.assertTrue((message.getBodies().size() == 0 ? 1 : 0) != 0);
        message = StanzaBuilder.buildMessage().addBody("es", "test").build();
        Assert.assertTrue((message.getBodies().size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void setMessageThreadTest() throws IOException, SAXException {
        String messageThread = "1234";
        StringBuilder controlBuilder = new StringBuilder();
        controlBuilder.append("<message>").append("<thread>").append("1234").append("</thread>").append("</message>");
        String control = controlBuilder.toString();
        Message message = StanzaBuilder.buildMessage().setThread("1234").build();
        Assert.assertEquals((Object)"1234", (Object)message.getThread());
        XmlAssertUtil.assertXmlSimilar((CharSequence)control, (CharSequence)message.toXML("jabber:client").toString());
    }

    @Test
    public void messageXmlLangTest() throws IOException, SAXException {
        String lang = "sp";
        StringBuilder controlBuilder = new StringBuilder();
        controlBuilder.append("<message").append(" xml:lang=\"").append("sp").append("\">").append("</message>");
        String control = controlBuilder.toString();
        Message message = ((MessageBuilder)StanzaBuilder.buildMessage().setLanguage("sp")).build();
        XmlAssertUtil.assertXmlSimilar((CharSequence)control, (CharSequence)message.toXML("jabber:client").toString());
    }
}

