/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLSession;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.AsyncButOrdered;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.NonzaCallback;
import org.jivesoftware.smack.SASLAuthentication;
import org.jivesoftware.smack.ScheduledAction;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.SmackFuture;
import org.jivesoftware.smack.SmackReactor;
import org.jivesoftware.smack.StanzaCollector;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.UnparseableStanza;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.compression.XMPPInputOutputStream;
import org.jivesoftware.smack.datatypes.UInt16;
import org.jivesoftware.smack.debugger.SmackDebugger;
import org.jivesoftware.smack.debugger.SmackDebuggerFactory;
import org.jivesoftware.smack.filter.IQReplyFilter;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.filter.StanzaIdFilter;
import org.jivesoftware.smack.internal.SmackTlsContext;
import org.jivesoftware.smack.iqrequest.IQRequestHandler;
import org.jivesoftware.smack.packet.Bind;
import org.jivesoftware.smack.packet.ErrorIQ;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.FullyQualifiedElement;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Mechanisms;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.MessageBuilder;
import org.jivesoftware.smack.packet.MessageOrPresence;
import org.jivesoftware.smack.packet.MessageOrPresenceBuilder;
import org.jivesoftware.smack.packet.Nonza;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.PresenceBuilder;
import org.jivesoftware.smack.packet.Session;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.packet.StanzaFactory;
import org.jivesoftware.smack.packet.StreamError;
import org.jivesoftware.smack.packet.StreamOpen;
import org.jivesoftware.smack.packet.TopLevelStreamElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.packet.id.StanzaIdSource;
import org.jivesoftware.smack.parsing.ParsingExceptionCallback;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.provider.NonzaProvider;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.sasl.SASLErrorException;
import org.jivesoftware.smack.sasl.SASLMechanism;
import org.jivesoftware.smack.sasl.packet.SaslNonza;
import org.jivesoftware.smack.util.Async;
import org.jivesoftware.smack.util.CollectionUtil;
import org.jivesoftware.smack.util.Consumer;
import org.jivesoftware.smack.util.MultiMap;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smack.util.Predicate;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.Supplier;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.jid.parts.Resourcepart;
import org.jxmpp.stringprep.XmppStringprepException;
import org.jxmpp.util.XmppStringUtils;

public abstract class AbstractXMPPConnection
implements XMPPConnection {
    private static final Logger LOGGER = Logger.getLogger(AbstractXMPPConnection.class.getName());
    protected static final SmackReactor SMACK_REACTOR = SmackReactor.getInstance();
    private static final AtomicInteger connectionCounter = new AtomicInteger(0);
    protected final Set<ConnectionListener> connectionListeners = new CopyOnWriteArraySet<ConnectionListener>();
    private final Collection<StanzaCollector> collectors = new ConcurrentLinkedQueue<StanzaCollector>();
    private final Map<StanzaListener, ListenerWrapper> recvListeners = new LinkedHashMap<StanzaListener, ListenerWrapper>();
    private final Map<StanzaListener, ListenerWrapper> syncRecvListeners = new LinkedHashMap<StanzaListener, ListenerWrapper>();
    private final Map<StanzaListener, ListenerWrapper> asyncRecvListeners = new LinkedHashMap<StanzaListener, ListenerWrapper>();
    private final Map<StanzaListener, ListenerWrapper> sendListeners = new HashMap<StanzaListener, ListenerWrapper>();
    private final Map<StanzaListener, InterceptorWrapper> interceptors = new HashMap<StanzaListener, InterceptorWrapper>();
    private final Map<Consumer<MessageBuilder>, GenericInterceptorWrapper<MessageBuilder, Message>> messageInterceptors = new HashMap<Consumer<MessageBuilder>, GenericInterceptorWrapper<MessageBuilder, Message>>();
    private final Map<Consumer<PresenceBuilder>, GenericInterceptorWrapper<PresenceBuilder, Presence>> presenceInterceptors = new HashMap<Consumer<PresenceBuilder>, GenericInterceptorWrapper<PresenceBuilder, Presence>>();
    private XmlEnvironment incomingStreamXmlEnvironment;
    protected XmlEnvironment outgoingStreamXmlEnvironment;
    final MultiMap<QName, NonzaCallback> nonzaCallbacksMap = new MultiMap();
    protected final Lock connectionLock = new ReentrantLock();
    protected final Map<QName, FullyQualifiedElement> streamFeatures = new HashMap<QName, FullyQualifiedElement>();
    protected EntityFullJid user;
    protected boolean connected = false;
    protected String streamId;
    private long replyTimeout = SmackConfiguration.getDefaultReplyTimeout();
    protected final SmackDebugger debugger;
    protected Reader reader;
    protected Writer writer;
    protected SmackException currentSmackException;
    protected XMPPException currentXmppException;
    protected boolean tlsHandled;
    protected boolean lastFeaturesReceived;
    protected boolean saslFeatureReceived;
    protected boolean closingStreamReceived;
    private final SASLAuthentication saslAuthentication;
    protected final int connectionCounterValue = connectionCounter.getAndIncrement();
    protected final ConnectionConfiguration config;
    private XMPPConnection.FromMode fromMode = XMPPConnection.FromMode.OMITTED;
    protected XMPPInputOutputStream compressionHandler;
    private ParsingExceptionCallback parsingExceptionCallback = SmackConfiguration.getDefaultParsingExceptionCallback();
    private static final ExecutorService CACHED_EXECUTOR_SERVICE;
    protected static final AsyncButOrdered<AbstractXMPPConnection> ASYNC_BUT_ORDERED;
    protected final AsyncButOrdered<StanzaListener> inOrderListeners = new AsyncButOrdered();
    protected String host;
    protected UInt16 port;
    protected boolean authenticated = false;
    protected long authenticatedConnectionInitiallyEstablishedTimestamp;
    protected boolean wasAuthenticated = false;
    private final Map<QName, IQRequestHandler> setIqRequestHandler = new HashMap<QName, IQRequestHandler>();
    private final Map<QName, IQRequestHandler> getIqRequestHandler = new HashMap<QName, IQRequestHandler>();
    private final StanzaFactory stanzaFactory;
    private String usedUsername;
    private String usedPassword;
    private Resourcepart usedResource;
    private final Object internalMonitor = new Object();
    private DomainBareJid xmppServiceDomain;
    private final Object notifyConnectionErrorMonitor = new Object();
    private SmackConfiguration.UnknownIqRequestReplyMode unknownIqRequestReplyMode = SmackConfiguration.getUnknownIqRequestReplyMode();
    private long lastStanzaReceived;
    private final Queue<Runnable> deferredAsyncRunnables = new LinkedList<Runnable>();
    private int deferredAsyncRunnablesCount;
    private int deferredAsyncRunnablesCountPrevious;
    private int maxAsyncRunnables = SmackConfiguration.getDefaultConcurrencyLevelLimit();
    private int currentAsyncRunnables;

    protected AbstractXMPPConnection(ConnectionConfiguration configuration) {
        this.saslAuthentication = new SASLAuthentication(this, configuration);
        this.config = configuration;
        this.buildNonzaCallback().listenFor(SaslNonza.Challenge.class, c -> {
            try {
                this.saslAuthentication.challengeReceived((SaslNonza.Challenge)c);
            }
            catch (InterruptedException | SmackException e) {
                this.saslAuthentication.authenticationFailed(e);
            }
        }).listenFor(SaslNonza.Success.class, s -> {
            try {
                this.saslAuthentication.authenticated((SaslNonza.Success)s);
            }
            catch (InterruptedException | SmackException.NotConnectedException | SmackException.SmackSaslException e) {
                this.saslAuthentication.authenticationFailed(e);
            }
        }).listenFor(SaslNonza.SASLFailure.class, f -> this.saslAuthentication.authenticationFailed((SaslNonza.SASLFailure)f)).install();
        SmackDebuggerFactory debuggerFactory = configuration.getDebuggerFactory();
        this.debugger = debuggerFactory != null ? debuggerFactory.create(this) : null;
        for (ConnectionCreationListener listener : XMPPConnectionRegistry.getConnectionCreationListeners()) {
            listener.connectionCreated(this);
        }
        StanzaIdSource stanzaIdSource = configuration.constructStanzaIdSource();
        this.stanzaFactory = new StanzaFactory(stanzaIdSource);
    }

    public ConnectionConfiguration getConfiguration() {
        return this.config;
    }

    @Override
    public DomainBareJid getXMPPServiceDomain() {
        if (this.xmppServiceDomain != null) {
            return this.xmppServiceDomain;
        }
        return this.config.getXMPPServiceDomain();
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        UInt16 port = this.port;
        if (port == null) {
            return -1;
        }
        return port.intValue();
    }

    @Override
    public abstract boolean isSecureConnection();

    protected abstract void sendStanzaInternal(Stanza var1) throws SmackException.NotConnectedException, InterruptedException;

    @Override
    public boolean trySendStanza(Stanza stanza) throws SmackException.NotConnectedException {
        try {
            this.sendStanza(stanza);
        }
        catch (InterruptedException e) {
            LOGGER.log(Level.FINER, "Thread blocked in fallback implementation of trySendStanza(Stanza) was interrupted", e);
            return false;
        }
        return true;
    }

    @Override
    public boolean trySendStanza(Stanza stanza, long timeout, TimeUnit unit) throws SmackException.NotConnectedException, InterruptedException {
        this.sendStanza(stanza);
        return true;
    }

    @Override
    public abstract void sendNonza(Nonza var1) throws SmackException.NotConnectedException, InterruptedException;

    @Override
    public abstract boolean isUsingCompression();

    protected void initState() {
        this.currentSmackException = null;
        this.currentXmppException = null;
        this.tlsHandled = false;
        this.lastFeaturesReceived = false;
        this.saslFeatureReceived = false;
    }

    public synchronized AbstractXMPPConnection connect() throws SmackException, IOException, XMPPException, InterruptedException {
        this.throwAlreadyConnectedExceptionIfAppropriate();
        this.initState();
        this.closingStreamReceived = false;
        this.streamId = null;
        try {
            this.connectInternal();
            if (!this.isSecureConnection() && this.getConfiguration().getSecurityMode() == ConnectionConfiguration.SecurityMode.required) {
                throw new SmackException.SecurityRequiredByClientException();
            }
        }
        catch (IOException | InterruptedException | SmackException | XMPPException e) {
            this.instantShutdown();
            throw e;
        }
        this.connected = true;
        this.callConnectionConnectedListener();
        return this;
    }

    protected abstract void connectInternal() throws SmackException, IOException, XMPPException, InterruptedException;

    public synchronized void login() throws XMPPException, SmackException, IOException, InterruptedException {
        CharSequence username = this.usedUsername != null ? this.usedUsername : this.config.getUsername();
        String password = this.usedPassword != null ? this.usedPassword : this.config.getPassword();
        Resourcepart resource = this.usedResource != null ? this.usedResource : this.config.getResource();
        this.login(username, password, resource);
    }

    public synchronized void login(CharSequence username, String password) throws XMPPException, SmackException, IOException, InterruptedException {
        this.login(username, password, this.config.getResource());
    }

    public synchronized void login(CharSequence username, String password, Resourcepart resource) throws XMPPException, SmackException, IOException, InterruptedException {
        if (!this.config.allowNullOrEmptyUsername) {
            StringUtils.requireNotNullNorEmpty(username, "Username must not be null nor empty");
        }
        this.throwNotConnectedExceptionIfAppropriate("Did you call connect() before login()?");
        this.throwAlreadyLoggedInExceptionIfAppropriate();
        this.usedUsername = username != null ? username.toString() : null;
        this.usedPassword = password;
        this.usedResource = resource;
        this.loginInternal(this.usedUsername, this.usedPassword, this.usedResource);
    }

    protected abstract void loginInternal(String var1, String var2, Resourcepart var3) throws XMPPException, SmackException, IOException, InterruptedException;

    @Override
    public final boolean isConnected() {
        return this.connected;
    }

    @Override
    public final boolean isAuthenticated() {
        return this.authenticated;
    }

    @Override
    public final EntityFullJid getUser() {
        return this.user;
    }

    @Override
    public String getStreamId() {
        if (!this.isConnected()) {
            return null;
        }
        return this.streamId;
    }

    protected final void throwCurrentConnectionException() throws SmackException, XMPPException {
        if (this.currentSmackException != null) {
            throw this.currentSmackException;
        }
        if (this.currentXmppException != null) {
            throw this.currentXmppException;
        }
        throw new AssertionError((Object)"No current connection exception set, although throwCurrentException() was called");
    }

    protected final boolean hasCurrentConnectionException() {
        return this.currentSmackException != null || this.currentXmppException != null;
    }

    protected final void setCurrentConnectionExceptionAndNotify(Exception exception) {
        if (exception instanceof SmackException) {
            this.currentSmackException = (SmackException)exception;
        } else if (exception instanceof XMPPException) {
            this.currentXmppException = (XMPPException)exception;
        } else {
            this.currentSmackException = new SmackException.SmackWrappedException(exception);
        }
        this.notifyWaitingThreads();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void notifyWaitingThreads() {
        Object object = this.internalMonitor;
        synchronized (object) {
            this.internalMonitor.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean waitForCondition(Supplier<Boolean> condition) throws InterruptedException {
        long deadline = System.currentTimeMillis() + this.getReplyTimeout();
        Object object = this.internalMonitor;
        synchronized (object) {
            while (!condition.get().booleanValue() && !this.hasCurrentConnectionException()) {
                long now = System.currentTimeMillis();
                if (now >= deadline) {
                    return false;
                }
                this.internalMonitor.wait(deadline - now);
            }
        }
        return true;
    }

    protected final void waitForCondition(Supplier<Boolean> condition, String waitFor) throws InterruptedException, SmackException.NoResponseException {
        boolean success = this.waitForCondition(condition);
        if (!success) {
            throw SmackException.NoResponseException.newWith((XMPPConnection)this, waitFor);
        }
    }

    protected final void waitForConditionOrThrowConnectionException(Supplier<Boolean> condition, String waitFor) throws InterruptedException, SmackException, XMPPException {
        this.waitForCondition(condition, waitFor);
        if (this.hasCurrentConnectionException()) {
            this.throwCurrentConnectionException();
        }
    }

    protected Resourcepart bindResourceAndEstablishSession(Resourcepart resource) throws SmackException, InterruptedException, XMPPException {
        LOGGER.finer("Waiting for last features to be received before continuing with resource binding");
        this.waitForConditionOrThrowConnectionException(() -> this.lastFeaturesReceived, "last stream features received from server");
        if (!this.hasFeature("bind", "urn:ietf:params:xml:ns:xmpp-bind")) {
            throw new SmackException.ResourceBindingNotOfferedException();
        }
        Bind bindResource = Bind.newSet(resource);
        StanzaCollector packetCollector = this.createStanzaCollectorAndSend(new StanzaIdFilter(bindResource), bindResource);
        Bind response = (Bind)packetCollector.nextResultOrThrow();
        this.user = response.getJid();
        this.xmppServiceDomain = this.user.asDomainBareJid();
        Session.Feature sessionFeature = (Session.Feature)this.getFeature("session", "urn:ietf:params:xml:ns:xmpp-session");
        if (sessionFeature != null && !sessionFeature.isOptional()) {
            Session session = new Session();
            packetCollector = this.createStanzaCollectorAndSend(new StanzaIdFilter(session), session);
            packetCollector.nextResultOrThrow();
        }
        return response.getJid().getResourcepart();
    }

    protected void afterSuccessfulLogin(boolean resumed) throws SmackException.NotConnectedException, InterruptedException {
        if (!resumed) {
            this.authenticatedConnectionInitiallyEstablishedTimestamp = System.currentTimeMillis();
        }
        this.authenticated = true;
        if (this.debugger != null) {
            this.debugger.userHasLogged(this.user);
        }
        this.callConnectionAuthenticatedListener(resumed);
        if (this.config.isSendPresence() && !resumed) {
            Presence availablePresence = this.getStanzaFactory().buildPresenceStanza().ofType(Presence.Type.available).build();
            this.sendStanza(availablePresence);
        }
    }

    @Override
    public final boolean isAnonymous() {
        return this.isAuthenticated() && "ANONYMOUS".equals(this.getUsedSaslMechansism());
    }

    public final String getUsedSaslMechansism() {
        return this.saslAuthentication.getNameOfLastUsedSaslMechansism();
    }

    protected Lock getConnectionLock() {
        return this.connectionLock;
    }

    protected void throwNotConnectedExceptionIfAppropriate() throws SmackException.NotConnectedException {
        this.throwNotConnectedExceptionIfAppropriate(null);
    }

    protected void throwNotConnectedExceptionIfAppropriate(String optionalHint) throws SmackException.NotConnectedException {
        if (!this.isConnected()) {
            throw new SmackException.NotConnectedException(optionalHint);
        }
    }

    protected void throwAlreadyConnectedExceptionIfAppropriate() throws SmackException.AlreadyConnectedException {
        if (this.isConnected()) {
            throw new SmackException.AlreadyConnectedException();
        }
    }

    protected void throwAlreadyLoggedInExceptionIfAppropriate() throws SmackException.AlreadyLoggedInException {
        if (this.isAuthenticated()) {
            throw new SmackException.AlreadyLoggedInException();
        }
    }

    @Override
    public final StanzaFactory getStanzaFactory() {
        return this.stanzaFactory;
    }

    @Override
    public final void sendStanza(Stanza stanza) throws SmackException.NotConnectedException, InterruptedException {
        Objects.requireNonNull(stanza, "Stanza must not be null");
        assert (stanza instanceof Message || stanza instanceof Presence || stanza instanceof IQ);
        this.throwNotConnectedExceptionIfAppropriate();
        switch (this.fromMode) {
            case OMITTED: {
                stanza.setFrom(null);
                break;
            }
            case USER: {
                stanza.setFrom((Jid)this.getUser());
                break;
            }
        }
        Stanza stanzaAfterInterceptors = this.firePacketInterceptors(stanza);
        this.sendStanzaInternal(stanzaAfterInterceptors);
    }

    protected final SASLMechanism authenticate(String username, String password, EntityBareJid authzid, SSLSession sslSession) throws XMPPException.XMPPErrorException, SASLErrorException, SmackException.SmackSaslException, SmackException.NotConnectedException, SmackException.NoResponseException, IOException, InterruptedException, SmackException.SmackWrappedException {
        SASLMechanism saslMechanism = this.saslAuthentication.authenticate(username, password, authzid, sslSession);
        this.afterSaslAuthenticationSuccess();
        return saslMechanism;
    }

    protected void afterSaslAuthenticationSuccess() throws SmackException.NotConnectedException, InterruptedException, SmackException.SmackWrappedException {
        this.sendStreamOpen();
    }

    protected final boolean isSaslAuthenticated() {
        return this.saslAuthentication.authenticationSuccessful();
    }

    public void disconnect() {
        Presence unavailablePresence = null;
        if (this.isAuthenticated()) {
            unavailablePresence = this.getStanzaFactory().buildPresenceStanza().ofType(Presence.Type.unavailable).build();
        }
        try {
            this.disconnect(unavailablePresence);
        }
        catch (SmackException.NotConnectedException e) {
            LOGGER.log(Level.FINEST, "Connection is already disconnected", e);
        }
    }

    public synchronized void disconnect(Presence unavailablePresence) throws SmackException.NotConnectedException {
        if (unavailablePresence != null) {
            try {
                this.sendStanza(unavailablePresence);
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.FINE, "Was interrupted while sending unavailable presence. Continuing to disconnect the connection", e);
            }
        }
        this.shutdown();
        this.callConnectionClosedListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void notifyConnectionError(Exception exception) {
        Object object = this.notifyConnectionErrorMonitor;
        synchronized (object) {
            if (!this.isConnected()) {
                LOGGER.log(Level.INFO, "Connection was already disconnected when attempting to handle " + exception, exception);
                return;
            }
            this.setCurrentConnectionExceptionAndNotify(exception);
            this.instantShutdown();
            for (StanzaCollector collector : this.collectors) {
                collector.notifyConnectionError(exception);
            }
            Async.go(() -> this.callConnectionClosedOnErrorListener(exception), this + " callConnectionClosedOnErrorListener()");
        }
    }

    public abstract void instantShutdown();

    protected abstract void shutdown();

    protected final boolean waitForClosingStreamTagFromServer() {
        try {
            this.waitForConditionOrThrowConnectionException(() -> this.closingStreamReceived, "closing stream tag from the server");
        }
        catch (InterruptedException | SmackException | XMPPException e) {
            LOGGER.log(Level.INFO, "Exception while waiting for closing stream element from the server " + this, e);
            return false;
        }
        return true;
    }

    @Override
    public void addConnectionListener(ConnectionListener connectionListener) {
        if (connectionListener == null) {
            return;
        }
        this.connectionListeners.add(connectionListener);
    }

    @Override
    public void removeConnectionListener(ConnectionListener connectionListener) {
        this.connectionListeners.remove(connectionListener);
    }

    @Override
    public <I extends IQ> I sendIqRequestAndWaitForResponse(IQ request) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        IQ resultResponse;
        StanzaCollector collector = this.createStanzaCollectorAndSend(request);
        IQ concreteResultResponse = resultResponse = (IQ)collector.nextResultOrThrow();
        return (I)concreteResultResponse;
    }

    @Override
    public StanzaCollector createStanzaCollectorAndSend(IQ packet) throws SmackException.NotConnectedException, InterruptedException {
        IQReplyFilter packetFilter = new IQReplyFilter(packet, this);
        StanzaCollector packetCollector = this.createStanzaCollectorAndSend(packetFilter, packet);
        return packetCollector;
    }

    @Override
    public StanzaCollector createStanzaCollectorAndSend(StanzaFilter packetFilter, Stanza packet) throws SmackException.NotConnectedException, InterruptedException {
        StanzaCollector.Configuration configuration = StanzaCollector.newConfiguration().setStanzaFilter(packetFilter).setRequest(packet);
        StanzaCollector packetCollector = this.createStanzaCollector(configuration);
        try {
            this.sendStanza(packet);
        }
        catch (InterruptedException | RuntimeException | SmackException.NotConnectedException e) {
            packetCollector.cancel();
            throw e;
        }
        return packetCollector;
    }

    @Override
    public StanzaCollector createStanzaCollector(StanzaFilter packetFilter) {
        StanzaCollector.Configuration configuration = StanzaCollector.newConfiguration().setStanzaFilter(packetFilter);
        return this.createStanzaCollector(configuration);
    }

    @Override
    public StanzaCollector createStanzaCollector(StanzaCollector.Configuration configuration) {
        StanzaCollector collector = new StanzaCollector(this, configuration);
        this.collectors.add(collector);
        return collector;
    }

    @Override
    public void removeStanzaCollector(StanzaCollector collector) {
        this.collectors.remove(collector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addStanzaListener(StanzaListener stanzaListener, StanzaFilter stanzaFilter) {
        if (stanzaListener == null) {
            throw new NullPointerException("Given stanza listener must not be null");
        }
        ListenerWrapper wrapper = new ListenerWrapper(stanzaListener, stanzaFilter);
        Map<StanzaListener, ListenerWrapper> map = this.recvListeners;
        synchronized (map) {
            this.recvListeners.put(stanzaListener, wrapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean removeStanzaListener(StanzaListener stanzaListener) {
        Map<StanzaListener, ListenerWrapper> map = this.recvListeners;
        synchronized (map) {
            return this.recvListeners.remove(stanzaListener) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSyncStanzaListener(StanzaListener packetListener, StanzaFilter packetFilter) {
        if (packetListener == null) {
            throw new NullPointerException("Packet listener is null.");
        }
        ListenerWrapper wrapper = new ListenerWrapper(packetListener, packetFilter);
        Map<StanzaListener, ListenerWrapper> map = this.syncRecvListeners;
        synchronized (map) {
            this.syncRecvListeners.put(packetListener, wrapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeSyncStanzaListener(StanzaListener packetListener) {
        Map<StanzaListener, ListenerWrapper> map = this.syncRecvListeners;
        synchronized (map) {
            return this.syncRecvListeners.remove(packetListener) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAsyncStanzaListener(StanzaListener packetListener, StanzaFilter packetFilter) {
        if (packetListener == null) {
            throw new NullPointerException("Packet listener is null.");
        }
        ListenerWrapper wrapper = new ListenerWrapper(packetListener, packetFilter);
        Map<StanzaListener, ListenerWrapper> map = this.asyncRecvListeners;
        synchronized (map) {
            this.asyncRecvListeners.put(packetListener, wrapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAsyncStanzaListener(StanzaListener packetListener) {
        Map<StanzaListener, ListenerWrapper> map = this.asyncRecvListeners;
        synchronized (map) {
            return this.asyncRecvListeners.remove(packetListener) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addStanzaSendingListener(StanzaListener packetListener, StanzaFilter packetFilter) {
        if (packetListener == null) {
            throw new NullPointerException("Packet listener is null.");
        }
        ListenerWrapper wrapper = new ListenerWrapper(packetListener, packetFilter);
        Map<StanzaListener, ListenerWrapper> map = this.sendListeners;
        synchronized (map) {
            this.sendListeners.put(packetListener, wrapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeStanzaSendingListener(StanzaListener packetListener) {
        Map<StanzaListener, ListenerWrapper> map = this.sendListeners;
        synchronized (map) {
            this.sendListeners.remove(packetListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void firePacketSendingListeners(TopLevelStreamElement sendTopLevelStreamElement) {
        if (this.debugger != null) {
            this.debugger.onOutgoingStreamElement(sendTopLevelStreamElement);
        }
        if (!(sendTopLevelStreamElement instanceof Stanza)) {
            return;
        }
        final Stanza packet = (Stanza)sendTopLevelStreamElement;
        final LinkedList<StanzaListener> listenersToNotify = new LinkedList<StanzaListener>();
        Map<StanzaListener, ListenerWrapper> map = this.sendListeners;
        synchronized (map) {
            for (ListenerWrapper listenerWrapper : this.sendListeners.values()) {
                if (!listenerWrapper.filterMatches(packet)) continue;
                listenersToNotify.add(listenerWrapper.getListener());
            }
        }
        if (listenersToNotify.isEmpty()) {
            return;
        }
        AbstractXMPPConnection.asyncGo(new Runnable(){

            @Override
            public void run() {
                for (StanzaListener listener : listenersToNotify) {
                    try {
                        listener.processStanza(packet);
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.WARNING, "Sending listener threw exception", e);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void addStanzaInterceptor(StanzaListener packetInterceptor, StanzaFilter packetFilter) {
        if (packetInterceptor == null) {
            throw new NullPointerException("Packet interceptor is null.");
        }
        InterceptorWrapper interceptorWrapper = new InterceptorWrapper(packetInterceptor, packetFilter);
        Map<StanzaListener, InterceptorWrapper> map = this.interceptors;
        synchronized (map) {
            this.interceptors.put(packetInterceptor, interceptorWrapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void removeStanzaInterceptor(StanzaListener packetInterceptor) {
        Map<StanzaListener, InterceptorWrapper> map = this.interceptors;
        synchronized (map) {
            this.interceptors.remove(packetInterceptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <MPB extends MessageOrPresenceBuilder<MP, MPB>, MP extends MessageOrPresence<MPB>> void addInterceptor(Map<Consumer<MPB>, GenericInterceptorWrapper<MPB, MP>> interceptors, Consumer<MPB> interceptor, Predicate<MP> filter) {
        Objects.requireNonNull(interceptor, "Interceptor must not be null");
        GenericInterceptorWrapper interceptorWrapper = new GenericInterceptorWrapper(interceptor, filter);
        Map<Consumer<MPB>, GenericInterceptorWrapper<MPB, MP>> map = interceptors;
        synchronized (map) {
            interceptors.put(interceptor, interceptorWrapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <MPB extends MessageOrPresenceBuilder<MP, MPB>, MP extends MessageOrPresence<MPB>> void removeInterceptor(Map<Consumer<MPB>, GenericInterceptorWrapper<MPB, MP>> interceptors, Consumer<MPB> interceptor) {
        Map<Consumer<MPB>, GenericInterceptorWrapper<MPB, MP>> map = interceptors;
        synchronized (map) {
            interceptors.remove(interceptor);
        }
    }

    @Override
    public void addMessageInterceptor(Consumer<MessageBuilder> messageInterceptor, Predicate<Message> messageFilter) {
        AbstractXMPPConnection.addInterceptor(this.messageInterceptors, messageInterceptor, messageFilter);
    }

    @Override
    public void removeMessageInterceptor(Consumer<MessageBuilder> messageInterceptor) {
        AbstractXMPPConnection.removeInterceptor(this.messageInterceptors, messageInterceptor);
    }

    @Override
    public void addPresenceInterceptor(Consumer<PresenceBuilder> presenceInterceptor, Predicate<Presence> presenceFilter) {
        AbstractXMPPConnection.addInterceptor(this.presenceInterceptors, presenceInterceptor, presenceFilter);
    }

    @Override
    public void removePresenceInterceptor(Consumer<PresenceBuilder> presenceInterceptor) {
        AbstractXMPPConnection.removeInterceptor(this.presenceInterceptors, presenceInterceptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <MPB extends MessageOrPresenceBuilder<MP, MPB>, MP extends MessageOrPresence<MPB>> MP fireMessageOrPresenceInterceptors(MP messageOrPresence, Map<Consumer<MPB>, GenericInterceptorWrapper<MPB, MP>> interceptors) {
        LinkedList<Consumer<MPB>> interceptorsToInvoke = new LinkedList<Consumer<MPB>>();
        Map<Consumer<MPB>, GenericInterceptorWrapper<MPB, MP>> map = interceptors;
        synchronized (map) {
            for (GenericInterceptorWrapper<MPB, MP> genericInterceptorWrapper : interceptors.values()) {
                if (!((GenericInterceptorWrapper)genericInterceptorWrapper).filterMatches(messageOrPresence)) continue;
                Consumer<MPB> interceptor = genericInterceptorWrapper.getInterceptor();
                interceptorsToInvoke.add(interceptor);
            }
        }
        if (interceptorsToInvoke.isEmpty()) {
            return messageOrPresence;
        }
        MPB builder = messageOrPresence.asBuilder();
        for (Consumer consumer : interceptorsToInvoke) {
            consumer.accept(builder);
        }
        messageOrPresence = ((MessageOrPresenceBuilder)builder).build();
        return messageOrPresence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Stanza firePacketInterceptors(Stanza packet) {
        Stanza stanzaAfterInterceptors;
        LinkedList<StanzaListener> interceptorsToInvoke = new LinkedList<StanzaListener>();
        Map<StanzaListener, InterceptorWrapper> map = this.interceptors;
        synchronized (map) {
            for (InterceptorWrapper interceptorWrapper : this.interceptors.values()) {
                if (!interceptorWrapper.filterMatches(packet)) continue;
                interceptorsToInvoke.add(interceptorWrapper.getInterceptor());
            }
        }
        for (StanzaListener interceptor : interceptorsToInvoke) {
            try {
                interceptor.processStanza(packet);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Packet interceptor threw exception", e);
            }
        }
        if (packet instanceof Message) {
            Message message = (Message)packet;
            stanzaAfterInterceptors = AbstractXMPPConnection.fireMessageOrPresenceInterceptors(message, this.messageInterceptors);
        } else if (packet instanceof Presence) {
            Presence presence = (Presence)packet;
            stanzaAfterInterceptors = AbstractXMPPConnection.fireMessageOrPresenceInterceptors(presence, this.presenceInterceptors);
        } else {
            assert (packet instanceof IQ);
            stanzaAfterInterceptors = packet;
        }
        return stanzaAfterInterceptors;
    }

    protected void initDebugger() {
        if (this.reader == null || this.writer == null) {
            throw new NullPointerException("Reader or writer isn't initialized.");
        }
        if (this.debugger != null) {
            this.reader = this.debugger.newConnectionReader(this.reader);
            this.writer = this.debugger.newConnectionWriter(this.writer);
        }
    }

    @Override
    public long getReplyTimeout() {
        return this.replyTimeout;
    }

    @Override
    public void setReplyTimeout(long timeout) {
        if (Long.MAX_VALUE - System.currentTimeMillis() < timeout) {
            throw new IllegalArgumentException("Extremely long reply timeout");
        }
        this.replyTimeout = timeout;
    }

    public void setUnknownIqRequestReplyMode(SmackConfiguration.UnknownIqRequestReplyMode unknownIqRequestReplyMode) {
        this.unknownIqRequestReplyMode = Objects.requireNonNull(unknownIqRequestReplyMode, "Mode must not be null");
    }

    protected final NonzaCallback.Builder buildNonzaCallback() {
        return new NonzaCallback.Builder(this);
    }

    protected <SN extends Nonza, FN extends Nonza> SN sendAndWaitForResponse(Nonza nonza, Class<SN> successNonzaClass, Class<FN> failedNonzaClass) throws SmackException.NoResponseException, SmackException.NotConnectedException, InterruptedException, XMPPException.FailedNonzaException {
        NonzaCallback.Builder builder = this.buildNonzaCallback();
        SN successNonza = NonzaCallback.sendAndWaitForResponse(builder, nonza, successNonzaClass, failedNonzaClass);
        return successNonza;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void parseAndProcessNonza(XmlPullParser parser) throws IOException, XmlPullParserException, SmackParsingException {
        List<NonzaCallback> nonzaCallbacks;
        ParserUtils.assertAtStartTag(parser);
        int initialDepth = parser.getDepth();
        String element = parser.getName();
        String namespace = parser.getNamespace();
        QName key = new QName(namespace, element);
        NonzaProvider<? extends Nonza> nonzaProvider = ProviderManager.getNonzaProvider(key);
        if (nonzaProvider == null) {
            LOGGER.severe("Unknown nonza: " + key);
            ParserUtils.forwardToEndTagOfDepth(parser, initialDepth);
            return;
        }
        MultiMap<QName, NonzaCallback> multiMap = this.nonzaCallbacksMap;
        synchronized (multiMap) {
            nonzaCallbacks = this.nonzaCallbacksMap.getAll(key);
            nonzaCallbacks = CollectionUtil.newListWith(nonzaCallbacks);
        }
        if (nonzaCallbacks == null) {
            LOGGER.info("No nonza callback for " + key);
            ParserUtils.forwardToEndTagOfDepth(parser, initialDepth);
            return;
        }
        Nonza nonza = (Nonza)nonzaProvider.parse(parser, this.incomingStreamXmlEnvironment);
        for (NonzaCallback nonzaCallback : nonzaCallbacks) {
            nonzaCallback.onNonzaReceived(nonza);
        }
    }

    protected void parseAndProcessStanza(XmlPullParser parser) throws XmlPullParserException, IOException, InterruptedException {
        Stanza stanza;
        block3: {
            ParserUtils.assertAtStartTag(parser);
            int parserDepth = parser.getDepth();
            stanza = null;
            try {
                stanza = PacketParserUtils.parseStanza(parser, this.incomingStreamXmlEnvironment);
            }
            catch (IOException | IllegalArgumentException | SmackParsingException | XmlPullParserException e) {
                CharSequence content = PacketParserUtils.parseContentDepth(parser, parserDepth);
                UnparseableStanza message = new UnparseableStanza(content, (Exception)e);
                ParsingExceptionCallback callback = this.getParsingExceptionCallback();
                if (callback == null) break block3;
                callback.handleUnparsableStanza(message);
            }
        }
        ParserUtils.assertAtEndTag(parser);
        if (stanza != null) {
            this.processStanza(stanza);
        }
    }

    protected void processStanza(Stanza stanza) throws InterruptedException {
        assert (stanza != null);
        SmackDebugger debugger = this.debugger;
        if (debugger != null) {
            debugger.onIncomingStreamElement(stanza);
        }
        this.lastStanzaReceived = System.currentTimeMillis();
        this.invokeStanzaCollectorsAndNotifyRecvListeners(stanza);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invokeStanzaCollectorsAndNotifyRecvListeners(final Stanza packet) {
        IQ iq;
        if (packet instanceof IQ && (iq = (IQ)packet).isRequestIQ()) {
            IQRequestHandler iqRequestHandler;
            final IQ iqRequest = iq;
            QName key = iqRequest.getChildElementQName();
            IQ.Type type = iq.getType();
            switch (type) {
                case set: {
                    Map<QName, IQRequestHandler> map = this.setIqRequestHandler;
                    synchronized (map) {
                        iqRequestHandler = this.setIqRequestHandler.get(key);
                        break;
                    }
                }
                case get: {
                    Map<QName, IQRequestHandler> map = this.getIqRequestHandler;
                    synchronized (map) {
                        iqRequestHandler = this.getIqRequestHandler.get(key);
                        break;
                    }
                }
                default: {
                    throw new IllegalStateException("Should only encounter IQ type 'get' or 'set'");
                }
            }
            if (iqRequestHandler == null) {
                StanzaError.Condition replyCondition;
                switch (this.unknownIqRequestReplyMode) {
                    case doNotReply: {
                        return;
                    }
                    case replyFeatureNotImplemented: {
                        replyCondition = StanzaError.Condition.feature_not_implemented;
                        break;
                    }
                    case replyServiceUnavailable: {
                        replyCondition = StanzaError.Condition.service_unavailable;
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                ErrorIQ errorIQ = IQ.createErrorResponse(iq, StanzaError.getBuilder(replyCondition).build());
                AbstractXMPPConnection.asyncGo(() -> {
                    try {
                        this.sendStanza(errorIQ);
                    }
                    catch (InterruptedException | SmackException.NotConnectedException e) {
                        LOGGER.log(Level.WARNING, "Exception while sending error IQ to unkown IQ request", e);
                    }
                });
            } else {
                Executor executorService = null;
                switch (iqRequestHandler.getMode()) {
                    case sync: {
                        executorService = ASYNC_BUT_ORDERED.asExecutorFor(this);
                        break;
                    }
                    case async: {
                        executorService = this::asyncGoLimited;
                    }
                }
                final IQRequestHandler finalIqRequestHandler = iqRequestHandler;
                executorService.execute(new Runnable(){

                    @Override
                    public void run() {
                        IQ response = finalIqRequestHandler.handleIQRequest(iq);
                        if (response == null) {
                            return;
                        }
                        assert (response.isResponseIQ());
                        response.setTo(iqRequest.getFrom());
                        response.setStanzaId(iqRequest.getStanzaId());
                        try {
                            AbstractXMPPConnection.this.sendStanza(response);
                        }
                        catch (InterruptedException | SmackException.NotConnectedException e) {
                            LOGGER.log(Level.WARNING, "Exception while sending response to IQ request", e);
                        }
                    }
                });
            }
            return;
        }
        final LinkedList<StanzaListener> listenersToNotify = new LinkedList<StanzaListener>();
        AbstractXMPPConnection.extractMatchingListeners(packet, this.asyncRecvListeners, listenersToNotify);
        for (final StanzaListener listener : listenersToNotify) {
            this.asyncGoLimited(new Runnable(){

                @Override
                public void run() {
                    try {
                        listener.processStanza(packet);
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.SEVERE, "Exception in async packet listener", e);
                    }
                }
            });
        }
        for (StanzaCollector collector : this.collectors) {
            collector.processStanza(packet);
        }
        listenersToNotify.clear();
        AbstractXMPPConnection.extractMatchingListeners(packet, this.recvListeners, listenersToNotify);
        for (StanzaListener stanzaListener : listenersToNotify) {
            this.inOrderListeners.performAsyncButOrdered(stanzaListener, () -> {
                try {
                    stanzaListener.processStanza(packet);
                }
                catch (SmackException.NotConnectedException e) {
                    LOGGER.log(Level.WARNING, "Got not connected exception, aborting", e);
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "Exception in packet listener", e);
                }
            });
        }
        listenersToNotify.clear();
        AbstractXMPPConnection.extractMatchingListeners(packet, this.syncRecvListeners, listenersToNotify);
        ASYNC_BUT_ORDERED.performAsyncButOrdered(this, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Iterator it = listenersToNotify.iterator();
                Map map = AbstractXMPPConnection.this.syncRecvListeners;
                synchronized (map) {
                    while (it.hasNext()) {
                        StanzaListener stanzaListener = (StanzaListener)it.next();
                        if (AbstractXMPPConnection.this.syncRecvListeners.containsKey(stanzaListener)) continue;
                        it.remove();
                    }
                }
                for (StanzaListener listener : listenersToNotify) {
                    try {
                        listener.processStanza(packet);
                    }
                    catch (SmackException.NotConnectedException e) {
                        LOGGER.log(Level.WARNING, "Got not connected exception, aborting", e);
                        break;
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.SEVERE, "Exception in packet listener", e);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extractMatchingListeners(Stanza stanza, Map<StanzaListener, ListenerWrapper> listeners, Collection<StanzaListener> listenersToNotify) {
        Map<StanzaListener, ListenerWrapper> map = listeners;
        synchronized (map) {
            for (ListenerWrapper listenerWrapper : listeners.values()) {
                if (!listenerWrapper.filterMatches(stanza)) continue;
                listenersToNotify.add(listenerWrapper.getListener());
            }
        }
    }

    protected void setWasAuthenticated() {
        if (!this.wasAuthenticated) {
            this.wasAuthenticated = this.authenticated;
        }
    }

    protected void callConnectionConnectedListener() {
        for (ConnectionListener listener : this.connectionListeners) {
            listener.connected(this);
        }
    }

    protected void callConnectionAuthenticatedListener(boolean resumed) {
        for (ConnectionListener listener : this.connectionListeners) {
            try {
                listener.authenticated(this, resumed);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Exception in authenticated listener", e);
            }
        }
    }

    void callConnectionClosedListener() {
        for (ConnectionListener listener : this.connectionListeners) {
            try {
                listener.connectionClosed();
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error in listener while closing connection", e);
            }
        }
    }

    private void callConnectionClosedOnErrorListener(Exception e) {
        XMPPException.StreamErrorException see;
        boolean logWarning = true;
        if (e instanceof XMPPException.StreamErrorException && (see = (XMPPException.StreamErrorException)e).getStreamError().getCondition() == StreamError.Condition.not_authorized && this.wasAuthenticated) {
            logWarning = false;
            LOGGER.log(Level.FINE, "Connection closed with not-authorized stream error after it was already authenticated. The account was likely deleted/unregistered on the server");
        }
        if (logWarning) {
            LOGGER.log(Level.WARNING, "Connection " + this + " closed with error", e);
        }
        for (ConnectionListener listener : this.connectionListeners) {
            try {
                listener.connectionClosedOnError(e);
            }
            catch (Exception e2) {
                LOGGER.log(Level.SEVERE, "Error in listener while closing connection", e2);
            }
        }
    }

    @Override
    public int getConnectionCounter() {
        return this.connectionCounterValue;
    }

    @Override
    public void setFromMode(XMPPConnection.FromMode fromMode) {
        this.fromMode = fromMode;
    }

    @Override
    public XMPPConnection.FromMode getFromMode() {
        return this.fromMode;
    }

    protected final void parseFeatures(XmlPullParser parser) throws XmlPullParserException, IOException, SmackParsingException {
        this.streamFeatures.clear();
        int initialDepth = parser.getDepth();
        while (true) {
            XmlPullParser.Event eventType;
            if ((eventType = parser.next()) == XmlPullParser.Event.START_ELEMENT && parser.getDepth() == initialDepth + 1) {
                FullyQualifiedElement streamFeature = null;
                String name = parser.getName();
                String namespace = parser.getNamespace();
                switch (name) {
                    case "starttls": {
                        streamFeature = PacketParserUtils.parseStartTlsFeature(parser);
                        break;
                    }
                    case "mechanisms": {
                        streamFeature = new Mechanisms(PacketParserUtils.parseMechanisms(parser));
                        break;
                    }
                    case "bind": {
                        streamFeature = Bind.Feature.INSTANCE;
                        break;
                    }
                    case "session": {
                        streamFeature = PacketParserUtils.parseSessionFeature(parser);
                        break;
                    }
                    case "compression": {
                        streamFeature = PacketParserUtils.parseCompressionFeature(parser);
                        break;
                    }
                    default: {
                        ExtensionElementProvider<ExtensionElement> provider = ProviderManager.getStreamFeatureProvider(name, namespace);
                        if (provider == null) break;
                        streamFeature = (FullyQualifiedElement)provider.parse(parser, this.incomingStreamXmlEnvironment);
                    }
                }
                if (streamFeature == null) continue;
                this.addStreamFeature(streamFeature);
                continue;
            }
            if (eventType == XmlPullParser.Event.END_ELEMENT && parser.getDepth() == initialDepth) break;
        }
    }

    protected final void parseFeaturesAndNotify(XmlPullParser parser) throws Exception {
        this.parseFeatures(parser);
        if (this.hasFeature("mechanisms", "urn:ietf:params:xml:ns:xmpp-sasl") && (!this.hasFeature("starttls", "urn:ietf:params:xml:ns:xmpp-tls") || this.config.getSecurityMode() == ConnectionConfiguration.SecurityMode.disabled)) {
            this.saslFeatureReceived = true;
            this.tlsHandled = true;
            this.notifyWaitingThreads();
        }
        if (!(!this.hasFeature("bind", "urn:ietf:params:xml:ns:xmpp-bind") || this.hasFeature("compression", "http://jabber.org/protocol/compress") && this.config.isCompressionEnabled())) {
            this.lastFeaturesReceived = true;
            this.notifyWaitingThreads();
        }
        this.afterFeaturesReceived();
    }

    protected void afterFeaturesReceived() throws SmackException.SecurityRequiredException, SmackException.NotConnectedException, InterruptedException {
    }

    @Override
    public <F extends FullyQualifiedElement> F getFeature(String element, String namespace) {
        QName qname = new QName(namespace, element);
        return (F)this.streamFeatures.get(qname);
    }

    @Override
    public boolean hasFeature(String element, String namespace) {
        return this.getFeature(element, namespace) != null;
    }

    protected void addStreamFeature(FullyQualifiedElement feature) {
        QName key = feature.getQName();
        this.streamFeatures.put(key, feature);
    }

    @Override
    public SmackFuture<IQ, Exception> sendIqRequestAsync(IQ request) {
        return this.sendIqRequestAsync(request, this.getReplyTimeout());
    }

    @Override
    public SmackFuture<IQ, Exception> sendIqRequestAsync(IQ request, long timeout) {
        IQReplyFilter replyFilter = new IQReplyFilter(request, this);
        return this.sendAsync(request, replyFilter, timeout);
    }

    @Override
    public <S extends Stanza> SmackFuture<S, Exception> sendAsync(S stanza, StanzaFilter replyFilter) {
        return this.sendAsync(stanza, replyFilter, this.getReplyTimeout());
    }

    @Override
    public <S extends Stanza> SmackFuture<S, Exception> sendAsync(S stanza, final StanzaFilter replyFilter, long timeout) {
        Objects.requireNonNull(stanza, "stanza must not be null");
        Objects.requireNonNull(replyFilter, "replyFilter must not be null");
        final SmackFuture.InternalSmackFuture future = new SmackFuture.InternalSmackFuture();
        final StanzaListener stanzaListener = new StanzaListener(){

            @Override
            public void processStanza(Stanza stanza) throws SmackException.NotConnectedException, InterruptedException {
                boolean removed = AbstractXMPPConnection.this.removeAsyncStanzaListener(this);
                if (!removed) {
                    return;
                }
                try {
                    XMPPException.XMPPErrorException.ifHasErrorThenThrow(stanza);
                    Stanza s = stanza;
                    future.setResult(s);
                }
                catch (XMPPException.XMPPErrorException exception) {
                    future.setException(exception);
                }
            }
        };
        AbstractXMPPConnection.schedule(new Runnable(){

            @Override
            public void run() {
                boolean removed = AbstractXMPPConnection.this.removeAsyncStanzaListener(stanzaListener);
                if (!removed) {
                    return;
                }
                SmackException exception = !AbstractXMPPConnection.this.isConnected() ? new SmackException.NotConnectedException((XMPPConnection)AbstractXMPPConnection.this, replyFilter) : SmackException.NoResponseException.newWith((XMPPConnection)AbstractXMPPConnection.this, replyFilter);
                future.setException(exception);
            }
        }, timeout, TimeUnit.MILLISECONDS);
        this.addAsyncStanzaListener(stanzaListener, replyFilter);
        try {
            this.sendStanza(stanza);
        }
        catch (InterruptedException | SmackException.NotConnectedException exception) {
            future.setException(exception);
        }
        return future;
    }

    @Override
    public void addOneTimeSyncCallback(final StanzaListener callback, StanzaFilter packetFilter) {
        final StanzaListener packetListener = new StanzaListener(){

            @Override
            public void processStanza(Stanza packet) throws SmackException.NotConnectedException, InterruptedException, SmackException.NotLoggedInException {
                try {
                    callback.processStanza(packet);
                }
                finally {
                    AbstractXMPPConnection.this.removeSyncStanzaListener(this);
                }
            }
        };
        this.addSyncStanzaListener(packetListener, packetFilter);
        AbstractXMPPConnection.schedule(new Runnable(){

            @Override
            public void run() {
                AbstractXMPPConnection.this.removeSyncStanzaListener(packetListener);
            }
        }, this.getReplyTimeout(), TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IQRequestHandler registerIQRequestHandler(IQRequestHandler iqRequestHandler) {
        QName key = iqRequestHandler.getQName();
        switch (iqRequestHandler.getType()) {
            case set: {
                Map<QName, IQRequestHandler> map = this.setIqRequestHandler;
                synchronized (map) {
                    return this.setIqRequestHandler.put(key, iqRequestHandler);
                }
            }
            case get: {
                Map<QName, IQRequestHandler> map = this.getIqRequestHandler;
                synchronized (map) {
                    return this.getIqRequestHandler.put(key, iqRequestHandler);
                }
            }
        }
        throw new IllegalArgumentException("Only IQ type of 'get' and 'set' allowed");
    }

    @Override
    public final IQRequestHandler unregisterIQRequestHandler(IQRequestHandler iqRequestHandler) {
        return this.unregisterIQRequestHandler(iqRequestHandler.getElement(), iqRequestHandler.getNamespace(), iqRequestHandler.getType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IQRequestHandler unregisterIQRequestHandler(String element, String namespace, IQ.Type type) {
        QName key = new QName(namespace, element);
        switch (type) {
            case set: {
                Map<QName, IQRequestHandler> map = this.setIqRequestHandler;
                synchronized (map) {
                    return this.setIqRequestHandler.remove(key);
                }
            }
            case get: {
                Map<QName, IQRequestHandler> map = this.getIqRequestHandler;
                synchronized (map) {
                    return this.getIqRequestHandler.remove(key);
                }
            }
        }
        throw new IllegalArgumentException("Only IQ type of 'get' and 'set' allowed");
    }

    @Override
    public long getLastStanzaReceived() {
        return this.lastStanzaReceived;
    }

    public final long getAuthenticatedConnectionInitiallyEstablishedTimestamp() {
        return this.authenticatedConnectionInitiallyEstablishedTimestamp;
    }

    public void setParsingExceptionCallback(ParsingExceptionCallback callback) {
        this.parsingExceptionCallback = callback;
    }

    public ParsingExceptionCallback getParsingExceptionCallback() {
        return this.parsingExceptionCallback;
    }

    public final String toString() {
        EntityFullJid localEndpoint = this.getUser();
        String localEndpointString = localEndpoint == null ? "not-authenticated" : localEndpoint.toString();
        return this.getClass().getSimpleName() + '[' + localEndpointString + "] (" + this.getConnectionCounter() + ')';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void asyncGoLimited(final Runnable runnable) {
        Runnable wrappedRunnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                runnable.run();
                Queue queue = AbstractXMPPConnection.this.deferredAsyncRunnables;
                synchronized (queue) {
                    Runnable defferredRunnable = (Runnable)AbstractXMPPConnection.this.deferredAsyncRunnables.poll();
                    if (defferredRunnable == null) {
                        AbstractXMPPConnection.this.currentAsyncRunnables--;
                    } else {
                        AbstractXMPPConnection.this.deferredAsyncRunnablesCount--;
                        AbstractXMPPConnection.asyncGo(defferredRunnable);
                    }
                }
            }
        };
        Queue<Runnable> queue = this.deferredAsyncRunnables;
        synchronized (queue) {
            if (this.currentAsyncRunnables < this.maxAsyncRunnables) {
                ++this.currentAsyncRunnables;
                AbstractXMPPConnection.asyncGo(wrappedRunnable);
            } else {
                ++this.deferredAsyncRunnablesCount;
                this.deferredAsyncRunnables.add(wrappedRunnable);
            }
            int HIGH_WATERMARK = 100;
            int INFORM_WATERMARK = 20;
            int deferredAsyncRunnablesCount = this.deferredAsyncRunnablesCount;
            if (deferredAsyncRunnablesCount >= 100 && this.deferredAsyncRunnablesCountPrevious < 100) {
                LOGGER.log(Level.WARNING, "High watermark of 100 simultaneous executing runnables reached");
            } else if (deferredAsyncRunnablesCount >= 20 && this.deferredAsyncRunnablesCountPrevious < 20) {
                LOGGER.log(Level.INFO, "20 simultaneous executing runnables reached");
            }
            this.deferredAsyncRunnablesCountPrevious = deferredAsyncRunnablesCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxAsyncOperations(int maxAsyncOperations) {
        if (maxAsyncOperations < 1) {
            throw new IllegalArgumentException("Max async operations must be greater than 0");
        }
        Queue<Runnable> queue = this.deferredAsyncRunnables;
        synchronized (queue) {
            this.maxAsyncRunnables = maxAsyncOperations;
        }
    }

    protected static void asyncGo(Runnable runnable) {
        CACHED_EXECUTOR_SERVICE.execute(runnable);
    }

    protected final SmackReactor getReactor() {
        return SMACK_REACTOR;
    }

    protected static ScheduledAction schedule(Runnable runnable, long delay, TimeUnit unit) {
        return SMACK_REACTOR.schedule(runnable, delay, unit, ScheduledAction.Kind.NonBlocking);
    }

    protected void onStreamOpen(XmlPullParser parser) {
        if ("jabber:client".equals(parser.getNamespace(null))) {
            this.streamId = parser.getAttributeValue("", "id");
            this.incomingStreamXmlEnvironment = XmlEnvironment.from(parser);
            String reportedServerDomainString = parser.getAttributeValue("", "from");
            if (reportedServerDomainString == null) {
                return;
            }
            try {
                DomainBareJid reportedServerDomain = JidCreate.domainBareFrom((String)reportedServerDomainString);
                DomainBareJid configuredXmppServiceDomain = this.config.getXMPPServiceDomain();
                if (!configuredXmppServiceDomain.equals((CharSequence)reportedServerDomain)) {
                    LOGGER.warning("Domain reported by server '" + reportedServerDomain + "' does not match configured domain '" + configuredXmppServiceDomain + "'");
                }
            }
            catch (XmppStringprepException e) {
                LOGGER.log(Level.WARNING, "XMPP service domain '" + reportedServerDomainString + "' as reported by server could not be transformed to a valid JID", e);
            }
        }
    }

    protected void sendStreamOpen() throws SmackException.NotConnectedException, InterruptedException {
        DomainBareJid to = this.getXMPPServiceDomain();
        String from = null;
        CharSequence localpart = this.config.getUsername();
        if (localpart != null) {
            from = XmppStringUtils.completeJidFrom((CharSequence)localpart, (CharSequence)to);
        }
        String id = this.getStreamId();
        StreamOpen streamOpen = new StreamOpen((CharSequence)to, from, id, this.config.getXmlLang(), StreamOpen.StreamContentNamespace.client);
        this.sendNonza(streamOpen);
        XmlEnvironment.Builder xmlEnvironmentBuilder = XmlEnvironment.builder();
        xmlEnvironmentBuilder.with(streamOpen);
        this.outgoingStreamXmlEnvironment = xmlEnvironmentBuilder.build();
    }

    protected final SmackTlsContext getSmackTlsContext() {
        return this.config.smackTlsContext;
    }

    static {
        SmackConfiguration.getVersion();
        CACHED_EXECUTOR_SERVICE = Executors.newCachedThreadPool(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable);
                thread.setName("Smack Cached Executor");
                thread.setDaemon(true);
                thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                    @Override
                    public void uncaughtException(Thread t, Throwable e) {
                        LOGGER.log(Level.WARNING, t + " encountered uncaught exception", e);
                    }
                });
                return thread;
            }
        });
        ASYNC_BUT_ORDERED = new AsyncButOrdered();
    }

    private static final class GenericInterceptorWrapper<MPB extends MessageOrPresenceBuilder<MP, MPB>, MP extends MessageOrPresence<MPB>> {
        private final Consumer<MPB> stanzaInterceptor;
        private final Predicate<MP> stanzaFilter;

        private GenericInterceptorWrapper(Consumer<MPB> stanzaInterceptor, Predicate<MP> stanzaFilter) {
            this.stanzaInterceptor = stanzaInterceptor;
            this.stanzaFilter = stanzaFilter;
        }

        private boolean filterMatches(MP stanza) {
            return this.stanzaFilter == null || this.stanzaFilter.test(stanza);
        }

        public Consumer<MPB> getInterceptor() {
            return this.stanzaInterceptor;
        }
    }

    @Deprecated
    protected static class InterceptorWrapper {
        private final StanzaListener packetInterceptor;
        private final StanzaFilter packetFilter;

        public InterceptorWrapper(StanzaListener packetInterceptor, StanzaFilter packetFilter) {
            this.packetInterceptor = packetInterceptor;
            this.packetFilter = packetFilter;
        }

        public boolean filterMatches(Stanza packet) {
            return this.packetFilter == null || this.packetFilter.accept(packet);
        }

        public StanzaListener getInterceptor() {
            return this.packetInterceptor;
        }
    }

    protected static class ListenerWrapper {
        private final StanzaListener packetListener;
        private final StanzaFilter packetFilter;

        public ListenerWrapper(StanzaListener packetListener, StanzaFilter packetFilter) {
            this.packetListener = packetListener;
            this.packetFilter = packetFilter;
        }

        public boolean filterMatches(Stanza packet) {
            return this.packetFilter == null || this.packetFilter.accept(packet);
        }

        public StanzaListener getListener() {
            return this.packetListener;
        }
    }

    protected static enum SyncPointState {
        initial,
        request_sent,
        successful;

    }
}

