/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.packet.FullyQualifiedElement;
import org.jivesoftware.smack.util.MultiMap;

public class XmppElementUtil {
    public static final Logger LOGGER = Logger.getLogger(XmppElementUtil.class.getName());

    public static QName getQNameFor(Class<? extends FullyQualifiedElement> fullyQualifiedElement) {
        String namespace;
        String element;
        try {
            Object qnameObject = fullyQualifiedElement.getField("QNAME").get(null);
            if (QName.class.isAssignableFrom(qnameObject.getClass())) {
                return (QName)qnameObject;
            }
            LOGGER.warning("The QNAME field of " + fullyQualifiedElement + " is not of type QNAME.");
        }
        catch (NoSuchFieldException e) {
            LOGGER.finer("The class " + fullyQualifiedElement + " has no static QNAME field. Consider adding one.");
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
            throw new IllegalArgumentException(e);
        }
        try {
            element = (String)fullyQualifiedElement.getField("ELEMENT").get(null);
            namespace = (String)fullyQualifiedElement.getField("NAMESPACE").get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new IllegalArgumentException("The class" + fullyQualifiedElement + " has no ELEMENT, NAMESPACE or QNAME member. Consider adding QNAME", e);
        }
        return new QName(namespace, element);
    }

    public static <E extends FullyQualifiedElement, R extends FullyQualifiedElement> List<R> getElementsFrom(MultiMap<QName, E> elementMap, Class<R> extensionElementClass) {
        QName qname = XmppElementUtil.getQNameFor(extensionElementClass);
        List<E> extensionElements = elementMap.getAll(qname);
        if (extensionElements.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<FullyQualifiedElement> res = new ArrayList<FullyQualifiedElement>(extensionElements.size());
        for (FullyQualifiedElement extensionElement : extensionElements) {
            FullyQualifiedElement e = (FullyQualifiedElement)extensionElementClass.cast(extensionElement);
            res.add(e);
        }
        return res;
    }
}

