/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import java.util.List;
import java.util.Locale;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.packet.AbstractIqBuilder;
import org.jivesoftware.smack.packet.EmptyResultIQ;
import org.jivesoftware.smack.packet.ErrorIQ;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IqData;
import org.jivesoftware.smack.packet.IqView;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.XmlStringBuilder;

public abstract class IQ
extends Stanza
implements IqView {
    public static final String IQ_ELEMENT = "iq";
    public static final String QUERY_ELEMENT = "query";
    private final QName childElementQName;
    private final String childElementName;
    private final String childElementNamespace;
    private Type type = Type.get;

    protected IQ(IQ iq) {
        super(iq);
        this.type = iq.getType();
        this.childElementName = iq.childElementName;
        this.childElementNamespace = iq.childElementNamespace;
        this.childElementQName = iq.childElementQName;
    }

    protected IQ(String childElementName, String childElementNamespace) {
        this(IqData.EMPTY, childElementName, childElementNamespace);
    }

    protected IQ(AbstractIqBuilder<?> iqBuilder, String childElementName, String childElementNamespace) {
        super(iqBuilder);
        this.type = iqBuilder.type;
        this.childElementName = childElementName;
        this.childElementNamespace = childElementNamespace;
        this.childElementQName = childElementName == null ? null : new QName(childElementNamespace, childElementName);
    }

    @Override
    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = Objects.requireNonNull(type, "type must not be null");
    }

    public boolean isRequestIQ() {
        switch (this.type) {
            case get: 
            case set: {
                return true;
            }
        }
        return false;
    }

    public boolean isResponseIQ() {
        return !this.isRequestIQ();
    }

    public final QName getChildElementQName() {
        return this.childElementQName;
    }

    public final String getChildElementName() {
        return this.childElementName;
    }

    public final String getChildElementNamespace() {
        return this.childElementNamespace;
    }

    @Override
    public final String getElementName() {
        return IQ_ELEMENT;
    }

    @Override
    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("IQ Stanza (");
        sb.append(this.getChildElementName()).append(' ').append(this.getChildElementNamespace());
        sb.append(") [");
        this.logCommonAttributes(sb);
        sb.append("type=").append((Object)this.type).append(',');
        sb.append(']');
        return sb.toString();
    }

    @Override
    public final XmlStringBuilder toXML(XmlEnvironment enclosingXmlEnvironment) {
        XmlStringBuilder buf = new XmlStringBuilder(this, enclosingXmlEnvironment);
        this.addCommonAttributes(buf);
        if (this.type == null) {
            buf.attribute("type", "get");
        } else {
            buf.attribute("type", this.type.toString());
        }
        buf.rightAngleBracket();
        this.appendInnerXml(buf);
        buf.closeElement(IQ_ELEMENT);
        return buf;
    }

    public final XmlStringBuilder getChildElementXML() {
        XmlStringBuilder xml = new XmlStringBuilder();
        this.appendInnerXml(xml);
        return xml;
    }

    private void appendInnerXml(XmlStringBuilder xml) {
        if (this.type == Type.error) {
            this.appendErrorIfExists(xml);
            return;
        }
        if (this.childElementName == null) {
            return;
        }
        IQChildElementXmlStringBuilder iqChildElement = this.getIQChildElementBuilder(new IQChildElementXmlStringBuilder(this));
        if (iqChildElement == null) {
            return;
        }
        xml.append(iqChildElement);
        List<ExtensionElement> extensionsXml = this.getExtensions();
        if (iqChildElement.isEmptyElement) {
            if (extensionsXml.isEmpty()) {
                xml.closeEmptyElement();
                return;
            }
            xml.rightAngleBracket();
        }
        xml.append(extensionsXml);
        xml.closeElement(iqChildElement.element);
    }

    protected abstract IQChildElementXmlStringBuilder getIQChildElementBuilder(IQChildElementXmlStringBuilder var1);

    public static IQ createResultIQ(IQ request) {
        return new EmptyResultIQ(request);
    }

    public static ErrorIQ createErrorResponse(IQ request, StanzaError error) {
        if (!request.isRequestIQ()) {
            throw new IllegalArgumentException("IQ must be of type 'set' or 'get'. Original IQ: " + request.toXML());
        }
        ErrorIQ result = new ErrorIQ(error);
        result.setStanzaId(request.getStanzaId());
        result.setFrom(request.getTo());
        result.setTo(request.getFrom());
        return result;
    }

    @Deprecated
    public static ErrorIQ createErrorResponse(IQ request, StanzaError.Builder error) {
        return IQ.createErrorResponse(request, error.build());
    }

    public static ErrorIQ createErrorResponse(IQ request, StanzaError.Condition condition) {
        return IQ.createErrorResponse(request, StanzaError.getBuilder(condition).build());
    }

    public static class IQChildElementXmlStringBuilder
    extends XmlStringBuilder {
        private final String element;
        private boolean isEmptyElement;

        private IQChildElementXmlStringBuilder(IQ iq) {
            this(iq.getChildElementName(), iq.getChildElementNamespace());
        }

        public IQChildElementXmlStringBuilder(ExtensionElement pe) {
            this(pe.getElementName(), pe.getNamespace());
        }

        private IQChildElementXmlStringBuilder(String element, String namespace) {
            this.prelude(element, namespace);
            this.element = element;
        }

        public void setEmptyElement() {
            this.isEmptyElement = true;
        }
    }

    public static enum ResponseType {
        result(Type.result),
        error(Type.error);

        final Type type;

        private ResponseType(Type type) {
            this.type = type;
        }

        Type getType() {
            return this.type;
        }
    }

    public static enum Type {
        get,
        set,
        result,
        error;


        public static Type fromString(String string) {
            return Type.valueOf(string.toLowerCase(Locale.US));
        }
    }
}

