/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.compress.packet;

import java.io.IOException;
import org.jivesoftware.smack.compress.packet.Failure;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.test.util.XmlAssertUtil;
import org.junit.Test;
import org.xml.sax.SAXException;

public class FailureTest {
    @Test
    public void simpleFailureTest() throws SAXException, IOException {
        Failure failure = new Failure(Failure.CompressFailureError.processing_failed);
        CharSequence xml = failure.toXML();
        String expectedXml = "<failure xmlns='http://jabber.org/protocol/compress'><processing-failed/></failure>";
        XmlAssertUtil.assertXmlSimilar((CharSequence)"<failure xmlns='http://jabber.org/protocol/compress'><processing-failed/></failure>", (CharSequence)xml.toString());
    }

    @Test
    public void withStanzaErrrorFailureTest() throws SAXException, IOException {
        StanzaError stanzaError = StanzaError.getBuilder().setCondition(StanzaError.Condition.bad_request).build();
        Failure failure = new Failure(Failure.CompressFailureError.setup_failed, stanzaError);
        CharSequence xml = failure.toXML();
        String expectedXml = "<failure xmlns='http://jabber.org/protocol/compress'><setup-failed/><error xmlns='jabber:client' type='modify'><bad-request xmlns='urn:ietf:params:xml:ns:xmpp-stanzas'/></error></failure>";
        XmlAssertUtil.assertXmlSimilar((CharSequence)"<failure xmlns='http://jabber.org/protocol/compress'><setup-failed/><error xmlns='jabber:client' type='modify'><bad-request xmlns='urn:ietf:params:xml:ns:xmpp-stanzas'/></error></failure>", (CharSequence)xml.toString());
    }
}

