/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.provider;

import java.util.ArrayList;
import java.util.Collection;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.provider.ExtensionProviderInfo;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.provider.IQProviderInfo;
import org.jivesoftware.smack.provider.IqProvider;
import org.jivesoftware.smack.provider.ProviderFileLoader;
import org.jivesoftware.smack.provider.ProviderLoader;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.provider.StreamFeatureProviderInfo;
import org.jivesoftware.smack.util.FileUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.junit.Assert;
import org.junit.Test;

public class ProviderConfigTest {
    @Test
    public void addGenericLoaderProvider() {
        ProviderManager.addLoader((ProviderLoader)new ProviderLoader(){

            public Collection<IQProviderInfo> getIQProviderInfo() {
                ArrayList<IQProviderInfo> l = new ArrayList<IQProviderInfo>(1);
                l.add(new IQProviderInfo("provider", "test:provider", (IqProvider)new TestIQProvider()));
                return l;
            }

            public Collection<ExtensionProviderInfo> getExtensionProviderInfo() {
                return null;
            }

            public Collection<StreamFeatureProviderInfo> getStreamFeatureProviderInfo() {
                return null;
            }
        });
        Assert.assertNotNull((Object)ProviderManager.getIQProvider((String)"provider", (String)"test:provider"));
    }

    @Test
    public void addClasspathFileLoaderProvider() throws Exception {
        ProviderManager.addLoader((ProviderLoader)new ProviderFileLoader(FileUtils.getStreamForClasspathFile((String)"test.providers", null)));
        Assert.assertNotNull((Object)ProviderManager.getIQProvider((String)"provider", (String)"test:file_provider"));
    }

    public static class TestIQProvider
    extends IQProvider<IQ> {
        public IQ parse(XmlPullParser parser, int initialDepth, XmlEnvironment xmlEnvironment) {
            return null;
        }
    }
}

