/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.provider;

import com.jamesmurty.utils.XMLBuilder;
import java.io.IOException;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.provider.SaslFailureProvider;
import org.jivesoftware.smack.sasl.SASLError;
import org.jivesoftware.smack.sasl.packet.SaslNonza;
import org.jivesoftware.smack.test.util.SmackTestUtil;
import org.jivesoftware.smack.test.util.XmlAssertUtil;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

public class SaslProviderTest {
    @ParameterizedTest
    @EnumSource(value=SmackTestUtil.XmlPullParserKind.class)
    public void parseSASLFailureSimple(SmackTestUtil.XmlPullParserKind parserKind) throws TransformerException, ParserConfigurationException, FactoryConfigurationError, XmlPullParserException, IOException, SmackParsingException {
        String saslFailureString = XMLBuilder.create((String)"failure", (String)"urn:ietf:params:xml:ns:xmpp-sasl").e(SASLError.account_disabled.toString()).asString();
        SaslNonza.SASLFailure saslFailure = (SaslNonza.SASLFailure)SmackTestUtil.parse((CharSequence)saslFailureString, SaslFailureProvider.class, (SmackTestUtil.XmlPullParserKind)parserKind);
        XmlAssertUtil.assertXmlSimilar((CharSequence)saslFailureString, (CharSequence)saslFailure.toString());
    }

    @ParameterizedTest
    @EnumSource(value=SmackTestUtil.XmlPullParserKind.class)
    public void parseSASLFailureExtended(SmackTestUtil.XmlPullParserKind parserKind) throws XmlPullParserException, IOException, SmackParsingException, TransformerException, ParserConfigurationException, FactoryConfigurationError {
        String saslFailureString = XMLBuilder.create((String)"failure", (String)"urn:ietf:params:xml:ns:xmpp-sasl").e(SASLError.account_disabled.toString()).up().e("text").a("xml:lang", "en").t("Call 212-555-1212 for assistance.").up().e("text").a("xml:lang", "de").t("Bitte wenden sie sich an (04321) 123-4444").up().e("text").t("Wusel dusel").asString();
        SaslNonza.SASLFailure saslFailure = (SaslNonza.SASLFailure)SmackTestUtil.parse((CharSequence)saslFailureString, SaslFailureProvider.class, (SmackTestUtil.XmlPullParserKind)parserKind);
        XmlAssertUtil.assertXmlSimilar((CharSequence)saslFailureString, (CharSequence)saslFailure.toXML("jabber:client"));
    }
}

