/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import org.jivesoftware.smack.packet.StandardExtensionElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.test.util.XmlAssertUtil;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.junit.jupiter.api.Test;

public class XmlStringBuilderTest {
    @Test
    public void equalInnerNamespaceTest() {
        StandardExtensionElement innerOne = StandardExtensionElement.builder((String)"inner", (String)"inner-namespace").build();
        StandardExtensionElement innerTwo = StandardExtensionElement.builder((String)"inner", (String)"inner-namespace").build();
        StandardExtensionElement outer = StandardExtensionElement.builder((String)"outer", (String)"outer-namespace").addElement(innerOne).addElement(innerTwo).build();
        String expectedXml = "<outer xmlns='outer-namespace'><inner xmlns='inner-namespace'></inner><inner xmlns='inner-namespace'></inner></outer>";
        XmlStringBuilder actualXml = outer.toXML(XmlEnvironment.EMPTY);
        XmlAssertUtil.assertXmlSimilar((CharSequence)expectedXml, (CharSequence)actualXml);
        StringBuilder actualXmlTwo = actualXml.toXML(XmlEnvironment.EMPTY);
        XmlAssertUtil.assertXmlSimilar((CharSequence)expectedXml, (CharSequence)actualXmlTwo);
    }
}

