/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.datatypes;

import org.jivesoftware.smack.datatypes.Scalar;
import org.jivesoftware.smack.util.NumberUtil;

public final class UInt32
extends Scalar {
    private static final long serialVersionUID = 1L;
    private final long number;

    private UInt32(long number) {
        super(NumberUtil.requireUInt32(number));
        this.number = number;
    }

    public long nativeRepresentation() {
        return this.number;
    }

    public static UInt32 from(long number) {
        return new UInt32(number);
    }

    @Override
    public int hashCode() {
        return (int)(this.number ^ this.number >>> 32);
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof UInt32) {
            UInt32 otherUint32 = (UInt32)other;
            return this.number == otherUint32.number;
        }
        return super.equals(other);
    }
}

