/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import java.util.List;
import java.util.Locale;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.MessageBuilder;
import org.jivesoftware.smack.packet.MessageOrPresence;
import org.jivesoftware.smack.packet.MessageView;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaBuilder;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.EqualsUtil;
import org.jivesoftware.smack.util.HashCode;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.stringprep.XmppStringprepException;

public final class Message
extends MessageOrPresence<MessageBuilder>
implements MessageView {
    public static final String ELEMENT = "message";
    public static final String BODY = "body";
    private Type type;

    @Deprecated
    public Message() {
    }

    @Deprecated
    public Message(Jid to) {
        this.setTo(to);
    }

    @Deprecated
    public Message(Jid to, Type type) {
        this(to);
        this.setType(type);
    }

    @Deprecated
    public Message(Jid to, String body) {
        this(to);
        this.setBody(body);
    }

    @Deprecated
    public Message(String to, String body) throws XmppStringprepException {
        this(JidCreate.from((String)to), body);
    }

    @Deprecated
    public Message(Jid to, ExtensionElement extensionElement) {
        this(to);
        this.addExtension(extensionElement);
    }

    Message(MessageBuilder messageBuilder) {
        super(messageBuilder);
        this.type = messageBuilder.type;
    }

    public Message(Message other) {
        super(other);
        this.type = other.type;
    }

    @Override
    public Type getType() {
        if (this.type == null) {
            return Type.normal;
        }
        return this.type;
    }

    @Deprecated
    public void setType(Type type) {
        this.type = type;
    }

    @Deprecated
    public void setSubject(String subject) {
        if (subject == null) {
            this.removeSubject("");
            return;
        }
        this.addSubject(null, subject);
    }

    @Deprecated
    public Subject addSubject(String language, String subject) {
        language = Stanza.determineLanguage(this, language);
        List<Subject> currentSubjects = this.getExtensions(Subject.class);
        for (Subject currentSubject : currentSubjects) {
            if (!language.equals(currentSubject.getLanguage())) continue;
            throw new IllegalArgumentException("Subject with the language " + language + " already exists");
        }
        Subject messageSubject = new Subject(language, subject);
        this.addExtension(messageSubject);
        return messageSubject;
    }

    @Deprecated
    public boolean removeSubject(String language) {
        language = Stanza.determineLanguage(this, language);
        for (Subject subject : this.getExtensions(Subject.class)) {
            if (!language.equals(subject.language)) continue;
            return this.removeSubject(subject);
        }
        return false;
    }

    @Deprecated
    public boolean removeSubject(Subject subject) {
        return this.removeExtension(subject) != null;
    }

    @Deprecated
    public void setBody(CharSequence body) {
        String bodyString = body != null ? body.toString() : null;
        this.setBody(bodyString);
    }

    @Deprecated
    public void setBody(String body) {
        if (body == null) {
            this.removeBody("");
            return;
        }
        this.addBody(null, body);
    }

    @Deprecated
    public Body addBody(String language, String body) {
        language = Stanza.determineLanguage(this, language);
        this.removeBody(language);
        Body messageBody = new Body(language, body);
        this.addExtension(messageBody);
        return messageBody;
    }

    @Deprecated
    public boolean removeBody(String language) {
        language = Stanza.determineLanguage(this, language);
        for (Body body : this.getBodies()) {
            String bodyLanguage = body.getLanguage();
            if (!Objects.equals(bodyLanguage, language)) continue;
            this.removeExtension(body);
            return true;
        }
        return false;
    }

    @Deprecated
    public boolean removeBody(Body body) {
        ExtensionElement removedElement = this.removeExtension(body);
        return removedElement != null;
    }

    @Deprecated
    public void setThread(String thread) {
        this.addExtension(new Thread(thread));
    }

    @Override
    public String getElementName() {
        return ELEMENT;
    }

    @Override
    public MessageBuilder asBuilder() {
        return StanzaBuilder.buildMessageFrom(this, this.getStanzaId());
    }

    @Override
    public MessageBuilder asBuilder(String id) {
        return StanzaBuilder.buildMessageFrom(this, id);
    }

    @Override
    public MessageBuilder asBuilder(XMPPConnection connection) {
        return connection.getStanzaFactory().buildMessageStanzaFrom(this);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Message Stanza [");
        this.logCommonAttributes(sb);
        if (this.type != null) {
            sb.append("type=").append((Object)this.type).append(',');
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public XmlStringBuilder toXML(XmlEnvironment enclosingXmlEnvironment) {
        XmlStringBuilder buf = new XmlStringBuilder(this, enclosingXmlEnvironment);
        this.addCommonAttributes(buf);
        buf.optAttribute("type", this.type);
        buf.rightAngleBracket();
        if (this.type == Type.error) {
            this.appendErrorIfExists(buf);
        }
        buf.append(this.getExtensions());
        buf.closeElement(ELEMENT);
        return buf;
    }

    @Deprecated
    public Message clone() {
        return new Message(this);
    }

    public static enum Type {
        normal,
        chat,
        groupchat,
        headline,
        error;


        public static Type fromString(String string) {
            return Type.valueOf(string.toLowerCase(Locale.US));
        }
    }

    public static class Thread
    implements ExtensionElement {
        public static final String ELEMENT = "thread";
        public static final String NAMESPACE = "jabber:client";
        public static final QName QNAME = new QName("jabber:client", "thread");
        public static final String PARENT_ATTRIBUTE_NAME = "parent";
        private final String thread;
        private final String parent;

        public Thread(String thread) {
            this(thread, null);
        }

        public Thread(String thread, String parent) {
            this.thread = StringUtils.requireNotNullNorEmpty(thread, "thread must not be null nor empty");
            this.parent = StringUtils.requireNullOrNotEmpty(parent, "parent must be null or not empty");
        }

        public String getThread() {
            return this.thread;
        }

        public String getParent() {
            return this.parent;
        }

        @Override
        public String getElementName() {
            return ELEMENT;
        }

        @Override
        public String getNamespace() {
            return NAMESPACE;
        }

        @Override
        public QName getQName() {
            return QNAME;
        }

        @Override
        public XmlStringBuilder toXML(XmlEnvironment xmlEnvironment) {
            XmlStringBuilder xml = new XmlStringBuilder(this, xmlEnvironment);
            xml.optAttribute(PARENT_ATTRIBUTE_NAME, this.parent);
            xml.rightAngleBracket();
            xml.escape(this.thread);
            xml.closeElement(this);
            return xml;
        }
    }

    public static final class Body
    implements ExtensionElement {
        public static final String ELEMENT = "body";
        public static final String NAMESPACE = "jabber:client";
        public static final QName QNAME = new QName("jabber:client", "body");
        private final String message;
        private final String language;
        private final BodyElementNamespace namespace;
        private final HashCode.Cache hashCodeCache = new HashCode.Cache();

        public Body(String language, String message) {
            this(language, message, BodyElementNamespace.client);
        }

        public Body(String language, String message, BodyElementNamespace namespace) {
            if (message == null) {
                throw new NullPointerException("Message cannot be null.");
            }
            this.language = language;
            this.message = message;
            this.namespace = Objects.requireNonNull(namespace);
        }

        @Override
        public String getLanguage() {
            return this.language;
        }

        public String getMessage() {
            return this.message;
        }

        public int hashCode() {
            return this.hashCodeCache.getHashCode(c -> c.append(this.language).append(this.message));
        }

        public boolean equals(Object obj) {
            return EqualsUtil.equals(this, obj, (e, o) -> e.append(this.language, o.language).append(this.message, o.message));
        }

        @Override
        public String getElementName() {
            return "body";
        }

        @Override
        public String getNamespace() {
            return this.namespace.xmlNamespace;
        }

        @Override
        public XmlStringBuilder toXML(XmlEnvironment enclosingXmlEnvironment) {
            XmlStringBuilder xml = new XmlStringBuilder(this, enclosingXmlEnvironment);
            xml.rightAngleBracket();
            xml.escape(this.message);
            xml.closeElement(this.getElementName());
            return xml;
        }

        static enum BodyElementNamespace {
            client("jabber:client"),
            server("jabber:server");

            private final String xmlNamespace;

            private BodyElementNamespace(String xmlNamespace) {
                this.xmlNamespace = xmlNamespace;
            }

            public String getNamespace() {
                return this.xmlNamespace;
            }
        }
    }

    public static final class Subject
    implements ExtensionElement {
        public static final String ELEMENT = "subject";
        public static final String NAMESPACE = "jabber:client";
        public static final QName QNAME = new QName("jabber:client", "subject");
        private final String subject;
        private final String language;
        private final HashCode.Cache hashCodeCache = new HashCode.Cache();

        public Subject(String language, String subject) {
            if (subject == null) {
                throw new NullPointerException("Subject cannot be null.");
            }
            this.language = language;
            this.subject = subject;
        }

        @Override
        public String getLanguage() {
            return this.language;
        }

        public String getSubject() {
            return this.subject;
        }

        public int hashCode() {
            return this.hashCodeCache.getHashCode(c -> c.append(this.language).append(this.subject));
        }

        public boolean equals(Object obj) {
            return EqualsUtil.equals(this, obj, (e, o) -> e.append(this.language, o.language).append(this.subject, o.subject));
        }

        @Override
        public String getElementName() {
            return ELEMENT;
        }

        @Override
        public String getNamespace() {
            return NAMESPACE;
        }

        @Override
        public XmlStringBuilder toXML(XmlEnvironment enclosingNamespace) {
            XmlStringBuilder xml = new XmlStringBuilder(this, enclosingNamespace);
            xml.rightAngleBracket();
            xml.escape(this.subject);
            xml.closeElement(this.getElementName());
            return xml;
        }
    }
}

