/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import java.util.Collection;
import java.util.List;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IqData;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.MessageBuilder;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.PresenceBuilder;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.packet.StanzaView;
import org.jivesoftware.smack.packet.id.StanzaIdSource;
import org.jivesoftware.smack.util.Function;
import org.jivesoftware.smack.util.MultiMap;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.ToStringUtil;
import org.jivesoftware.smack.util.XmppElementUtil;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.stringprep.XmppStringprepException;

public abstract class StanzaBuilder<B extends StanzaBuilder<B>>
implements StanzaView {
    final StanzaIdSource stanzaIdSource;
    final String stanzaId;
    Jid to;
    Jid from;
    StanzaError stanzaError;
    String language;
    MultiMap<QName, ExtensionElement> extensionElements = new MultiMap();

    protected StanzaBuilder(StanzaBuilder<?> other) {
        this.stanzaIdSource = other.stanzaIdSource;
        this.stanzaId = other.stanzaId;
        this.to = other.to;
        this.from = other.from;
        this.stanzaError = other.stanzaError;
        this.language = other.language;
        this.extensionElements = other.extensionElements.clone();
    }

    protected StanzaBuilder(StanzaIdSource stanzaIdSource) {
        this.stanzaIdSource = stanzaIdSource;
        this.stanzaId = null;
    }

    protected StanzaBuilder(String stanzaId) {
        this.stanzaIdSource = null;
        this.stanzaId = StringUtils.requireNullOrNotEmpty(stanzaId, "Stanza ID must not be the empty String");
    }

    protected StanzaBuilder(Stanza message, String stanzaId) {
        this(stanzaId);
        super.copyFromStanza(message);
    }

    protected StanzaBuilder(Stanza message, StanzaIdSource stanzaIdSource) {
        this(stanzaIdSource);
        super.copyFromStanza(message);
    }

    private void copyFromStanza(Stanza stanza) {
        this.to = stanza.getTo();
        this.from = stanza.getFrom();
        this.stanzaError = stanza.getError();
        this.language = stanza.getLanguage();
        this.extensionElements = stanza.cloneExtensionsMap();
    }

    public final B to(CharSequence to) throws XmppStringprepException {
        return this.to(JidCreate.from((CharSequence)to));
    }

    public final B to(Jid to) {
        this.to = to;
        return this.getThis();
    }

    public final B from(CharSequence from) throws XmppStringprepException {
        return this.from(JidCreate.from((CharSequence)from));
    }

    public final B from(Jid from) {
        this.from = from;
        return this.getThis();
    }

    public final B setError(StanzaError stanzaError) {
        this.stanzaError = stanzaError;
        return this.getThis();
    }

    public final B setLanguage(String language) {
        this.language = language;
        return this.getThis();
    }

    public final B addExtension(ExtensionElement extensionElement) {
        QName key = extensionElement.getQName();
        this.extensionElements.put(key, extensionElement);
        return this.getThis();
    }

    public final B addOptExtensions(Collection<? extends ExtensionElement> extensionElements) {
        if (extensionElements == null) {
            return this.getThis();
        }
        return this.addExtensions(extensionElements);
    }

    public final B addExtensions(Collection<? extends ExtensionElement> extensionElements) {
        for (ExtensionElement extensionElement : extensionElements) {
            this.addExtension(extensionElement);
        }
        return this.getThis();
    }

    public final B overrideExtension(ExtensionElement extensionElement) {
        QName key = extensionElement.getQName();
        this.extensionElements.remove(key);
        this.extensionElements.put(key, extensionElement);
        return this.getThis();
    }

    public abstract Stanza build();

    public abstract B getThis();

    @Override
    public final String getStanzaId() {
        return this.stanzaId;
    }

    @Override
    public final Jid getTo() {
        return this.to;
    }

    @Override
    public final Jid getFrom() {
        return this.from;
    }

    @Override
    public final String getLanguage() {
        return this.language;
    }

    @Override
    public final StanzaError getError() {
        return this.stanzaError;
    }

    @Override
    public final ExtensionElement getExtension(QName qname) {
        return this.extensionElements.getFirst(qname);
    }

    @Override
    public final List<ExtensionElement> getExtensions() {
        return this.extensionElements.values();
    }

    @Override
    public final List<ExtensionElement> getExtensions(QName qname) {
        return this.extensionElements.getAll(qname);
    }

    @Override
    public final <E extends ExtensionElement> List<E> getExtensions(Class<E> extensionElementClass) {
        return XmppElementUtil.getElementsFrom(this.extensionElements, extensionElementClass);
    }

    public final boolean willBuildStanzaWithId() {
        return this.stanzaIdSource != null || StringUtils.isNotEmpty((CharSequence)this.stanzaId);
    }

    public final void throwIfNoStanzaId() {
        if (this.willBuildStanzaWithId()) {
            return;
        }
        throw new IllegalArgumentException("The builder will not build a stanza with an ID set, although it is required");
    }

    protected abstract void addStanzaSpecificAttributes(ToStringUtil.Builder var1);

    public final String toString() {
        ToStringUtil.Builder builder = ToStringUtil.builderFor(this.getClass()).addValue("id", this.stanzaId).addValue("from", this.from).addValue("to", this.to).addValue("language", this.language).addValue("error", this.stanzaError);
        this.addStanzaSpecificAttributes(builder);
        builder.add("Extension Elements", this.extensionElements.values(), e -> e.getQName());
        return builder.build();
    }

    public static MessageBuilder buildMessage() {
        return StanzaBuilder.buildMessage(null);
    }

    public static MessageBuilder buildMessage(String stanzaId) {
        return new MessageBuilder(stanzaId);
    }

    public static MessageBuilder buildMessageFrom(Message message, String stanzaId) {
        return new MessageBuilder(message, stanzaId);
    }

    public static MessageBuilder buildMessageFrom(Message message, StanzaIdSource stanzaIdSource) {
        return new MessageBuilder(message, stanzaIdSource);
    }

    public static PresenceBuilder buildPresence() {
        return StanzaBuilder.buildPresence(null);
    }

    public static PresenceBuilder buildPresence(String stanzaId) {
        return new PresenceBuilder(stanzaId);
    }

    public static PresenceBuilder buildPresenceFrom(Presence presence, String stanzaId) {
        return new PresenceBuilder(presence, stanzaId);
    }

    public static PresenceBuilder buildPresenceFrom(Presence presence, StanzaIdSource stanzaIdSource) {
        return new PresenceBuilder(presence, stanzaIdSource);
    }

    public static IqData buildIqData(String stanzaId) {
        return new IqData(stanzaId);
    }

    public static <SB extends StanzaBuilder<?>> SB buildResponse(StanzaView request, Function<SB, String> builderFromStanzaId) {
        StanzaBuilder responseBuilder = (StanzaBuilder)builderFromStanzaId.apply(request.getStanzaId());
        ((StanzaBuilder)responseBuilder.to(request.getFrom())).from(request.getTo());
        return (SB)responseBuilder;
    }
}

