/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.test.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.function.Predicate;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.packet.Element;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.provider.Provider;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smack.xml.XmlPullParserFactory;
import org.jivesoftware.smack.xml.stax.StaxXmlPullParserFactory;
import org.jivesoftware.smack.xml.xpp3.Xpp3XmlPullParserFactory;

public class SmackTestUtil {
    public static <E extends Element, P extends Provider<E>> E parse(CharSequence xml, Class<P> providerClass, XmlPullParserKind parserKind) throws XmlPullParserException, IOException, SmackParsingException {
        P provider = SmackTestUtil.providerClassToProvider(providerClass);
        return SmackTestUtil.parse(xml, provider, parserKind);
    }

    public static <E extends Element, P extends Provider<E>> E parse(InputStream inputStream, Class<P> providerClass, XmlPullParserKind parserKind) throws XmlPullParserException, IOException, SmackParsingException {
        P provider = SmackTestUtil.providerClassToProvider(providerClass);
        return SmackTestUtil.parse(inputStream, provider, parserKind);
    }

    public static <E extends Element, P extends Provider<E>> E parse(Reader reader, Class<P> providerClass, XmlPullParserKind parserKind) throws XmlPullParserException, IOException, SmackParsingException {
        P provider = SmackTestUtil.providerClassToProvider(providerClass);
        return SmackTestUtil.parse(reader, provider, parserKind);
    }

    public static <E extends Element> E parse(CharSequence xml, Provider<E> provider, XmlPullParserKind parserKind) throws XmlPullParserException, IOException, SmackParsingException {
        String xmlString = xml.toString();
        StringReader reader = new StringReader(xmlString);
        return SmackTestUtil.parse((Reader)reader, provider, parserKind);
    }

    public static <E extends Element> E parse(InputStream inputStream, Provider<E> provider, XmlPullParserKind parserKind) throws XmlPullParserException, IOException, SmackParsingException {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
        return SmackTestUtil.parse((Reader)inputStreamReader, provider, parserKind);
    }

    public static <E extends Element> E parse(Reader reader, Provider<E> provider, XmlPullParserKind parserKind) throws XmlPullParserException, IOException, SmackParsingException {
        XmlPullParser parser = SmackTestUtil.getParserFor(reader, parserKind);
        Element element = provider.parse(parser);
        return (E)element;
    }

    public static XmlPullParser getParserFor(String xml, XmlPullParserKind parserKind) throws XmlPullParserException, IOException {
        StringReader reader = new StringReader(xml);
        return SmackTestUtil.getParserFor(reader, parserKind);
    }

    public static XmlPullParser getParserFor(InputStream inputStream, XmlPullParserKind parserKind) throws XmlPullParserException, IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
        return SmackTestUtil.getParserFor(inputStreamReader, parserKind);
    }

    public static XmlPullParser getParserFor(Reader reader, XmlPullParserKind parserKind) throws XmlPullParserException, IOException {
        XmlPullParser parser = parserKind.factory.newXmlPullParser(reader);
        SmackTestUtil.forwardParserToStartElement(parser);
        return parser;
    }

    public static XmlPullParser getParserFor(String xml, QName startTagQName, XmlPullParserKind parserKind) throws XmlPullParserException, IOException {
        XmlPullParser parser = SmackTestUtil.getParserFor(xml, parserKind);
        SmackTestUtil.forwardParserToStartElement(parser, p -> p.getQName().equals(startTagQName));
        return parser;
    }

    public static XmlPullParser getParserFor(String xml, String startTagLocalpart, XmlPullParserKind parserKind) throws XmlPullParserException, IOException {
        XmlPullParser parser = SmackTestUtil.getParserFor(xml, parserKind);
        SmackTestUtil.forwardParserToStartElement(parser, p -> p.getName().equals(startTagLocalpart));
        return parser;
    }

    private static <E extends Element, P extends Provider<E>> P providerClassToProvider(Class<P> providerClass) {
        Provider provider;
        try {
            Provider provider2 = (Provider)providerClass.getDeclaredField("INSTANCE").get(null);
            return (P)provider2;
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
            throw new AssertionError((Object)e);
        }
        try {
            provider = (Provider)providerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
        return (P)provider;
    }

    private static void forwardParserToStartElement(XmlPullParser parser) throws XmlPullParserException, IOException {
        SmackTestUtil.forwardParserToStartElement(parser, p -> true);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void forwardParserToStartElement(XmlPullParser parser, Predicate<XmlPullParser> doneForwarding) throws XmlPullParserException, IOException {
        while (true) {
            XmlPullParser.Event event = parser.getEventType();
            switch (event) {
                case START_ELEMENT: {
                    if (!doneForwarding.test(parser)) break;
                    return;
                }
                case END_DOCUMENT: {
                    throw new IllegalArgumentException("Not matching START_ELEMENT found");
                }
            }
            parser.next();
        }
    }

    public static enum XmlPullParserKind {
        StAX(StaxXmlPullParserFactory.class),
        XPP3(Xpp3XmlPullParserFactory.class);

        public final XmlPullParserFactory factory;

        private XmlPullParserKind(Class<? extends XmlPullParserFactory> factoryClass) {
            try {
                this.factory = factoryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new AssertionError((Object)e);
            }
        }
    }
}

